package fr.univvalenciennes.publi.application.admin.servlets;

import java.io.*;
import java.rmi.RemoteException;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.rpc.ServiceException;
import java.net.URL;
import org.apache.log4j.*;

import fr.univvalenciennes.publi.utils.properties.*;

import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;

public class MenuProfServlet extends HttpServlet {
	static Logger log = Logger.getLogger(MenuServlet.class);
	public String uidUser;
	PrintWriter out;
	
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {

		new PropertiesManager("applinews.properties");
		String logConfFile = PropertiesManager.getProperty("logConfFile");
		PropertyConfigurator.configure(logConfFile);

		// obtention d'un flux de sortie
		out = res.getWriter();

		String choix=null;
		
		log.info("** MenuProfServlet - Recuperation de l'action validee par l'utilisateur ...");
		
		choix = RequestParser.getChoixProf(req,res);
		log.info("** MenuProfServlet - choix : " + choix);
		this.actionChoix(req,res,choix);
	}
	
	private void actionChoix(HttpServletRequest req, HttpServletResponse res, String choix){
		ProfilsServicesService profService;
		AdminProfilsSoapBindingStub profStub;
		CategoriesServicesService catService;
		AdminCategoriesSoapBindingStub catStub;
		
		try {
			profService = new ProfilsServicesServiceLocator();
			profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));
			catService = new CategoriesServicesServiceLocator();
			catStub = (AdminCategoriesSoapBindingStub) catService.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
		
			req.getSession().setAttribute("profstub", profStub);
			req.getSession().setAttribute("catstub", catStub);
			
			if (choix.equals("formCreer")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION D'UN PROFIL
				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formCreationProf.jsp").forward(req, res);
			}

			if (choix.equals("formModifier")) {
				// AFFICHAGE DU FORMULAIRE DE MODIFICATION D'UN PROFIL
				// On rcupre les attributs du profil pour l'fr.univvalenciennes.publi.application.admin.affichage 
				// par dfaut dans le formulaire
				req.setAttribute("uidprof",req.getParameter("uidprofselect"));
				req.setAttribute("caption",profStub.getCaptionProfils(req.getParameter("uidprofselect")));
				req.setAttribute("admcats",(profStub.getAdmCatsProfils(req.getParameter("uidprofselect"))? "o": "n"));
				req.setAttribute("admnews",(profStub.getAdmNewsProfils(req.getParameter("uidprofselect"))? "o": "n"));
				req.setAttribute("admprofils",(profStub.getAdmProfilsProfils(req.getParameter("uidprofselect"))? "o": "n"));
				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formModifProf.jsp").forward(req, res);
			}

			if (choix.equals("Creation")) {
				// CREATION D'UN PROFIL
				// on rcupre le paramtre "admcats"
				String rp[] = req.getParameterValues("admcats");
				boolean admcats = false;
				if (rp != null)
					if (rp[0].equals("o"))	admcats = true;
				// on rcupre le paramtre "admnews"
				rp = req.getParameterValues("admnews");
				boolean admnews = false;
				if (rp != null)
					if (rp[0].equals("o"))	admnews = true;
				// on rcupre le paramtre "admprofils"
				rp = req.getParameterValues("admprofils");
				boolean admprofils = false;
				if (rp != null)
					if (rp[0].equals("o"))	admprofils = true;
				// on rcupre le paramtre "uidprof"
				String uidProf =req.getParameter("uidprof").toUpperCase();
				
				// si caption n'est pas renseign, on y met l'uidprof
				String caption = req.getParameter("caption");
				if (caption.length() == 0)	caption = uidProf;
				if (profStub.profExiste(uidProf)) {
					// si un profil possde dj cet uid, erreur
					erreur("profil existe", uidProf, req, res,catStub,profStub);
				} else {
					// cration du profil dans la base
					profStub.createProfils(uidProf,caption,admcats,admnews,admprofils);
					// retour  la liste des profils
					getServletConfig().getServletContext().getRequestDispatcher("/listeProfils.jsp").forward(req, res);
				}
			}

			if (choix.equals("Modification")) {
				// MODIFICATION D'UN PROFIL

				// on rcupre le paramtre "admcats"
				String rp[] = req.getParameterValues("admcats");
				boolean admcats = false;
				if (rp != null)
					if (rp[0].equals("o"))	admcats = true;

				// on rcupre le paramtre "admnews"
				rp = req.getParameterValues("admnews");
				boolean admnews = false;
				if (rp != null)
					if (rp[0].equals("o"))	admnews = true;

				// on rcupre le paramtre "admprofils"
				rp = req.getParameterValues("admprofils");
				boolean admprofils = false;
				if (rp != null)
					if (rp[0].equals("o"))	admprofils = true;

				// modification du profil dans la base
				profStub.modifProfils(req.getParameter("uidprof"),req.getParameter("caption"),admcats,admnews,admprofils);

				// retour  la liste des profils
				getServletConfig().getServletContext().getRequestDispatcher("/listeProfils.jsp").forward(req, res);
			}

			if (choix.equals("Supprimer")) {
				// SUPPRESSION D'UN PROFIL
						
				// on rcupre l'uidprof
				String uidProfSelect =	req.getParameter("uidprofselect");

				// on vrifie qu'aucun utilisateur ne possde ce profil
				if (profStub.getProfilUsers(uidProfSelect).isEmpty()) {
					// suppresion du profil
					profStub.deleteProfils(uidProfSelect);
							
					// retour  la liste des profils
					getServletConfig().getServletContext().getRequestDispatcher("/listeProfils.jsp").forward(req, res);
				} else {
					// imposible de supprimer le profil
					erreur("utilisateurs attaches",uidProfSelect,req,res,catStub,profStub);
				}
			}

			if (choix.equals("Utilisateurs")) {
				// AFFICHAGE DE LA LISTE DES UTILISATEURS D'UN PROFIL
						
				// on rcupre le profil choisi
				req.getSession().setAttribute("uidprofselect",req.getParameter("uidprofselect"));
							
				// redirection vers la liste des utilisateurs
				getServletConfig().getServletContext().getRequestDispatcher("/listeUtilisateurs.jsp").forward(req, res);
			}

			if (choix.equals("formCreerUser")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION D'UN UTILISATEUR

				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formProfCreationUser.jsp").forward(req, res);
			}

			if (choix.equals("CreationUser")) {
				// CREATION D'UN UTILISATEUR
				// on rcupre les donnes du formulaire
				String uidUserSelect =req.getParameter("uiduser").toUpperCase();
				String nomComplet = req.getParameter("nomcomplet");
				if (nomComplet.length() == 0)	nomComplet = uidUserSelect;
						
				if (profStub.userExiste(uidUserSelect)) {
					// si un profil possde dj cet uid, erreur
					erreur("utilisateur existe",uidUserSelect,req,res,catStub,profStub);
				} else {
					// cration de l'utilisateur dans la base
					profStub.createUsers(uidUserSelect,(String)req.getParameter("uidprofselect"),nomComplet);
					getServletConfig().getServletContext().getRequestDispatcher("/listeUtilisateurs.jsp").forward(req, res);
				}
			}

			if (choix.equals("formModifierUser")) {
				// AFFICHAGE DU FORMULAIRE DE MODIFICATION D'UN UTILISATEUR

				// on rcupre les paramtres  afficher dans le formulaire
				req.setAttribute("uiduserselect", req.getParameter("uiduserselect"));
				req.setAttribute("nomcomplet",profStub.getNomCompletUser(req.getParameter("uiduserselect")));
				req.setAttribute("uidprofselect",req.getParameter("uidprofselect"));
				//req.setAttribute("uidprofselect",profStub.getProfils(req.getParameter("uiduserselect")));

				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formProfModifUser.jsp").forward(req, res);
			}

			if (choix.equals("ModifUser")) {
				// MODIFICATION D'UN UTILISATEUR
						
				// modification dans la base
				profStub.modifUsers(req.getParameter("uiduserselect"),req.getParameter("uidprofselect"),req.getParameter("nomcomplet"));

				// retour  la liste des utilisateurs
				getServletConfig().getServletContext().getRequestDispatcher("/listeUtilisateurs.jsp").forward(req, res);
			}

			if (choix.equals("SupprimerUser")) {
				// SUPPRESSION D'UN UTILISATEUR
						
				// on rcupre l'uiduser
				String uidUserSelect =(String)req.getParameter("uiduserselect");
				String uidProfSelect =(String)req.getParameter("uidprofselect");
							
				log.info("MenuProfServlet::suppression du profil "+uidProfSelect+" pour l'utilisateur "+uidUserSelect);
				// suppression dans la base
				//profStub.deleteUsers(uidUserSelect);
				profStub.removeProfilToUser(uidUserSelect,uidProfSelect);
						
				// retour  la liste des utilisateurs
				getServletConfig().getServletContext().getRequestDispatcher("/listeUtilisateurs.jsp").forward(req, res);
			}

			if (choix.equals("Categories")) {
				// AFFICHAGE DE LA LISTE DES CATEGORIES ATTACHEES A UN PROFIL

				// on rcupre le profil choisi
				req.getSession().setAttribute("uidprofselect",req.getParameter("uidprofselect"));
							
				// redirection vers la liste des categories
				getServletConfig().getServletContext().getRequestDispatcher("/listeCategoriesAttachees.jsp").forward(req, res);
			}

			/********** Gestion des Catgories attaches au profil ********/
			if (choix.equals("formAttacherCatProfil")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION DE LIEN
				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formAttacherCatProfil.jsp").forward(req, res);
			}

			if (choix.equals("Attacher")) {
				// CREATION D'UN LIEN
						
				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |.
				String catEtCatMere = req.getParameter("categorie");
				String uidCat, uidCatMere;
				int i = catEtCatMere.indexOf("|");
				uidCat =catEtCatMere.substring(i + 1,catEtCatMere.length());

				// cration du lien dans la base
				profStub.createCatsProfils((String)req.getSession().getAttribute("uidprofselect"),uidCat);
							
				// mise  jour de l'arbre affich
				req.getSession().setAttribute("canauxprofils",null);
						
				// retour  la liste des catgories attaches
				getServletConfig().getServletContext().getRequestDispatcher("/listeCategoriesAttachees.jsp").forward(req, res);
			}

			if (choix.equals("DetacherCategorie")) {
				// SUPPRESSION D'UN LIEN
						
				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |.
				String catEtCatMere = req.getParameter("categorie");
				String uidCat;
				int i = catEtCatMere.indexOf("|");
				uidCat =catEtCatMere.substring(i + 1,catEtCatMere.length());
								
				// suppression dans la base
				profStub.deleteCatsProfils((String)req.getSession().getAttribute("uidprofselect"),uidCat);
							
				// mise  jour de l'arbre affich
				req.getSession().setAttribute("canauxprofils",null);
						
				// retour  la liste des catgories attaches
				getServletConfig().getServletContext().getRequestDispatcher("/listeCategoriesAttachees.jsp").forward(req, res);
			}
		}catch (ServiceException e){
			// TODO
		} catch (RemoteException e) {
			// TODO
		} catch (ServletException e) {
			// TODO
		} catch (IOException e) {
			// TODO
		} finally {
			out.close();
		}
	}
	
	public void erreur(String er,String uid,HttpServletRequest req,HttpServletResponse res,AdminCategoriesSoapBindingStub catStub,AdminProfilsSoapBindingStub profStub)
		throws ServletException, IOException {
		if (er.equals("profil existe")) {
			req.setAttribute(
				"message",
				"Il existe dj un utilisateur possdant l'identifiant \""
					+ uid
					+ "\". <br>Veuillez choisir un autre identifiant.");
			req.setAttribute("retour", "listeProfils.jsp");
			getServletConfig()
				.getServletContext()
				.getRequestDispatcher("/erreur.jsp")
				.forward(req, res);
			if (out != null)
				out.close();
		}
		if (er.equals("utilisateurs attaches")) {
			req.setAttribute(
				"message",
				"Impossible de supprimer le profil \""
					+ profStub.getCaptionProfils(uid)
					+ "\" : vous devez supprimer tous les utilisateurs possdant ce profil avant de le supprimer");
			req.setAttribute("retour", "listeProfils.jsp");
			getServletConfig()
				.getServletContext()
				.getRequestDispatcher("/erreur.jsp")
				.forward(req, res);
			if (out != null)
				out.close();
		}
		if (er.equals("autre")) {
			req.setAttribute(
				"message",
				"Une erreur s'est produite. Veuillez ressayer plus tard.");
			req.setAttribute("retour", "listeProfils.jsp");
			getServletConfig()
				.getServletContext()
				.getRequestDispatcher("/erreur.html")
				.forward(req, res);
			if (out != null)
				out.close();
		}

	}

}