package fr.univvalenciennes.publi.application.admin.servlets;

import java.io.*;
import java.rmi.RemoteException;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.rpc.ServiceException;

import org.apache.log4j.*;

import fr.univvalenciennes.publi.utils.properties.*;

import fr.univvalenciennes.publi.wsclient.Administration.Categories.AdminCategoriesSoapBindingStub;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;

import java.net.URL;


public class MenuServlet extends HttpServlet {
	static Logger log = Logger.getLogger(MenuServlet.class);
	public String uidUser;
	PrintWriter out;
	
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {

		new PropertiesManager("applinews.properties");
		String logConfFile = PropertiesManager.getProperty("logConfFile");
		PropertyConfigurator.configure(logConfFile);

		// obtention d'un flux de sortie
		out = res.getWriter();

		String choix=null;
		
		log.debug("** MenuServlet - Recuperation de l'action validee par l'utilisateur ...");
		
		choix = RequestParser.getChoix(req,res);
		
		log.debug("** MenuServlet - choix : " + choix);
		
		this.actionChoix(req,res,choix);
		
		out.close();
	}
	
	private void actionChoix(HttpServletRequest req, HttpServletResponse res, String choix){
		ProfilsServicesService profService;
		AdminProfilsSoapBindingStub profStub;
		
		try {
			profService = new ProfilsServicesServiceLocator();
			profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));

			req.getSession().setAttribute("profstub", profStub);
	
			// on met en session l'attribut "uiduser"
			String uidUser = req.getParameter("uiduser");
			log.debug("** MenuServlet - utilisateur " + uidUser + " ...");
			req.getSession().setAttribute("uiduser", uidUser);
					
			// on vrifie que l'utilisateur a le droit d'utiliser cette application
			// puis le redirige vers la partie choisie
			log.debug("** MenuServlet - Vrification des droits de l'utilisateur " + uidUser + " ...");
			if (profStub.getAdmCatsUsers(uidUser)) {
				req.setAttribute("uiduser", uidUser);
				log.debug("** MenuServlet - l'utilisateur " + uidUser + " a le droit d'administrer les categories ...");
				
				if (choix.equals("categories")){
					log.debug("** MenuServlet - redirection vers la partie Categories");
					try {
						log.debug("** MenuServlet - redirection vers /listeCategories.jsp");
						getServletConfig().getServletContext().getRequestDispatcher("/listeCategories.jsp").forward(req, res);
					} catch (Exception e) {
						log.error("** MenuServlet - erreur lors de la redirection vers " + getServletConfig().getServletContext().getRealPath("/listeCategories.jsp") + "**");
						log.error("Exception : " + e);
						this.erreur("autre",uidUser,req,res,null,null);
						throw e;
					}
				}
			} else if (choix.equals("categories")) {
				MenuException e = new MenuException("utilisateur non autorise");
				throw e;
			}

			if (profStub.getAdmProfilsUsers(uidUser)) {
				req.setAttribute("uiduser", uidUser);
				log.debug("** MenuServlet - l'utilisateur " + uidUser + " a le droit d'administrer les Profils ...");
	
				if (choix.equals("profils")){
					log.debug("** MenuServlet - redirection vers la partie Profils");
					try {
						getServletConfig().getServletContext().getRequestDispatcher("/listeProfils.jsp").forward(req, res);
					} catch (Exception e) {
						log.error("** MenuServlet - erreur lors de la redirection vers " + getServletConfig().getServletContext().getRealPath("/listeProfils.jsp") + "**");
						log.error("Exception : " + e);
						this.erreur("autre",uidUser,req,res,null,null);
						throw e;
					}
				}
				if (choix.equals("users")){
					log.debug("** MenuServlet - redirection vers la partie Utilisateurs");
					try {
						getServletConfig().getServletContext().getRequestDispatcher("/listeAllUtilisateurs.jsp").forward(req, res);
					} catch (Exception e) {
						log.error("** MenuServlet - erreur lors de la redirection vers " + getServletConfig().getServletContext().getRealPath("/listeAllUtilisateurs.jsp") + "**");
						log.error("Exception : " + e);
						this.erreur("autre",uidUser,req,res,null,null);
						throw e;
					}
				}
			} else if (choix.equals("profils") || choix.equals("users")) {
				MenuException e = new MenuException("utilisateur non autorise");
				throw e;
			}
			
//			if (profStub.getAdmNewsProfils(uidProf)) {
//				req.setAttribute("uiduser", uidUser);
//				if (choix.equals("news"))
//					getServletConfig().getServletContext().getRequestDispatcher("/redirect.jsp").forward(req, res);
//			}
			
			if (profStub != null) profStub.close();
	
		} catch (ServiceException e){
			log.error("** MenuServlet - " + e +" **");
			this.erreur("autre",uidUser,req,res,null,null);
		} catch (RemoteException e) {
			log.error("** MenuServlet - "+e+" **");
			this.erreur("autre",uidUser,req,res,null,null);
		} catch (ServletException e) {
			log.error("** MenuServlet - "+e+" **");
			this.erreur("autre",uidUser,req,res,null,null);
		} catch (IOException e) {
			log.error("** MenuServlet - "+e+" **");
			this.erreur("autre",uidUser,req,res,null,null);
		} catch (MenuException e) {
			log.error("** Menu Servlet - " + e.getMessage());
			this.erreur("autre",uidUser,req,res,null,null);
		} catch (Exception e){
			log.error("** Menu Servlet - " + e);
			this.erreur("autre",uidUser,req,res,null,null);
		} finally {
			out.close();
		}
		
	}
	
	public void erreur(String er,String uid,HttpServletRequest req,HttpServletResponse res,AdminCategoriesSoapBindingStub catStub,AdminProfilsSoapBindingStub profStub){
		log.debug("** MenuServlet - methode erreur redirection vers la page erreur.html : "+er);
		if (er.equals("autre")) {
			try {
				getServletConfig().getServletContext().getRequestDispatcher("/erreur.html").forward(req, res);
			} catch (ServletException e) {
				log.error("** Menu Servlet - erreur() " + e);
			} catch (IOException e) {
				log.error("** Menu Servlet - erreur() " + e);
			}
			if (out != null)
				out.close();
		}
	}
}
