package fr.univvalenciennes.publi.application.admin.servlets;

import java.io.*;
import java.rmi.RemoteException;
import java.util.Vector;
import java.net.URL;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.rpc.ServiceException;

import org.apache.log4j.*;

import fr.univvalenciennes.publi.utils.properties.*;

import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;

public class MenuUserServlet extends HttpServlet {
	static Logger log = Logger.getLogger(MenuServlet.class);
	public String uidUser;
	PrintWriter out;
	
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {

		new PropertiesManager("applinews.properties");
		String logConfFile = PropertiesManager.getProperty("logConfFile");
		PropertyConfigurator.configure(logConfFile);

		// obtention d'un flux de sortie
		out = res.getWriter();

		String choix=null;
		
		log.info("** MenuUserServlet - Recuperation de l'action validee par l'utilisateur ...");
		
		choix = RequestParser.getChoixProf(req,res);
		log.info("** MenuUserServlet - choix : " + choix);
		this.actionChoix(req,res,choix);
	}
	
	private void actionChoix(HttpServletRequest req, HttpServletResponse res, String choix){
		ProfilsServicesService profService;
		AdminProfilsSoapBindingStub profStub;
		CategoriesServicesService catService;
		AdminCategoriesSoapBindingStub catStub;
		
		try {
			profService = new ProfilsServicesServiceLocator();
			profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));
			catService = new CategoriesServicesServiceLocator();
			catStub = (AdminCategoriesSoapBindingStub) catService.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
		
			req.getSession().setAttribute("profstub", profStub);
			req.getSession().setAttribute("catstub", catStub);
			
			if (choix.equals("formCreerUser")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION D'UN UTILISATEUR

				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formCreationUser.jsp").forward(req, res);
			}

			if (choix.equals("CreationUser")) {
				// CREATION D'UN UTILISATEUR
						
				// on rcupre les donnes du formulaire
				String uidUserSelect =req.getParameter("uiduser").toUpperCase();
				String nomComplet = req.getParameter("nomcomplet");
				if (nomComplet.length() == 0)	nomComplet = uidUserSelect;
							
				if (profStub.userExiste(uidUserSelect)) {
					// si un utilisateur possde dj cet uid, erreur
					erreur("utilisateur existe",uidUserSelect,req,res,catStub,profStub);
				} else {
					// cration de l'utilisateur dans la base
					profStub.createUsers(uidUserSelect,(String)req.getParameter("uidprofselect"),nomComplet);
							
					getServletConfig().getServletContext().getRequestDispatcher("/listeAllUtilisateurs.jsp").forward(req, res);
				}
			}

			if (choix.equals("formModifierUser")) {
				// AFFICHAGE DU FORMULAIRE DE MODIFICATION D'UN UTILISATEUR
				// on rcupre les paramtres  afficher dans le formulaire
				req.setAttribute("uiduserselect", req.getParameter("uiduserselect"));
				req.setAttribute("nomcomplet",profStub.getNomCompletUser(req.getParameter("uiduserselect")));
				Vector v=profStub.getProfils((String)req.getParameter("uiduserselect"));
				req.setAttribute("userprofils",profStub.getProfils((String)req.getParameter("uiduserselect")));

				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formModifUser.jsp").forward(req, res);
			}

			if (choix.equals("ModifUser")) {
				// MODIFICATION D'UN UTILISATEUR
						
				// modification dans la base
				profStub.modifUsers(req.getParameter("uiduserselect"),req.getParameter("uidprofselect"),req.getParameter("nomcomplet"));

				// retour  la liste des utilisateurs
				getServletConfig().getServletContext().getRequestDispatcher("/listeAllUtilisateurs.jsp").forward(req, res);
			}

			if (choix.equals("SupprimerUser")) {
				// SUPPRESSION D'UN UTILISATEUR
						
				// on rcupre l'uiduser
				String uidUserSelect =req.getParameter("uiduserselect");
							
				// suppression dans la base
				profStub.deleteUsers(uidUserSelect);
						
				// retour  la liste des utilisateurs
				getServletConfig().getServletContext().getRequestDispatcher("/listeAllUtilisateurs.jsp").forward(req, res);
			}

			if (choix.equals("SupprimerProfUser")) {
				// SUPPRESSION D'UN PROFIL DE L'UTILISATEUR
						
				// on rcupre l'uiduser et le profil selectionn
				String uidUserSelect =req.getParameter("uiduserselect");
				String uidProfSelect =req.getParameter("uidprofsupprselect");
							
				// suppression dans la base
				profStub.removeProfilToUser(uidUserSelect,uidProfSelect);

				req.setAttribute("uiduserselect", req.getParameter("uiduserselect"));
				req.setAttribute("nomcomplet",profStub.getNomCompletUser(req.getParameter("uiduserselect")));
				Vector v=profStub.getProfils((String)req.getParameter("uiduserselect"));
				req.setAttribute("userprofils",profStub.getProfils((String)req.getParameter("uiduserselect")));
						
				// retour  la fiche de l'utilisateur
				getServletConfig().getServletContext().getRequestDispatcher("/formModifUser.jsp").forward(req, res);
			}

			if (choix.equals("AjouterProfUser")) {
				// AJOUT D'UN PROFIL A L'UTILISATEUR
						
				// on rcupre l'uiduser et le profil selectionn
				String uidUserSelect =req.getParameter("uiduserselect");
				String uidProfSelect =req.getParameter("uidprofselect");
							
				// suppression dans la base
				profStub.addProfilToUser(uidUserSelect,uidProfSelect);
						
				req.setAttribute("uiduserselect", req.getParameter("uiduserselect"));
				req.setAttribute("nomcomplet",profStub.getNomCompletUser(req.getParameter("uiduserselect")));
				Vector v=profStub.getProfils((String)req.getParameter("uiduserselect"));
				req.setAttribute("userprofils",profStub.getProfils((String)req.getParameter("uiduserselect")));
				// retour  la fiche de l'utilisateur
				getServletConfig().getServletContext().getRequestDispatcher("/formModifUser.jsp").forward(req, res);
			}
		}catch (ServiceException e){
			// TODO
		} catch (RemoteException e) {
			// TODO
		} catch (ServletException e) {
			// TODO
		} catch (IOException e) {
			// TODO
		} finally {
			out.close();
		}
	}
	
	public void erreur(String er,String uid,HttpServletRequest req,HttpServletResponse res,AdminCategoriesSoapBindingStub catStub,AdminProfilsSoapBindingStub profStub)
		throws ServletException, IOException {
			if (er.equals("utilisateur existe")) {
				req.setAttribute(
					"message",
					"Il existe dj un profil possdant l'identifiant \""
						+ uid
						+ "\". <br>Veuillez choisir un autre identifiant.");
				req.setAttribute("retour", "listeAllUtilisateurs.jsp");
				getServletConfig()
					.getServletContext()
					.getRequestDispatcher("/erreur.jsp")
					.forward(req, res);
				if (out != null)
					out.close();
			}
			if (er.equals("autre")) {
				req.setAttribute(
					"message",
					"Une erreur s'est produite. Veuillez ressayer plus tard.");
				req.setAttribute("retour", "listeAllUtilisateurs.jsp");
				getServletConfig()
					.getServletContext()
					.getRequestDispatcher("/erreur.html")
					.forward(req, res);
				if (out != null)
					out.close();
			}
	}

}