/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionNews.News.*;

/**
 * Description :<br/>
 * Encapsule les donnes concernant une entre dans CANAUXRSS
 * qui stocke les canaux rss de la base:<br/>
 * CANAUXRSS(codecanal,caption,url,canalinterne,institut,publishout,nomstyle,typecanal,partager,owner)
 * @version $Id : CanauxRss.java, V1.0, 09 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : CanauxRss<br/>
 */
public class CanauxRss implements java.io.Serializable {
	static Logger log = Logger.getLogger(CategoriesServices.class);

	// Champs de la table CANAUXRSS
	private String uidCanal;
	private String caption;
	private String owner;

	private boolean existe = false; // vrai si le canal est dans la base

	public CanauxRss() {
	}

	/**
	 * Demande le chargement du canal  partir de la base
	 * @param uidCan	uid du canal
	 * @param sqlCan	Objet SqlCanauxRss regroupant les accs  la table CANAUXRSS
	 * @throws Exception
	 */
	public CanauxRss(String uidCan) throws Exception {
		try {
			setUidCanal(uidCan);
			existe = SqlCanauxRss.loadCanalRss(this);
		} catch (Exception e) {
			log.error("CanauxRss - Problme de chargement du canal :" + e.getMessage());
			throw (Exception)e;
		}
	}

	public CanauxRss(
		String uidCan,
		String caption,
		String owner)
		throws Exception {

		this(uidCan);

		setCaption(caption);
		setOwner(owner);
	}

	public void create() throws Exception{
		SqlCanauxRss.createCanauxRss(this);
	}
	
	public void modif() throws Exception {
		SqlCanauxRss.modifCanauxRss(this);
	}
	
	public void delete() throws Exception {
		// supprimer les news attaches  la catgorie
		NewsService newsService = new NewsService();
		newsService.deleteNewsByCanal(uidCanal);
		SqlCanauxRss.deleteCanauxRss(this);
	}

	public String getCaption() {
		return caption;
	}

	public String getOwner() {
		return owner;
	}


	public String getUidCanal() {
		return uidCanal;
	}

	public void setCaption(String string) {
		caption = string;
	}

	public void setOwner(String string) {
		owner = string;
	}

	public void setUidCanal(String string) {
		uidCanal = string;
	}

	public boolean isExiste() {
		return existe;
	}

	public void setExiste(boolean b) {
		existe = b;
	}
}