/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils.*;
import fr.univvalenciennes.publi.utils.properties.*;

import java.util.*;

/**
 * Description :<br/>
 * Classe fournissant toutes les mthodes permettant de grer les catgories
 * @version $Id : CategoriesServices.java, V1.0, 09 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : CategoriesServices<br/>
 */
public class CategoriesServices {
	static Logger log;
	
	/**
	 * Constructeur  
	 * Init the database connection
	 */
	public CategoriesServices() throws Exception{
		log = Logger.getLogger(this.getClass().getPackage().getName());
		new PropertiesManager("applinews.properties");
		String logConfFile = PropertiesManager.getProperty("logConfFile");

		PropertyConfigurator.configure(logConfFile);
		log.debug("** CategoriesServices - Entree **");
	}
	
	public boolean test(){
		return true;
	}
	
	/**
	 * Add a new Categories into the database
	 * @param uidCat	uid de la catgorie
	 * @param caption	valeur  affecter au champ caption
	 * @param summary	valeur  affecter au champ summary
	 * @param gifUrl	valeur  affecter au champ gifurl
	 */
	public void createCategories(String uidCat,
		String caption,
		String summary,
		String gifUrl) throws Exception{
			try{
				log.info("** CategoriesServices - Creation d'une categorie");
				Categories categorie = new Categories(uidCat,caption,summary,gifUrl);
				categorie.create();
			} catch (Exception e) {
				log.error("CategoriesServices - createCategories erreur : " + e);
				throw e;
			}
	}

	/**
	 * Modifie une catgorie
	 * @param uidCat	uid de la catgorie
	 * @param caption	valeur  affecter au champ caption
	 * @param summary	valeur  affecter au champ summary
	 * @param gifUrl	valeur  affecter au champ gifurl
	 */
	public void modifCategories(String uidCat,
	String caption,
	String summary,
	String gifUrl) throws Exception{
		try{
			Categories categorie = new Categories(uidCat,caption,summary,gifUrl);
			categorie.modif();
		} catch (Exception e) {
			log.error("CategoriesServices - modifCategories erreur : " + e);
			throw e;
		} 
	}
	
	/**
	 * Vrifie si la catgorie est dans la base
	 * @param uidCat	uid de la catgorie
	 * @return	true si la catgorie est dans la base
	 * @throws Exception
	 */
	public boolean catExiste(String uidCat) throws Exception{
		try {
			Categories cat=new Categories(uidCat);
			return cat.isExiste();
		} catch (Exception e) {
			log.error("CategoriesServices - catExiste erreur : " + e);
			throw e;
		} 
	}
	
	/**
	 * Renvoie le champ caption de la catgorie
	 * @param uidCat	uid de la catgorie
	 * @return	champ caption de la catgorie
	 * @throws Exception
	 */
	public String getCaptionCategories(String uidCat) throws Exception {
		try {
			Categories cat=new Categories(uidCat);
			return cat.getCaption();
		} catch (Exception e) {
			log.error("CategoriesServices - getCaptionCategories erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Renvoie le champ summary de la catgorie
	 * @param uidCat	uid de la catgorie
	 * @return	champ summary de la catgorie
	 * @throws Exception
	 */
	public String getSummaryCategories(String uidCat) throws Exception {
		try {
			Categories cat=new Categories(uidCat);
			return cat.getSummary();
		} catch (Exception e) {
			log.error("CategoriesServices - getSummaryCategories erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Renvoie le champ gifurl de la catgorie
	 * @param uidCat	uid de la catgorie
	 * @return	champ gifurl de la catgorie
	 * @throws Exception
	 */
	public String getGifUrlCategories(String uidCat) throws Exception {
		try {
			Categories cat=new Categories(uidCat);
			return cat.getGifUrl();
		} catch (Exception e) {
			log.error("CategoriesServices - getGifUrlCategories erreur : " + e);
			throw e;
		}
	}

	/**
	 * Ajoute un nouveau lien entre 2 catgories
	 * @param uidCat		uid de la categorie mre
	 * @param uidDescCat	uid de la catgorie fille
	 * @return true si le lien a pu tre cr
	 */
	public boolean createOrgaCategories(String uidCat, String uidDescCat) throws Exception{
		try{
			OrgaCategories lien = new OrgaCategories(uidCat,uidDescCat);
			
			// On vrifie si le lien cre une boucle dans l'arbre des catgories
			boolean boucle;
			boucle = lien.checkLoops();
			
			if(!boucle)
				lien.create();
				
			return !boucle;
		} catch (Exception e) {
			log.error("CategoriesServices - createOrgaCategories erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Supprime un lien entre 2 catgories
	 * @param uidCat		uid de la categorie mre
	 * @param uidDescCat	uid de la catgorie fille
	 * @throws Exception
	 */
	public void deleteOrgaCategories(String uidCat, String uidDescCat) throws Exception {
		try{
			OrgaCategories lien = new OrgaCategories(uidCat,uidDescCat);
			lien.delete();
		} catch(Exception e){
			log.error("CategoriesServices - deleteOrgaCategories erreur : " + e);
			throw e;
		}
	}

	/**
	 * Publie une catgorie en tant que canalRss
	 * @param uidCat	uid de la catgorie  publier
	 * @param owner		valeur  affecter au champ owner
	 * @throws Exception
	 */
	public void publishAsRss(String uidCat, String owner) throws Exception {
		try {
			Categories cat = new Categories(uidCat);
			cat.publishAsRss(owner);
		} catch (Exception e) {
			log.error("CategoriesServices - publishAsRss  erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Dpublie un canalRss (la catgorie est conserve mais n'est plus un canal RSS)
	 * @param 	uidcat uid de la catgorie  dpublier
	 * @throws Exception
	 */
	public void unpublishAsRss(String uidCat) throws Exception {
		try {
			Categories cat = new Categories(uidCat);
			cat.unpublishAsRss();
		} catch (Exception e) {
			log.error("CategoriesServices - unpublishAsRss  erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Vrifie si une catgorie est publie en tant que canal RSS
	 * @param uidCat
	 * @return true si la catgorie est un canal RSS
	 * @throws Exception
	 */
	public boolean isRss(String uidCat) throws Exception{
		try {
			Categories cat = new Categories(uidCat);
			return cat.isPublishedAsRss();
		} catch (Exception e) {
			log.error("CategoriesServices - isRss  erreur : " + e);
			throw e;
		}
	}

	/**
	 * Renvoie sous forme de Vector de String l'ensemble des url des gifs
	 * contenus dans le champ gifurl de CATEGORIES
	 * @return Vector contenant les url des gifs contenus dans le champ gifurl de CATEGORIES
	 * @throws Exception
	 */
	public Vector getAllAvailableGifs() throws Exception {
		try {
			return Categories.getAllAvailableGifs();
		} catch (Exception e){
			log.error("CategoriesServices - getAllAvailableGifs  erreur : " + e);
			throw e;
		} 
	}
	
	/**
	 * Renvoie la liste de toutes les catgories accessibles  un utilisateur
	 * d'aprs son profil
	 * @param uidUser	uid de l'utilisateur
	 * @return 	Vector des uidcat des catgories accessibles pour l'utilisateur 
	 * @throws Exception
	 */
	public Vector getAllCategories(String uidUser) throws Exception {
		try {
			log.debug("** CategoriesServices - Liste des categories");
			log.debug("** CategoriesServices - utilisateur :"+uidUser);
			return Categories.getAllCategories(new Users(uidUser));			
		} catch (Exception e) {
			log.error("CategoriesServices - getAllCategories  erreur : " + e);
			throw e;
		}
	}
	
	/**
	 * Renvoie la liste des catgories filles de la catgorie passe en paramtre
	 * @param uidCat	uid de la catgorie
	 * @return	Vector des uidcat des catgories filles 
	 * @throws Exception
	 */
	public Vector getCategoriesFilles(String uidCat) throws Exception {
		try {
			Categories cat = new Categories(uidCat);
			return cat.getCategoriesFilles();
		} catch (Exception e) {
			log.error("CategoriesServices - getCategoriesFilles  erreur : " + e);
			throw e;
		} 
	}
	
	public void close() throws Throwable{
	}
}
