/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Description :<br/>
 * Encapsule les donnes concernant une entre dans ORGACATEGORIES
 * qui stocke les liens de descendance entre les catgories :<br/>
 * ORGACATEGORIES(uidcat,uiddesccat,ordre)
 * @version $Id : OrgaCategories.java, V1.0, 09 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : OrgaCategories<br/>
 */
public class OrgaCategories  implements java.io.Serializable {
	static Logger log = Logger.getLogger("administration");

	private Categories categorieMere;
	private Categories categorieFille;
	private long ordre=0;
	
	private boolean existe=false;		// vrai si le lien est dans la bd
	
	public OrgaCategories(){		
	}
	
	/**
	 * Demande le chargement du lien  partir de la base
	 * @param catMere	Catgorie mre du lien  tlcharger
	 * @param catFille	Catgorie fille du lien  tlcharger
	 * @param sqlOrgaCategories Objet SqlOrgaCategories regroupant les accs  la table ORGACATEGORIES
	 * @throws Exception
	 */
	public OrgaCategories (Categories catMere, Categories catFille)throws Exception{
		
		try{
			setCategorieMere(catMere);
			setCategorieFille(catFille);
			existe = SqlOrgaCategories.loadOrgaCategories(this);
			log.debug("OrgaCategories - existe : "+existe);
			if(!existe){
				// on est dans le cadre d'une cration de lien
				if((catMere.isExiste())&&(catFille.isExiste())&&(!checkLoops())) {				
					log.debug("OrgaCategories - attribution de l'ordre");
					setOrdre(catMere.getNbFilles()+1);
					log.debug("OrgaCategories - ordre : "+ordre);
				}
			}
		}catch (Exception e){
			log.error("OrgaCategories - constructeur : " + e.getMessage());
		}
	}
	
	/**
	 * Constructeur
	 * Demande le chargement du lien  partir de la base
	 * @param uidCatMere	uid de la catgorie mre
	 * @param uidCatFille	uid de la catgorie fille
	 * @param sqlOrgaCategories Objet SqlOrgaCategories regroupant les accs  la table ORGACATEGORIES
	 * @throws Exception
	 */
	public OrgaCategories (String uidCatMere, String uidCatFille)throws Exception{
		Categories catMere = new Categories(uidCatMere);
		Categories catFille = new Categories(uidCatFille);
		try{
			setCategorieMere(catMere);
			setCategorieFille(catFille);
			existe = SqlOrgaCategories.loadOrgaCategories(this);
			log.debug("OrgaCategories - existe : "+existe);
			if(!existe){
				// on est dans le cadre d'une cration de lien
				if((catMere.isExiste())&&(catFille.isExiste())&&(!checkLoops())) {				
					log.debug("OrgaCategories - attribution de l'ordre");
					setOrdre(catMere.getNbFilles()+1);
					log.debug("OrgaCategories - ordre : "+ordre);
				}
			}
		}catch (Exception e){
			log.error("OrgaCategories - constructeur : " + e.getMessage());
		}
	}
	
	/**
	 * Demande le chargement du lien  partir de la base
	 * @param catMere
	 * @param ordre
	 * @param sqlOrgaCategories
	 * @throws Exception
	 */
	public OrgaCategories (Categories catMere, long ordre) throws Exception{
		log = Logger.getLogger(this.getClass().getPackage().getName());
		try{
			setCategorieMere(catMere);
			setOrdre(ordre);
			existe = SqlOrgaCategories.loadOrgaCategories(this);
		}catch (Exception e){
			log.error("OrgaCategories - constructeur :" + e);
			throw e;
		}
	}
	
	public void create() throws Exception {
		SqlOrgaCategories.createOrgaCategories(this);
	}
	
	public void modif() throws Exception {
		SqlOrgaCategories.modifOrgaCategories(this);
	}

	/**
	 * Supprime le lien de la base en diminuant d'1 l'ordre
	 * de tous les liens de mme mre et d'ordre suprieur du lien supprim 
	 * @throws Exception
	 */
	public void delete() throws Exception {
		try {
			// supprimer le lien
			SqlOrgaCategories.deleteOrgaCategories(this);
			
			// remonter d'un cran toutes les filles de la mre dont l'ordre est suprieur
			// au lien courant
			Vector vFilles = SqlOrgaCategories.getFillesUidcats(getCategorieMere(),getOrdre());
			for(Enumeration e = vFilles.elements();e.hasMoreElements();) {
				OrgaCategories lien = new OrgaCategories(getCategorieMere().getUidCat(),(String)e.nextElement());
				lien.moveChildUp();
			}
				
			// on vrifie que la catgorie fille est encore attache  un canal
			// si non, on supprime la catgorie
			if ( categorieFille.getAscendanceUidcats().isEmpty() )
				categorieFille.delete();
		}  catch (Exception e) {
			log.error("OrgaCategories - delete :" + e);
			throw e;
		}

	}
	
	/**
	 * Mthode qui vrifie que le lien courant ne provoque pas de boucle dans l'arbre des rubriques
	 * @return true si la cration du lien provoque une boucle
	 * @throws Exception
	 */
	public boolean checkLoops() throws Exception {
		try {
			if(categorieMere.getUidCat().equalsIgnoreCase(categorieFille.getUidCat()))
				return true;
			else {
				Vector	v = new Vector();
				v = categorieFille.getDescendanceUidcats();
				if(v.contains(categorieMere.getUidCat()))
					return true;
				else {
					v.clear();
					v = categorieMere.getAscendanceUidcats();
					return v.contains(categorieFille.getUidCat());
				}
			}
		} catch (Exception e) {
			log.error("OrgaCategories - checkLoops :" + e);
			throw e;
		}
	}
	
	/**
	 * Mthode qui permute l'ordre de ce lien avec celui du lien juste au dessus
	 * @throws Exception
	 */
	public void moveChildUp() throws Exception {
		try {
			if (getOrdre()<=1)	return;
			OrgaCategories orgaCat = new OrgaCategories(categorieMere,ordre-1);
			if (orgaCat != null) {
				orgaCat.setOrdre(ordre);
				SqlOrgaCategories.modifOrgaCategories(orgaCat);
			}		
			setOrdre(ordre-1);
			SqlOrgaCategories.modifOrgaCategories(this);
		} catch (Exception e) {
			log.error("OrgaCategories - moveChildUp :" + e);
			throw e;
		}
	}
	
	/**
	 * Mthode qui permute l'ordre de ce lien avec celui du lien juste en dessous
	 * @throws Exception
	 */
	public void moveChildDown() throws Exception {
		try {
			if (getOrdre()<1)	return;
			
			OrgaCategories orgaCat = new OrgaCategories(categorieMere,ordre+1);
				
			if (orgaCat != null) {
				orgaCat.setOrdre(ordre);
				SqlOrgaCategories.modifOrgaCategories(orgaCat);
				setOrdre(ordre+1);
				SqlOrgaCategories.modifOrgaCategories(this);
			}
		}  catch (Exception e) {
			log.error("OrgaCategories - moveChildDown :" + e);
			throw e;
		}
	}
	
	public Categories getCategorieFille() {
		return categorieFille;
	}

	
	public Categories getCategorieMere() {
		return categorieMere;
	}

		
	public long getOrdre() {
		return ordre;
	}

	public void setCategorieFille(Categories categories) {
		categorieFille = categories;
	}

	public void setCategorieMere(Categories categories) {
		categorieMere = categories;
	}

	public void setOrdre(long i) {
		ordre = i;
	}

	public boolean isExiste() {
		return existe;
	}

	public void setExiste(boolean b) {
		existe = b;
	}
}