/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories;

import java.sql.*;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.PropertiesManager;


/**
 * Description :<br/>
 * Classe regroupant les accs  la base de donnes
 * concernant la table CANAUXRSS qui stocke les canaux rss de la base:<br/>
 * CANAUXRSS(codecanal,caption,url,canalinterne,institut,publishout,nomstyle,typecanal,partager,owner)<br/>
 * Les champs "canalinterne","institut","publishout","nomstyle","typecanal" ne sont plus 
 * utiliss et sont remplis par dfaut respectivement par "O", "", "O", "", "RSS0.91" 
 * @version $Id : SqlCanauxRss.java, V1.0, 08 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SqlCanauxRss<br/>
 */
public class SqlCanauxRss implements java.io.Serializable {
	static String pool = "applinews";
	private static boolean debug = true;
	static Logger log ;

	public SqlCanauxRss() throws Exception{
		log = Logger.getLogger(this.getClass().getPackage().getName());
	}

	private static Connection getConnection() throws Exception {
		return CachedConnectionsManager.checkOut(pool);
	}

	/**
	 * Ajoute le canal rss pass en paramtre dans la base
	 * @param canalRss	canal  ajouter  la base
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void createCanauxRss(CanauxRss canalRss)
		throws Exception {
		Connection conn=null;
		PreparedStatement statement=null;
		try {
			conn = getConnection();

			new PropertiesManager("requetesAdmin.properties");

			String sqlString = PropertiesManager.getProperty("canauxeditables.creation");

			statement = conn.prepareStatement(sqlString);

			statement.setString(1, canalRss.getUidCanal());
			statement.setString(2, canalRss.getCaption());
			statement.setString(3, canalRss.getOwner());
			statement.executeUpdate();
			statement.close();
			canalRss.setExiste(true);
		} catch (Exception e) {
			log.error("** SqlCanauxRss - createCanauxRss : " + e);
			throw e;
		} finally {
			if (statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);			
		}
	}

	/**
	 * Modifie la catgorie passe en paramtre dans la base
	 * @param canalRss	canal  modifier
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void modifCanauxRss(CanauxRss canalRss)
		throws Exception {
		Connection conn=null;
		PreparedStatement statement=null;
		try {
			conn = getConnection();

			new PropertiesManager("requetesAdmin.properties");

			String sqlString = PropertiesManager.getProperty("canauxeditables.modification");

			statement = conn.prepareStatement(sqlString);

			statement.setString(1, canalRss.getCaption());
			statement.setString(2, canalRss.getOwner());
			statement.setString(3, canalRss.getUidCanal());
			statement.executeUpdate();
			statement.close();
		} catch (Exception e) {
			log.error(
				"** SqlCanauxRss - modifCanauxRss : " + e);
			throw e;
		} finally {
			if (statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);			
		}

	}

	/**
	 * Supprime le canal de la table CANAUXRSS
	 * @param can	canal  supprimer
	 * @throws SQLException
	 */
	public static void deleteCanauxRss(CanauxRss can) throws Exception {
		PreparedStatement stmt = null;
		String sqlString;
		Connection conn=null;

		try {
			new PropertiesManager("requetesAdmin.properties");

			sqlString = PropertiesManager.getProperty("canauxeditables.suppression");
			conn = getConnection();
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,can.getUidCanal());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlCanauxRss - deleteCanauxRss : " + e);
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);			
		}
	}

	/**
	 * Charge le canal s'il est dans la base
	 * @param canalRss	canal  charger
	 * @return true si le canal est dans la base
	 * @throws SQLException
	 */
	public static boolean loadCanalRss(CanauxRss canalRss) throws Exception {
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Connection conn=null;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");

			sqlString = PropertiesManager.getProperty("canauxeditables.chargement");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,canalRss.getUidCanal());
			rst = stmt.executeQuery();
			if (rst.next()) {
				canalRss.setCaption(rst.getString("caption"));
				canalRss.setOwner(rst.getString("owner"));
				stmt.close();
				return true;				
			} else {
				stmt.close();
				return false;
			}
		} catch (Exception e) {
			log.error("SqlCanauxRss - loadCanalRss : " + e);
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);			
		}
	}

	/**
	 * Vrife si la catgorie passe en paramtre est un canal Rss
	 * (i.e. si elle appartient  la table CANAUXRSS)
	 * @param cat
	 * @return true si l'uidcat de la catgorie figure dans la table CANALRSS
	 * @throws Exception
	 */
	public static boolean isPublishedAsRss(Categories cat) throws Exception {
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Connection conn=null;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxeditables.estPublie");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,cat.getUidCat());
			rst = stmt.executeQuery();
			if (rst.next()) {
				stmt.close();
				return true;
			} else {
				stmt.close();
				return false;
			}
		} catch (Exception e) {
			log.error(
				"SqlCanauxRss - isPublishedAsRss : " + e);
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);			
		}
	}

}