/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories;

import java.sql.*;

import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils.Users;
import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.*;

/**
 * Description :<br/>
 * Classe regroupant les accs  la base de donnes
 * concernant la table CATEGORIES qui stocke les catgories de la base:<br/>
 * CATEGORIES(uidcat,caption,niveau,summary,gifUrl,needsValidation,mailValidation)
 * @version $Id : SqlCategories.java, V1.0, 09 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SqlCategories<br/>
 */
public class SqlCategories {
	static String pool = "applinews";
	private static boolean debug;
	static Logger log = Logger.getLogger("administration");

	public SqlCategories() throws Exception {
//		log = Logger.getLogger(this.getClass().getPackage().getName());
	}

	private static Connection getConnection() throws Exception {
		return CachedConnectionsManager.checkOut(pool);
	}
	/**
	 * Ajoute la catgorie passe en paramtre dans la base
	 * @param categorie		catgorie  ajouter  la base
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void createCategories(Categories categorie)
		throws Exception {
		PreparedStatement statement=null;
		Connection conn = null;
		try {
			new PropertiesManager("requetesAdmin.properties");

			String sqlString = PropertiesManager.getProperty("canaux.creation");

			conn = getConnection();
			statement = conn.prepareStatement(sqlString);
			statement.setString(1, categorie.getUidCat());
			statement.setString(2, categorie.getCaption());
			statement.setString(3, categorie.getSummary());
			statement.setString(4, categorie.getGifUrl());
			statement.executeUpdate();
			
			statement.close();
			
			categorie.setExiste(true);
		} catch (Exception e) {
			log.error("SqlCategories - createCategories : " + e);
			throw e; 
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Modifie la catgorie passe en paramtre dans la base
	 * @param categorie		Catgorie  modifier
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void modifCategories(Categories categorie)
		throws Exception {
		PreparedStatement statement=null;
		Connection conn = null;
		try {
			conn = getConnection();

			new PropertiesManager("requetesAdmin.properties");

			String sqlString = PropertiesManager.getProperty("canaux.modification");

			statement = conn.prepareStatement(sqlString);
			statement.setString(1, categorie.getCaption());
			statement.setString(2, categorie.getSummary());
			statement.setString(3, categorie.getGifUrl());
			statement.setString(4, categorie.getUidCat());

			statement.executeUpdate();
			statement.close();
		} catch (Exception e) {
			log.error(
				"SqlCategories - modifCategories : " + e);
			throw e;
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Supprime la catgorie de la base
	 * @param cat	Catgorie  supprimer
	 * @throws Exception
	 */
	public static void deleteCategories(Categories cat) throws Exception {
		PreparedStatement stmt = null;
		String sqlString;
		Connection conn = null;
		
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canaux.suppression");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,cat.getUidCat());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlCategories - deleteCategories : " + e);
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Charge la categorie si elle est dans la base
	 * @param categorie		Catgorie  charger
	 * @return true si la catgorie est dans la DB
	 * @throws SQLException
	 */
	public static boolean loadCategorie(Categories categorie) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canaux.chargement");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,categorie.getUidCat());
			rst = stmt.executeQuery();
			
			if (rst.next()) {
				if (rst.getString("caption") != null)
					categorie.setCaption(rst.getString("caption"));
				else
					categorie.setCaption("");
				
				if (rst.getString("summary") != null)
					categorie.setSummary(rst.getString("summary"));
				else
					categorie.setSummary("");
								
				if (rst.getString("gifurl") != null)
					categorie.setGifUrl(rst.getString("gifurl"));
				else
					categorie.setGifUrl("");
				
				stmt.close();
				return true;
			} else {
				categorie.setCaption("");
				categorie.setSummary("");
				categorie.setGifUrl("");
				stmt.close();
				return false;
			}
		} catch (Exception e) {
			log.error("SqlCategories - loadCategorie : " + e);
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Renvoie l'ensemble des url des gifs contenus dans 
	 * le champ gifurl de CATEGORIES
	 * @return Vector des url des gifs contenus dans le champ gifurl de CATEGORIES
	 * @throws Exception
	 */
	public static Vector getAllAvailableGifs() throws Exception {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rst = null;
		String sqlString, url;
		Vector v = new Vector();

		try {
			conn = getConnection();
			stmt = conn.createStatement();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canaux.listeGifsDispos");
			rst = stmt.executeQuery(sqlString);

			while (rst.next()) {
				url = rst.getString("gifurl");
				if ((url != null) && (url.trim().length() > 0))
					v.addElement(url);
			}
			stmt.close();
			return v;
		} catch (Exception e) {
			log.error(
				"SqlCategories - getAllAvailableGifs : " + e);
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Renvoie l'ensemble des uid des catgories attaches au profil 
	 * d'un utilisateur dans la table CATSPROFILS
	 * @param uidUser uid de l'utilisateur
	 * @return Vector des uid des catgories attaches
	 * @throws Exception
	 */
	public static Vector getAllCategories(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vCats = new Vector(0);
		
		log.debug("SqlCategories : entree dans getAllCategories");
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canaux.listeCanauxParUser");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,user.getUidUser());
			rst = stmt.executeQuery();
			log.debug("SqlCategories : utilisateur + requete :"+user.getUidUser()+" : "+sqlString);

			while (rst.next()) {
				vCats.addElement(rst.getString("uiddesccat"));
			}
			stmt.close();
			return vCats;
		} catch (Exception e) {
			log.error("SqlCategories - getAllCategories : "	+ e);
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

}
