package fr.univvalenciennes.publi.WebServices.adminPubli.GestionNews.News;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.*;

public class SqlNews {
	private static Log log = LogFactory.getLog("axis.news");
	private static String pool = "applinews";

	/**
	 *
	 *
	 *Prepare the database for a query
	 *                                        
	 */

	public SqlNews() throws Exception {
		
	}

	private static Connection getConnection() throws Exception {
		return CachedConnectionsManager.checkOut(pool);
	}

	public void deleteNews(String uidnews) throws Exception {

		Connection connection = getConnection();
		new PropertiesManager("requetesAdmin.properties");
		String sqlString =
			PropertiesManager.getProperty("news.suppressionLien");
		PreparedStatement statement = connection.prepareStatement(sqlString);
		statement.setString(1, uidnews);
		statement.executeUpdate();

		sqlString = PropertiesManager.getProperty("news.suppressionMessage");
		statement.clearParameters();
		statement = connection.prepareStatement(sqlString);
		statement.setString(1, uidnews);
		statement.executeUpdate();

		statement.close();

		CachedConnectionsManager.checkIn(connection);

	}
	public void deleteNewsByCanal(String uidCanal)
		throws SQLException, ClassNotFoundException {

		Connection connection = null;
		PreparedStatement stmt = null;

		try {
			connection = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString =
				PropertiesManager.getProperty("news.newsParCanal");
			stmt = connection.prepareStatement(sqlString);
			stmt.setString(1, uidCanal);
			ResultSet rst = stmt.executeQuery();

			while (rst.next()) {
				deleteNews((String) rst.getString(1));
			}

			stmt.close();
		} catch (Exception e) {
			log.error("** SqlNews : " + e);
		} finally {
			if (stmt != null)
				stmt.close();
			CachedConnectionsManager.checkIn(connection);
		}
	}

	public void unpublishNewsByCanaux(String uidCanal)
		throws SQLException, ClassNotFoundException {
		Connection connection = null;
		PreparedStatement stmt = null;

		try {
			connection = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("news.depublier");
			stmt = connection.prepareStatement(sqlString);
			stmt.setString(1, uidCanal);
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("** SqlNews : " + e);
		} finally {
			if (stmt != null)
				stmt.close();
			CachedConnectionsManager.checkIn(connection);
		}
	}

	public News getNews(String uidnews) throws Exception {

		String answer1, answer6, answer7, answer8, answer10; // answer9 ,
		Date answer2b, answer3b, answer4b, datedebb;
		int answer5;
		int year, month, day;
		String[] champ_date;

		Connection connection = getConnection();
		new PropertiesManager("requetesAdmin.properties");
		String sqlString = PropertiesManager.getProperty("news.chargement");

		PreparedStatement statement = connection.prepareStatement(sqlString);
		statement.setString(1, uidnews);

		ResultSet rs = statement.executeQuery(sqlString);
		rs.next();

		answer1 = rs.getString("caption");
		answer2b = rs.getDate("datecreated");
		champ_date = answer2b.toString().split("-");
		year = Integer.parseInt(champ_date[0]);
		month = Integer.parseInt(champ_date[1]) - 1;
		day = Integer.parseInt(champ_date[2]);
		java.util.Calendar answer2 = new java.util.GregorianCalendar();
		answer2.set(year, month, day);

		answer3b = rs.getDate("datelastmodified");
		champ_date = answer3b.toString().split("-");
		year = Integer.parseInt(champ_date[0]);
		month = Integer.parseInt(champ_date[1]) - 1;
		day = Integer.parseInt(champ_date[2]);
		java.util.Calendar answer3 = new java.util.GregorianCalendar();
		answer3.set(year, month, day);

		java.util.Calendar answer4 = new java.util.GregorianCalendar();
		answer4b = rs.getDate("dateendvalidity");
		if (answer4b != null) {
			champ_date = answer4b.toString().split("-");
			year = Integer.parseInt(champ_date[0]);
			month = Integer.parseInt(champ_date[1]) - 1;
			day = Integer.parseInt(champ_date[2]);
			answer4.set(year, month, day);
		}
		log.debug("SQLNEWS : date de fin : Mois recupere : " + (month + 1));

		java.util.Calendar datedeb = new java.util.GregorianCalendar();
		datedebb = rs.getDate("datedebvalidity");
		if (datedebb != null) {
			champ_date = datedebb.toString().split("-");
			year = Integer.parseInt(champ_date[0]);
			month = Integer.parseInt(champ_date[1]) - 1;
			day = Integer.parseInt(champ_date[2]);
			datedeb.set(year, month, day);
		}
		log.debug("SqlNews : datedebvalidity = " + datedeb);

		answer5 = rs.getInt("defaultpriority");
		answer6 = rs.getString("htmlname");
		answer7 = rs.getString("summary");
		answer8 = rs.getString("url");
		answer10 = rs.getString("owner");

		statement.close();
		CachedConnectionsManager.checkIn(connection);

		return new News(
			uidnews,
			answer1,
			answer2,
			answer3,
			answer4,
			datedeb,
			answer5,
			answer6,
			answer7,
			answer8,
			answer10);

	}

	public void putNews(News n, String uidcat) throws Exception {

		String sqlString, maxUidNews;

		try {
			// Ici on determine l'uid de la news
			Calendar cal = GregorianCalendar.getInstance();
			cal.setTime(new Date());
			// Obtenir un UIdNews.
			String Days = "" + cal.get(Calendar.DAY_OF_MONTH);
			if (Days.length() < 2)	Days = "0" + Days;
			String Month = "" + (cal.get(Calendar.MONTH));
			if (Month.length() < 2)	Month = "0" + Month;
			String Year = "" + cal.get(Calendar.YEAR);
			if (Year.length() > 2)	Year = Year.substring(2);
			String Hours = "" + cal.get(Calendar.HOUR);
			if (Hours.length() < 2)	Hours = "0" + Hours;
			String Minutes = "" + cal.get(Calendar.MINUTE);
			if (Minutes.length() < 2)	Minutes = "0" + Minutes;
			String Seconds = "" + cal.get(Calendar.SECOND);
			if (Seconds.length() < 2)	Seconds = "0" + Seconds;
			String Key = new String("");
			long KeyCalculation = 0;
			for (int i = 0; i < n.getOwner().length(); i++)
				KeyCalculation += n.getOwner().charAt(i);
			Key += KeyCalculation;
			if (Key.length() == 2)
				Key = "0" + Key;
			Key = Key.substring(Key.length() - 3);
			String mUIdNews = Year + Month + Days + Hours + Minutes + Seconds + Key;

			GregorianCalendar greg = new GregorianCalendar();
			greg.setTime(new java.util.Date());
			n.setDateCreated(greg);
			n.setDateLastModified(greg);

			if (n.getDateBeginValidity() == null) {
				n.setDateBeginValidity(greg);
			}

			String replace = "''";
			String caption = n.getCaption().replaceAll("'", replace);
			String Summary = n.getSummary().replaceAll("'", replace);

			if (n.getDateEndValidity() == null) {
				n.setDateEndValidity(new GregorianCalendar(2100, 01, 01));
			}

			Connection connection = getConnection();

			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("news.creation");
			PreparedStatement statement = connection.prepareStatement(sqlString);
			statement.setString(1,mUIdNews);
			statement.setString(2,caption);
			statement.setString(3,Date2String(n.getDateCreated()));
			statement.setString(4,Date2String(n.getDateLastModified()));
			statement.setString(5,Date2String(n.getDateEndValidity()));
			statement.setString(6,Date2String(n.getDateBeginValidity()));
			statement.setInt(7,n.getDefaultPriority());
			statement.setString(8,n.getHtmlName());
			statement.setString(9,Summary);
			statement.setString(10,n.getUrl());
			statement.setString(11,n.getOwner());

			statement.executeUpdate();

			sqlString = PropertiesManager.getProperty("news.creationLien");

			statement = connection.prepareStatement(sqlString);
			statement.setString(1,uidcat);
			statement.setString(2,mUIdNews);
			statement.setInt(3,n.getDefaultPriority());
			statement.setString(4,"O");
			
			statement.executeUpdate();

			statement.close();
			CachedConnectionsManager.checkIn(connection);

		} catch (SQLException e) {
			log.error("erreur SQL : " + e);
		}
	}

	public void modifyNews(News n) throws Exception {

		String uidcat = "";
		Connection connection = getConnection();

		new PropertiesManager("requetesAdmin.properties");
		String sqlString = PropertiesManager.getProperty("news.chargementLien");

		PreparedStatement statement = connection.prepareStatement(sqlString);
		statement.setString(1,n.getUidNews());

		ResultSet rs = statement.executeQuery();
		rs.next();
		uidcat = rs.getString("uidcat");
		Date answer2b = rs.getDate("datecreated");
		String[] champ_date = answer2b.toString().split("-");
		int year = Integer.parseInt(champ_date[0]);
		int month = Integer.parseInt(champ_date[1]) - 1;
		int day = Integer.parseInt(champ_date[2]);
		Calendar dateCreated = new GregorianCalendar();
		dateCreated.set(year, month, day);
		n.setDateCreated(dateCreated);

		GregorianCalendar greg = new GregorianCalendar();
		greg.setTime(new java.util.Date());
		n.setDateLastModified(greg);

		this.deleteNews(n.getUidNews());

		String replace = "''";
		String caption = n.getCaption().replaceAll("'", replace);
		String Summary = n.getSummary().replaceAll("'", replace);

		if (n.getDateBeginValidity() == null) {
			n.setDateBeginValidity(greg);
		}

		if (n.getDateEndValidity() == null) {
			n.setDateEndValidity(new GregorianCalendar(2100, 01, 01));
		}

		//on insre la news avec les modifications
		sqlString = PropertiesManager.getProperty("news.creation");
		statement = connection.prepareStatement(sqlString);
		statement.setString(1,n.getUidNews());
		statement.setString(2,caption);
		statement.setString(3,Date2String(n.getDateCreated()));
		statement.setString(4,Date2String(n.getDateLastModified()));
		statement.setString(5,Date2String(n.getDateEndValidity()));
		statement.setString(6,Date2String(n.getDateBeginValidity()));
		statement.setInt(7,n.getDefaultPriority());
		statement.setString(8,n.getHtmlName());
		statement.setString(9,Summary);
		statement.setString(10,n.getUrl());
		statement.setString(11,n.getOwner());

		statement.executeUpdate();

		//on remet la news dans le bon canal
		sqlString = PropertiesManager.getProperty("news.creationLien");
		statement = connection.prepareStatement(sqlString);
		statement.setString(1,uidcat);
		statement.setString(2,n.getUidNews());
		statement.setInt(3,n.getDefaultPriority());
		statement.setString(4,"O");
			
		statement.executeUpdate();

		CachedConnectionsManager.checkIn(connection);

		statement.close();

	}

	/**
	 * Permet de convertir un calendar en un format compr?hensible pour les query SQL
	 **/

	public String Date2String(Calendar cal) {
		String annee = String.valueOf(cal.get(Calendar.YEAR));
		String mois = String.valueOf((cal.get(Calendar.MONTH)) + 1);
		log.debug("SQLNEWS : Mois = " + mois);
		if (mois.length() == 1)
			mois = "0" + mois;
		String jour = String.valueOf(cal.get(Calendar.DATE));
		if (jour.length() == 1)
			jour = "0" + jour;
		return annee + "-" + mois + "-" + jour;
	}

	/**
	 * Supprime de la table NEWDISPATCHNEWS toutes les entres 
	 * attaches  la catgorie passe en paramtre 
	 * @param uidCat
	 */
	public void unpublishByCat(String uidCat) throws Exception {
		PreparedStatement stmt = null;
		String sqlString;
		Connection connection;

		try {
			connection = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("news.suppressionLienParCanal");
			
			stmt = connection.prepareStatement(sqlString);
			stmt.setString(1,uidCat);
			stmt.executeUpdate();
			stmt.close();
			CachedConnectionsManager.checkIn(connection);

		} catch (SQLException e) {
			log.error(
				"Erreur SQL lors du chargement des categories filles : " + e);
		}
	}

	/**
	 * Supprime de la table NEWS toutes les news attaches  
	 * la catgorie passe en paramtre dans la table NEWDISPATCHNEWS
	 * @param uidCat
	 * @throws ClassNotFoundException
	 */
	public void deleteNewsByCat(String uidCat) throws Exception {
		PreparedStatement stmt = null;
		String sqlString;
		ResultSet rst;
		Connection connection;

		try {
			connection = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("news.newsParCanal");
			stmt = connection.prepareStatement(sqlString);
			stmt.setString(1,uidCat);
			rst = stmt.executeQuery();

			while (rst.next()) {
				deleteNews((String) rst.getString("uidnews"));
			}

			stmt.close();
			CachedConnectionsManager.checkIn(connection);

		} catch (SQLException e) {
			log.error(
				"Erreur SQL lors du chargement des categories filles : " + e);
		}
	}

	/**
	 * @param string
	 * @return
	 */
	public Vector getMessagedOwnedBy(String uidUser) throws Exception {
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vNews = new Vector(0);
		Connection connection;

		try {
			connection = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("news.newsParOwner");
			stmt = connection.prepareStatement(sqlString);
			stmt.setString(1,uidUser);
			rst = stmt.executeQuery();

			while (rst.next())
				vNews.addElement(rst.getString("uidnews"));
			stmt.close();
			return vNews;
		} catch (SQLException e) {
			log.error("Erreur SQL lors du chargement des messages : " + e);
			return null;
		}
	}

}
