/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories.*;


/**
 * Description :<br/>
 * Encapsule les donnes concernant une entre dans CATSPROFILS
 * qui stocke les liens entre les profils et les catgories :<br/>
 * CATSPROFILS(uidprof,ordre,uiddesccat)
 * @version $Id : CatsProfils.java, V1.0, 13 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : CatsProfils<br/>
 */
public class CatsProfils  implements java.io.Serializable {
	static Logger log;

	private Profils profil;
	private Categories categorie;
	private long ordre=0;
	
	private boolean existe=false;			// vrai si le lien est dans la bd
	
	public CatsProfils(){
		log = Logger.getLogger(this.getClass().getPackage().getName());
	}
	
	/**
	 * Demande le chargement du lien  partir de la base
	 * @param prof	Profil du lien  charger
	 * @param cat	Catgorie du lien  charger
	 * @param sqlCP	Objet SqlCatsProfils regroupant les accs  la table CATSPROFILS
	 * @throws Exception
	 */
	public CatsProfils(Profils prof, Categories cat) throws Exception {
		log = Logger.getLogger(this.getClass().getPackage().getName());

		try {
			setProfil(prof);
			setCategorie(cat);
			existe = SqlCatsProfils.loadCatsProfils(this);
			if(!existe){
				// on est dans le cadre d'une cration de lien
				if((prof.isExiste())&&(cat.isExiste()))				
					setOrdre(prof.getOrdreMax()+1);
			}		
		} catch (Exception e){
			log.error("CatsProfils - constructeur : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Demande le chargement du profil  partir de la base
	 * @param uidProf	uid du profil du lien  charger
	 * @param uidCat	uid de la catgorie du lien  charger
	 * @param sqlCP		Objet SqlCatsProfils regroupant les accs  la table CATSPROFILS
	 * @throws Exception
	 */
	public CatsProfils (String uidProf, String uidCat)throws Exception{
		this(new Profils(uidProf), new Categories(uidCat));

	}

	
	/**
	 * Demande le chargement du profil  partir de la base
	 * @param prof		Profil du lien  charger
	 * @param ordre		Ordre du lien  tlcharger
	 * @param sqlCP		Objet SqlCatsProfils regroupant les accs  la table CATSPROFILS
	 * @throws Exception
	 */
	public CatsProfils (Profils prof, long ordre) throws Exception{
		log = Logger.getLogger(this.getClass().getPackage().getName());

		try{
			setProfil(prof);
			setOrdre(ordre);
			existe = SqlCatsProfils.loadCatsProfils(this);
		}catch (Exception e){
			log.error("CatsProfils - constructeur " + e.getMessage());
			throw e;
		}
	}

	public void create() throws Exception {
		SqlCatsProfils.createCatsProfils(this);
	}
	
	public void modif() throws Exception {
		SqlCatsProfils.modifCatsProfils(this);
	}
	
	/**
	 * Supprime le lien de la base en diminuant d'1 l'ordre
	 * de tous les liens au mme profil et d'ordre suprieur du lien supprim 
	 * @throws Exception
	 */
	public void delete() throws Exception {
		try {
			// supprimer le lien de la base de donnes
			SqlCatsProfils.deleteCatsProfils(this);
				
			// rcuperer les uidcats des catgories attaches d'ordre suprieur au lien courant
			Vector vCats = SqlCatsProfils.getCategoriesAttachees(getProfil(),getOrdre());
			
			// on remonte ces catgories
			for(Enumeration e = vCats.elements();e.hasMoreElements();) {
				Categories cat=new Categories((String)e.nextElement());
				CatsProfils lien = new CatsProfils(getProfil(),cat);
				lien.moveCategorieUp();
			}
			
			// on vrifie que la catgorie est encore attache soit  un profil, soit  une catgorie
			// si non, on supprime la catgorie
			if ((categorie.getAscendanceUidcats().isEmpty()) && (categorie.getProfilsAttaches().isEmpty()))
				categorie.delete();
		} catch (Exception e) {
			log.error("CatsProfils - delete " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Mthode qui permute l'ordre de ce lien avec celui du lien juste au dessus
	 * @throws Exception
	 */
	private void moveCategorieUp() throws Exception {
		try {
			if (getOrdre()<=1)	return;
			CatsProfils lien = new CatsProfils(profil,getOrdre()-1);
			
			if (lien.isExiste()) {
				lien.setOrdre(this.getOrdre());
				SqlCatsProfils.modifCatsProfils(lien);
			}	
			this.setOrdre(getOrdre()-1);
			SqlCatsProfils.modifCatsProfils(this);	
		} catch (Exception e) {
			log.error("CatsProfils - moveCategorieUp " + e.getMessage());
			throw e;
		}
	}

	public Categories getCategorie() {
		return categorie;
	}

	/**
	 * Dtermine si le lien est dans la DB
	 * @return true si le lien est dans la DB
	 */
	public boolean isExiste() {
		return existe;
	}

	public long getOrdre() {
		return ordre;
	}

	public Profils getProfil() {
		return profil;
	}

	public void setCategorie(Categories categories) {
		categorie = categories;
	}

	public void setExiste(boolean b) {
		existe = b;
	}

	public void setOrdre(long x) {
		ordre = x;
	}

	public void setProfil(Profils profils) {
		profil = profils;
	}
}