/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Description :<br/>
 * Encapsule les donnes concernant une entre dans PROFILS
 * qui stocke les informations sur les profils : </br>
 * PROFILS(uidprof,caption,admcats,admnews,admPBornes,admPortail) </br>
 * Les champs "admPBornes" et "admPortails" ne sont plus 
 * utiliss et sont remplis par dfaut par "N" et "N"
 * @version $Id : Profils.java, V1.0, 13 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : Profils <br/>
 */
public class Profils  implements java.io.Serializable {
	static Logger log;
	
	//	Champs de la table CATEGORIES
    private String uidProf;
	private String caption;
	private boolean admCats;
	private boolean admNews;
	private boolean admProfils;
    
    private boolean existe = false;	// vrai si le profil est dans la BD
    
    public Profils() {
		log = Logger.getLogger(this.getClass().getPackage().getName());
    }

	/**
	 * Demande le chargement du profil  partir de la base
	 * @param uidProf	uid du profil
	 * @param sqlProf	Objet SqlProfils regroupant les accs  la table PROFILS
	 * @throws Exception
	 */
	public Profils(String uidProf) throws Exception {
		log = Logger.getLogger(this.getClass().getPackage().getName());
		setUidProf(uidProf);
		try {
			existe = SqlProfils.loadProfils(this);
		} catch (Exception e) {
			log.error("Profils - constructeur : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Demande le chargement du profil  partir de la base
	 * puis affecte les valeurs passes en paramtres
	 * @param uidProf	uid du profil
	 * @param caption	valeur  affecter au champ caption
	 * @param admCats	valeur  affecter au champ admcats
	 * @param admNews	valeur  affecter au champ admnews
	 * @param sqlProf	Objet SqlProfils regroupant les accs  la table PROFILS
	 */
	public Profils(
		String uidProf,
		String caption,
		boolean admCats,
		boolean admNews,
		boolean admProfils)
		throws Exception {
		
		this(uidProf);
		this.setCaption(caption);
		this.setAdmCats(admCats);
		this.setAdmNews(admNews);
		this.setAdmProfils(admProfils);
	}

	public void create() throws Exception {
		SqlProfils.createProfils(this);
	}
	
	public void modif() throws Exception {
		SqlProfils.modifProfils(this);
	}
	
	/**
	 * Supprime le profil de la base :
	 * Vrifie qu'il n'existe plus d'utilisateurs des utilisateurs possdant ce profil
	 * Supprime les liens avec des catgories
	 * Enfin, supprime le profil
	 * @throws Exception
	 */
	public void delete() throws Exception {
		try {
			// on vrifie que le profil est dans la base et qu'il n'y a plus d'utilisateur possdant ce profil
			if (isExiste() && getUsers().isEmpty()) {
				// supprimer les liens attachant des catgories  ce profil
				SqlCatsProfils.deleteCatsLinks(this);
				
				// supprimer le profil
				SqlProfils.deleteProfils(this);
			} 
		} catch (Exception e) {
			log.error("Profils - delete : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie l'ordre maximal des liens auxquels ce profil est rattach
	 * @return Ordre maximal des liens auxquels ce profil est rattach
	 * @throws Exception
	 */
	public long getOrdreMax() throws Exception {
		try {
			return SqlCatsProfils.nbCategoriesAttachees(this);
		} catch (Exception e) {
			log.error("Profils - getOrdreMax : " + e.getMessage());
			throw e;
		}
		
	}
	
	public static Vector getAllProfils() throws Exception {
		return SqlProfils.getAllProfilsUid();
	}
	
	/**
	 * Renvoie la liste des utilisateurs possdant le profil courant
	 * @return Vector des uiduser des utilisateurs possdant le profil courant
	 */
	public Vector getUsers() throws Exception {
		try {
			return SqlUsers.getUsersUidusers(this);
		} catch (Exception e) {
			log.error("Profils - getUsers : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la liste des categories associes  ce profil
	 * @return Vector des uidcat des categories associes  ce profil
	 */
	public Vector getCategoriesAttachees() throws Exception {
		try {
			return SqlCatsProfils.getCategoriesAttachees(this);
		} catch (Exception e) {
			log.error("Profils - getCategoriesAttachees : " + e.getMessage());
			throw e;
		}
	}


	public String getCaption() {
		return caption;
	}

	public void setCaption(String string) {
		caption = string;
	}

	public boolean isExiste() {
		return existe;
	}

	public void setExiste(boolean b) {
		existe = b;
	}

	public void setAdmCats(boolean b) {
		admCats = b;
	}

	public void setAdmNews(boolean b) {
		admNews = b;
	}

	public boolean isAdmCats() {
		return admCats;
	}

	public boolean isAdmNews() {
		return admNews;
	}

	public String getUidProf() {
		return uidProf;
	}

	public void setUidProf(String string) {
		uidProf = string;
	}

	/**
	 * @return
	 */
	public boolean isAdmProfils() {
		return admProfils;
	}

	/**
	 * @param b
	 */
	public void setAdmProfils(boolean b) {
		admProfils = b;
	}

}
