/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;

import java.util.Vector;


/**
 * Description :<br/>
 * Classe fournissant toutes les mthodes permettant de grer les utilisateurs et les profils
 * @version $Id : ProfilsServices.java, V1.0, 31 mars 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : ProfilsServices<br/>
 */
public class ProfilsServices {
	static Logger log;


	/**
	 * Constructeur  
	 * Init the database connection
	 */
	public ProfilsServices() throws Exception{
		try {
			log = Logger.getLogger(this.getClass().getPackage().getName());
			new PropertiesManager("applinews.properties");
			String logConfFile = PropertiesManager.getProperty("logConfFile");

			PropertyConfigurator.configure(logConfFile);
			log.info("** ProfilsServices - Entree **");
		} catch (Exception e) {
			log.error("ProfilsServices - constructeur : " + e);
			throw e;
		}
	}
	
	/**
	 * 
	 * @return true
	 */
	public boolean test(){
		return true;
	}

	/**
	 * Ajoute un nouveau profil dans la BD
	 * @param uidProf	uid du profil
	 * @param caption	valeur  affecter au champ caption
	 * @param admCats	valeur  affecter au champ admcats
	 * @param admNews	valeur  affecter au champ admnews
	 */
	public void createProfils(String uidProf, String caption, boolean admCats, boolean admNews, boolean admProfils) throws Exception{
		try{
			Profils profil = new Profils(uidProf, caption, admCats, admNews, admProfils);
			profil.create();
		} catch (Exception e) {
			log.error("ProfilsServices - createProfils : " + e.getMessage());
			throw e;
		} 
	}
		
	/**
	 * Modifie un profil dans la BD
	 * @param uidProf	uid du profil
	 * @param caption	valeur  affecter au champ caption
	 * @param admCats	valeur  affecter au champ admcats
	 * @param admNews	valeur  affecter au champ admnews
	 */
	public void modifProfils(String uidProf, String caption, boolean admCats, boolean admNews, boolean admProfils) throws Exception{
		try{
			Profils profil = new Profils(uidProf, caption, admCats, admNews, admProfils);
			if(profil.isExiste())
				profil.modif();
		} catch (Exception e) {
			log.error("ProfilsServices - modifProfils : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Supprime un profil de la BD
	 * @param uidProf	uid du profil
	 * @throws Exception
	 */
	public  void deleteProfils(String uidProf) throws Exception {
		try{
			Profils profil = new Profils(uidProf);
			profil.delete();
		} catch(Exception e){
			log.error("ProfilsServices - deleteProfils : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Vrifie si le profil est dans la base de donnes
	 * @param uidProf	uid du profil
	 * @return	true si le profil est dans la base
	 * @throws Exception
	 */
	public boolean profExiste(String uidProf) throws Exception{
		try {
			Profils prof=new Profils(uidProf);
			return prof.isExiste();
		} catch (Exception e) {
			log.error("ProfilsServices - profExiste : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la valeur du champ caption d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ caption
	 * @throws Exception
	 */
	public String getCaptionProfils(String uidProf) throws Exception {
		try {
			Profils prof=new Profils(uidProf);
			return prof.getCaption();
		} catch (Exception e) {
			log.error("ProfilsServices - getCaptionProfils : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la valeur du champ admcats d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admcats
	 * @throws Exception
	 */
	public boolean getAdmCatsProfils(String uidProf) throws Exception {
		try {
			Profils prof=new Profils(uidProf);
			log.debug("ProfilsServices - getAdmCatsProfils : " + prof.isAdmCats());			
			return prof.isAdmCats();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmCatsProfils : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la valeur du champ admnews d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admnews
	 * @throws Exception
	 */
	public boolean getAdmNewsProfils(String uidProf) throws Exception {
		try {
			Profils prof=new Profils(uidProf);
			return prof.isAdmNews();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmNewsProfils : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la valeur du champ admprofs d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admprofs
	 * @throws Exception
	 */
	public boolean getAdmProfilsProfils(String uidProf) throws Exception {
		try {
			Profils prof=new Profils(uidProf);
			return prof.isAdmProfils();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmProfilsProfils : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Add a new catsProfils into the database
	 * @param uidProf	uid du profil du lien
	 * @param uidDescCat	uid de la catgorie du lien
	 * @throws Exception
	 */
	public void createCatsProfils (String uidProf, String uidDescCat)throws Exception {
		try{
			CatsProfils catsProfils = new CatsProfils(uidProf, uidDescCat);
			catsProfils.create();
		} catch(Exception e){
			log.error("ProfilsServices - createCatsProfils : " + e.getMessage());
			throw e;
		}
	}
		
	/**
	 * Delete a catsProfils into the database
	 * @param uidProf	uid du profil du lien
	 * @param uidDescCat	uid de la catgorie du lien
	 * @throws Exception
	 */
	public void deleteCatsProfils(String uidProf, String uidDescCat) throws Exception {
		try{
			CatsProfils catsProfils = new CatsProfils(uidProf, uidDescCat);
			catsProfils.delete();
		} catch(Exception e){
			log.error("ProfilsServices - deleteCatsProfils : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Add a new users into the database
	 * @param uidUser	uid de l'utilisateur
	 * @param uidProf	valeur du champ profil
	 * @param nomComplet	valeur du champ nomcomplet
	 * @throws Exception
	 */
	public void createUsers(String uidUser, String uidProf, String nomComplet) throws Exception {
		try{
			Users user = new Users(uidUser, uidProf, nomComplet);
			log.info("ProfilsServices::createUsers() : user charg");
			user.create();
			log.info("ProfilsServices::createUsers() : user cr dans la base");
		} catch(Exception e){
			log.error("ProfilsServices - createUsers : " + e+":"+e.getMessage());
			throw e;
		}
	}
		
	/**
	 * Modify an existing users into the database
	 * @param uidUser	uid de l'utilisateur
	 * @param uidProf	valeur du champ profil
	 * @param nomComplet	valeur du champ nomcomplet
	 * @throws Exception
	 */
	public void modifUsers(String uidUser, String uidProf, String nomComplet) throws Exception {
		try{
			log.info("ProfilsServices - modifUsers : uiduser = "+ uidUser);
			log.info("                   			 nomcomplet = "+nomComplet);
			log.info("                   			 uidprof = "+uidProf);
			Users user = new Users(uidUser, uidProf, nomComplet);
			if(user.isExiste())
				user.modif();
		} catch(Exception e){
			log.error("ProfilsServices - modifUsers : " + e.getMessage());
			throw e;
		}
	}

	public void addProfilToUser(String uidUser, String uidProf) throws Exception {
		try{
			log.info("ProfilsServices - addProfilToUser : uiduser = "+ uidUser);
			log.info("                   			 uidprof = "+uidProf);
			Users user = new Users(uidUser);
			if(user.isExiste() && !user.possede(uidProf))
				user.addProfil(uidProf);
		} catch(Exception e){
			log.error("ProfilsServices - addProfilToUser : " + e.getMessage());
			throw e;
		}
	}

	public void removeProfilToUser(String uidUser, String uidProf) throws Exception {
		try{
			log.info("ProfilsServices - removeProfilToUser : uiduser = "+ uidUser);
			log.info("                   			 uidprof = "+uidProf);
			Users user = new Users(uidUser);
			if(user.isExiste() && user.possede(uidProf))
				user.removeProfil(uidProf);
		} catch(Exception e){
			log.error("ProfilsServices - removeProfilToUser : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Delete a users into the database
	 * @param uidUser	uid de l'utilisateur
	 * @throws Exception
	 */
	public void deleteUsers(String uidUser) throws Exception{
		try{
			Users user = new Users(uidUser);
			user.delete();
		} catch(Exception e){
			log.error("ProfilsServices - modifUsers : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Vrifie si un utilisateur est dans la BD
	 * @param uidUser	uid de l'utilisateur
	 * @return	true si l'utilisateur est dans la BD
	 * @throws Exception
	 */
	public boolean userExiste(String uidUser) throws Exception{
		try {
			Users user=new Users(uidUser);
			return user.isExiste();
		} catch(Exception e){
			log.error("ProfilsServices - userExiste : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la valeur du champ admcats d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admcats
	 * @throws Exception
	 */
	public boolean getAdmCatsUsers(String uidUser) throws Exception {
		try {
			Users user=new Users(uidUser);
			log.debug("ProfilsServices - getAdmCatsUsers: "+user.getProfils());
			log.debug("ProfilsServices - getAdmCatsUsers: "+user.isAdmCats());
			return user.isAdmCats();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmCatsUsers : " +e+" : "+ e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la valeur du champ admnews d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admnews
	 * @throws Exception
	 */
	public boolean getAdmNewsUsers(String uidUser) throws Exception {
		try {
			Users user=new Users(uidUser);
			log.debug("ProfilsServices - getAdmNewsUsers: "+user.isAdmNews());
			return user.isAdmNews();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmNewsUsers : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la valeur du champ admprofs d'un profil
	 * @param uidProf	uid du profil
	 * @return	Valeur du champ admprofs
	 * @throws Exception
	 */
	public boolean getAdmProfilsUsers(String uidUser) throws Exception {
		try {
			Users user=new Users(uidUser);
			log.debug("ProfilsServices - getAdmProfilsUsers: "+user.isAdmProfils());
			return user.isAdmProfils();
		} catch (Exception e) {
			log.error("ProfilsServices - getAdmProfilsUsers : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la liste des utilisateurs rattachs  un profil
	 * @param uidProf	uid du profil
	 * @return Vector contenant les uiduser des utilisateurs possdant ce profil
	 * @throws Exception
	 */
	public Vector getProfilUsers(String uidProf) throws Exception {
		try{
			Profils profil = new Profils(uidProf);
			return profil.getUsers();
		} catch(Exception e){
			log.error("ProfilsServices - getProfilUsers : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie le champ nomcomplet d'un utilisateur
	 * @param uidUser	uid de l'utilisateur
	 * @return	valeur du champ nomcomplet
	 * @throws Exception
	 */
	public String getNomCompletUser(String uidUser) throws Exception{
		try {
			Users user = new Users(uidUser);
			return user.getNomComplet();
		} catch(Exception e){
			log.error("ProfilsServices - getNomCompletUsers : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la liste des profils d'un utilisateur
	 * @param uidUser	uid de l'utilisateur
	 * @return	uidprof du profil de l'utilisateur
	 * @throws Exception
	 */
	/*public Vector getProfil(String uidUser) throws Exception {
		try {
			log.debug("ProfilsServices::getProfil() - user="+uidUser);
			Users user = new Users(uidUser);
			Vector v= user.getProfils();
			log.debug("ProfilsServices::getProfil() - l'utilisateur possde "+v.size()+" profil(s)");
			return user.getProfilsUid();
		} catch(Exception e){
			log.error("ProfilsServices::getProfil : " + e.getMessage());
			throw e;
		}
	}*/

	/**
	 * Renvoie la liste des profils d'un utilisateur
	 * @param uidUser	uid de l'utilisateur
	 * @return	uidprof du profil de l'utilisateur
	 * @throws Exception
	 */
	public Vector getProfils(String uidUser) throws Exception {
		try {
			log.debug("ProfilsServices::getProfils() - user="+uidUser);
			Users user = new Users(uidUser);
			log.debug("ProfilsServices::getProfils() - fin");
			return user.getProfilsUid();
		} catch(Exception e){
			log.error("ProfilsServices::getProfils : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la liste des profils existants
	 * @return Vector contenant les uidprof des profils existants
	 * @throws Exception
	 */
	public Vector getAllProfils() throws Exception {
		try{
			return Profils.getAllProfils();
		} catch(Exception e){
			log.error("ProfilsServices - getAllProfils : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la liste de tous les utilisateurs
	 * @return Vector contenant les uiduser des utilisateurs
	 * @throws Exception
	 */
	public Vector getAllUsers() throws Exception {
		try{
			return Users.getAllUsers();
		} catch(Exception e){
			log.error("ProfilsServices - getProfilUsers : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la liste des catgories rattaches  un profil
	 * @param uidProf	uid du profil
	 * @return Vector contenant les uidcat des catgories attaches au profil
	 * @throws Exception
	 */
	public Vector getCategoriesAttachees(String uidProf) throws Exception {
		try{
			Profils profil = new Profils(uidProf);
			return profil.getCategoriesAttachees();
		} catch(Exception e){
			log.error("ProfilsServices - getCategoriesAttachees : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Renvoie la liste des news appartenant  l'utilisateur pass en paramtre
	 * @param uidUser	uid de l'utilisateur
	 * @return Vector contenant les uidnews des news dont l'utilisateur est owner
	 * @throws Exception
	 */
	public Vector getNews(String uidUser) throws Exception {
		try{
			Users user = new Users(uidUser);
			return user.getMessages();
		} catch(Exception e){
			log.error("ProfilsServices - getNews : " + e.getMessage());
			throw e;
		}
	}
	
	public void close() throws Exception{
	}
}
