/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import java.sql.*;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionCategories.Categories.* ;
import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.*;

/**
 * Description :<br/>
 * Classe regroupant les accs  la base de donnes
 * concernant la table CATSPROFILS qui stocke les liens entre
 * les profils et les catgories de la base:
 * CATSPROFILS(uidprof,ordre,uiddesccat)
 * @version $Id : SqlCatsProfils.java, V1.0, 13 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SqlCatsProfils<br/>
 */
public class SqlCatsProfils {
	static String pool = "applinews";
	static Logger log;

	public SqlCatsProfils() throws Exception {
		log = Logger.getLogger(this.getClass().getPackage().getName());
	}

	private static Connection getConnection() throws Exception {
		return CachedConnectionsManager.checkOut(pool);
	}
	/**
	 * Charge le lien s'il est dans la base
	 * On peut charger un lien entre un profil et une catgorie donns
	 * ou un lien concernant un profil pour un ordre donn
	 * @param lien	lien  charger
	 * @return true si le lien est bien dans la DB
	 * @throws Exception
	 */
	public static boolean loadCatsProfils(CatsProfils lien) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			if (lien.getOrdre() == 0) {
				// cas o on charge un lien entre 1 user et 1 profil connus
				try {
					conn = getConnection();
					new PropertiesManager("requetesAdmin.properties");
					sqlString = PropertiesManager.getProperty("canauxprofils.chargement1");
					stmt = conn.prepareStatement(sqlString);
					stmt.setString(1,lien.getProfil().getUidProf());
					stmt.setString(2,lien.getCategorie().getUidCat());
					rst = stmt.executeQuery();
	
					if (rst.next()) {
						lien.setOrdre(rst.getLong("ordre"));
						stmt.close();
						return true;
					} else {
						stmt.close();
						return false;
					}
	
				} catch (Exception e) {
					log.error("SqlCatsProfils - loadCatsProfils : " + e.getMessage());
					throw e;
				}
			} else {
				// cas o on charge un lien d'un profil  un ordre donn
				try {
					conn = getConnection();
					new PropertiesManager("requetesAdmin.properties");
					sqlString = PropertiesManager.getProperty("canauxprofils.chargement2");
					stmt = conn.prepareStatement(sqlString);
					stmt.setString(1,lien.getProfil().getUidProf());
					stmt.setLong(2,lien.getOrdre());
					rst = stmt.executeQuery();
	
					if (rst.next()) {
						Categories cat =
							new Categories(rst.getString("uiddesccat"));
	
						lien.setCategorie(cat);
	
						stmt.close();
						return true;
					} else {
						stmt.close();
						return false;
					}
	
				} catch (SQLException e) {
					log.error("SqlCatsProfils - loadCatsProfils : " + e.getMessage());
					throw e;
				}
			}
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Ajoute le lien pass en paramtre dans la base
	 * @param lien	lien  crer
	 * @throws Exception
	 */
	public static void createCatsProfils(CatsProfils lien) throws Exception {
		Connection conn = null;
		PreparedStatement statement = null;
		try {
			if (lien.getOrdre() > 0) {
				if (!lien.isExiste()) {
					conn = getConnection();
					new PropertiesManager("requetesAdmin.properties");
					String sqlString = PropertiesManager.getProperty("canauxprofils.creation");
					statement = conn.prepareStatement(sqlString);
					statement.setString(1, lien.getProfil().getUidProf());
					statement.setLong(2, lien.getOrdre());
					statement.setString(3, lien.getCategorie().getUidCat());

					statement.executeUpdate();
					statement.close();
					lien.setExiste(true);
				}
			} else {
				if (lien.getOrdre() <= 0)
					log.debug(
						"SqlCatsProfils - lien non valide : ordre = "
							+ lien.getOrdre());
			}

		} catch (SQLException e) {
			log.error("SqlCatsProfils - createCatsProfils : " + e.getMessage());
			throw e;
		} finally {
			if (statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Modifie le lien pass en paramtre dans la base
	 * @param lien	lien  modifier
	 * @throws Exception
	 */
	public static void modifCatsProfils(CatsProfils lien) throws Exception {
		Connection conn = null;
		PreparedStatement statement = null;
		try {
			if (lien.isExiste()) {
				conn = getConnection();
				new PropertiesManager("requetesAdmin.properties");
				String sqlString = PropertiesManager.getProperty("canauxprofils.modification");
				statement = conn.prepareStatement(sqlString);
				statement.setLong(1, lien.getOrdre());
				statement.setString(2, lien.getProfil().getUidProf());
				statement.setString(3, lien.getCategorie().getUidCat());
				statement.executeUpdate();
				statement.close();
			}
		} catch (Exception e) {
			log.error("SqlCatsProfils - modifCatsProfils : " + e.getMessage());
			throw e;
		} finally {
			if (statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Supprime de la base le lien pass en paramtre
	 * @param lien	lien  supprimer
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void deleteCatsProfils(CatsProfils lien)
		throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		String sqlString;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.suppression");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,lien.getProfil().getUidProf());
			stmt.setString(2,lien.getCategorie().getUidCat());
			stmt.executeUpdate();
			stmt.close();
			lien.setExiste(false);
		} catch (Exception e) {
			log.error("SqlCatsProfils - deleteCatsProfils : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Supprime de la table CATSPROFILS tous les liens concernant le profil pass en paramtre
	 * @param profil
	 */
	public static void deleteCatsLinks(Profils profil) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			String sqlString;
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.suppressionParProfil");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,profil.getUidProf());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlCatsProfils - deleteCatsLinks : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Supprime de la table CATSPROFILS tous les liens concernant la catgorie passe en paramtre
	 * @param categories
	 */
	public static void deleteCatsLinks(Categories categories) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			String sqlString;
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.suppressionParCanal");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,categories.getUidCat());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlCatsProfils - deleteCatsLinks : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
		
	}

	/**
	 * Renvoie le nombre de catgories attaches au profil pass en paramtre
	 * @param profil
	 * @return Nombre de catgories attaches au profil
	 */
	public static long nbCategoriesAttachees(Profils profil) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.nbCanauxAttaches");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,profil.getUidProf());
			rst = stmt.executeQuery();

			if (rst.next()) {
				long n = rst.getLong(1);
				stmt.close();
				return n;
			} else {
				stmt.close();
				return 0;
			}
		} catch (Exception e) {
			log.error("SqlCatsProfils - nbCategoriesAttachees : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Renvoie la liste des catgories attaches  un profil
	 * @param uidProf uid du profil
	 * @return Vector des uidcat des catgories attaches au profil
	 */
	public static Vector getCategoriesAttachees(Profils prof) throws Exception {
		return getCategoriesAttachees(prof, 0);
	}

	/**
	 * Renvoie la liste des catgories attaches  un profil
	 *  partir d'un ordre donn
	 * @param uidProf	uid du profil
	 * @param ordre		ordre minimal
	 * @return Vector des uidcat des catgories attaches au profil  partir de l'ordre pass en paramtre
	 */
	public static Vector getCategoriesAttachees(Profils prof, long ordre) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vCats = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.canaux");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,prof.getUidProf());
			stmt.setLong(2,ordre);
			rst = stmt.executeQuery();

			while (rst.next()) {
				vCats.addElement(rst.getString("uiddesccat"));
			}
			stmt.close();
			return vCats;
		} catch (SQLException e) {
			log.error("SqlCatsProfils - getCategoriesAttachees : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	public static Vector getCategoriesAttachees(Vector vUidProf) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vCats = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = "select distinct uiddesccat from CATSPROFILS where uidprof in (";
			for(Enumeration e=vUidProf.elements();e.hasMoreElements();) {
				sqlString += "'"+(String) e.nextElement()+"'";
				if(e.hasMoreElements()) sqlString += ",";
			}
			sqlString += ")";
			stmt = conn.prepareStatement(sqlString);
			rst = stmt.executeQuery();

			while (rst.next()) {
				vCats.addElement(rst.getString("uiddesccat"));
			}
			stmt.close();
			return vCats;
		} catch (SQLException e) {
			log.error("SqlCatsProfils::getCategoriesAttachees : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Renvoie la liste des profils attachs  une catgorie
	 * @param categories	
	 */
	public static Vector getProfilsAttaches(Categories categories) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector v = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("canauxprofils.profils");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,categories.getUidCat());
			rst = stmt.executeQuery();

			while (rst.next()) {
				v.addElement(rst.getString("uidprof"));
			}
			stmt.close();
			return v;
		} catch (Exception e) {
			log.error("SqlCatsProfils - getProfilsAttaches : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}	
	}

}