/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;


import java.sql.*;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.*;


/**
 * Description :<br/>
 * Classe regroupant les accs  la base de donnes
 * concernant la table PROFILS qui stocke les catgories de la base:<br/>
 * PROFILS(uidprof,caption,admcats,admnews,admPBornes,admPortail) </br>
 * Les champs "admPBornes" et "admPortails" ne sont plus 
 * utiliss et sont remplis par dfaut par "N" et "N"
 * @version $Id : SqlProfils.java, V1.0, 31 mars 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SqlProfils<br/>
 */
public class SqlProfils {

	static String pool = "applinews";
	static Logger log;

	public SqlProfils() throws Exception {
		log = Logger.getLogger(this.getClass().getPackage().getName());
	}
	
	private static Connection getConnection() throws Exception{
		return CachedConnectionsManager.checkOut(pool);
	}
	
	/**
	 * Charge le profil s'il est dans la base
	 * @param profil	profil  charger
	 * @return true si le profil est bien dans la base
	 * @throws Exception
	 */
	public static boolean loadProfils(Profils profil) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("profil.chargement");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,profil.getUidProf());
			rst = stmt.executeQuery();
			
			if (rst.next()) {
				if (rst.getString(1) != null)
					profil.setCaption(rst.getString(1));
				else
					profil.setCaption("");
				
				profil.setAdmCats(
					rst.getString(2).equals("O"));
				profil.setAdmNews(
					rst.getString(3).equals("O"));
				profil.setAdmProfils(
					rst.getString(4).equals("O"));
				
				stmt.close();
				return true;
			} else {
				profil.setCaption("");
				profil.setAdmCats(false);
				profil.setAdmNews(false);
				profil.setAdmProfils(false);
				stmt.close();
				return false;
			}
		} catch (SQLException e) {
			log.error("SqlProfils - loadProfils : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Ajoute le profil pass en paramtre dans la base
	 * @param profil	profil  crer
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void createProfils(Profils profil) throws Exception{
		Connection conn = null;
		PreparedStatement statement = null;
		try{
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("profil.creation");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1,profil.getUidProf());
			statement.setString(2,profil.getCaption());
			statement.setString(3,(profil.isAdmCats() ? "O" : "N" ));
			statement.setString(4,(profil.isAdmNews() ? "O" : "N" ));
			statement.setString(5,(profil.isAdmProfils() ? "O" : "N" ));
			statement.executeUpdate();
			
			statement.close();
			profil.setExiste(true);
		} catch(SQLException e){
			log.error("SqlProfils - createProfils : " + e.getMessage());
			throw e;
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Modifie le profil pass en paramtre dans la base
	 * @param profil	profil  modifier
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void modifProfils(Profils profil) throws Exception{
		Connection conn = null;
		PreparedStatement statement = null;
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("profil.modification");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1, profil.getCaption());
			statement.setString(2, (profil.isAdmCats() ? "O" : "N"));
			statement.setString(3, (profil.isAdmNews() ? "O" : "N"));
			statement.setString(4, (profil.isAdmProfils() ? "O" : "N"));
			statement.setString(5, profil.getUidProf());
			
			statement.executeUpdate();
			statement.close();
		} catch (Exception e) {
			System.out.println("SqlProfils - modifProfils : " + e.getMessage());
			throw e;
		} finally {
			if (statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Supprime de la base le profil pass en paramtre
	 * @param uidProf	uid du profil
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public static void deleteProfils(Profils prof) throws Exception{
		Connection conn = null;
		PreparedStatement stmt = null;
		String sqlString;
		
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("profil.suppression");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,prof.getUidProf());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlProfils - deleteProfils : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Renvoie la liste de tous les profils stocks dans la DB
	 * @return Vector des uidprof des profils stocks dans la DB
	 * @throws Exception
	 */
	public static Vector getAllProfilsUid() throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vProfils = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("profil.listeProfils");
			stmt = conn.prepareStatement(sqlString);
			rst = stmt.executeQuery();

			while (rst.next())
				vProfils.addElement(rst.getString("uidprof"));
			stmt.close();
			return vProfils;
		} catch (Exception e) {
			log.error("SqlProfils - getAllProfilsUid : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

}
