/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import java.sql.*;
import java.util.Enumeration;
import java.util.Vector;

import fr.univvalenciennes.publi.utils.db.CachedConnectionsManager;
import fr.univvalenciennes.publi.utils.properties.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * Description :<br/>
 * Classe regroupant les accs  la base de donnes
 * concernant la table USERS qui stocke les utilisateurs de la base:<br/>
 * USERS(uiduser,uidprof,password,nomcomplet,canchangepass)<br/>
 * Les champs "password" et "canchangepass" ne sont plus 
 * utiliss et sont remplis par dfaut respectivement par "" et "N"
 * @version $Id : SqlUsers.java, V1.0, 13 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SqlUsers<br/>
 */

public class SqlUsers {
	static String pool = "applinews";
	private static Log log =  LogFactory.getLog("SqlUsers");
	public SqlUsers() throws Exception {
	}
	
	private static Connection getConnection() throws Exception{
		return CachedConnectionsManager.checkOut(pool);
	}
	
	/**
	 * Charge l'utilisateur s'il est dans la base
	 * @param user	utilisateur  charger
	 * @throws Exception
	 */
	public static boolean loadUsers(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			log.debug("SqlUsers::loadUsers : entree ...");
			
			conn = getConnection();
			
			log.debug("SqlUsers::loadUsers : connexion etablie ... :");
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.chargement");
			log.debug("SqlUsers::loadUsers - sqlString : " + sqlString + " **");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,user.getUidUser());
			rst = stmt.executeQuery();
			
			log.debug("SqlUsers::loadUsers - sqlString : " + sqlString + " **");
			
			if (rst.next()) {
				SqlUsers.loadProfils(user);
				/*while (rst.getString("uidprof") != null){
					log.debug("SqlUsers::loadUsers : uidprof : " + rst.getString("uidprof"));
					user.addProfil(rst.getString("uidprof"));
				}*/

				if (rst.getString("NOMCOMPLET") != null)
					user.setNomComplet((String)rst.getString("NOMCOMPLET"));
				else
					user.setNomComplet("");
				
				stmt.close();
				return true;
			} else {
				user.setProfil(null);
				user.setNomComplet("");
				stmt.close();
				return false;
			}
		} catch (Exception e) {
			log.error("SqlUsers::loadUsers : " + e);
			throw e;
		} finally {
			if (rst != null) rst.close();
			if (stmt != null) stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}

	}

	/**
	 * Charge les profils de l'utilisateur s'il est dans la base
	 * @param user	utilisateur  charger
	 * @throws Exception
	 */
	public static boolean loadProfils(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		boolean ok=false;
		
		try {
			log.debug("SqlUsers::loadProfils : entree ...");
			
			conn = getConnection();
			
			log.debug("SqlUsers::loadProfils : connexion etablie ... :");
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.chargementProfils");
			log.debug("SqlUsers::loadProfils - sqlString : " + sqlString + " **");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,user.getUidUser());
			rst = stmt.executeQuery();
			
			log.debug("SqlUsers::loadProfils - sqlString : " + sqlString + " **");
			
			while (rst.next()) {
				log.debug("SqlUsers::loadProfils : uidprof : " + rst.getString("uidprof"));
				user.getProfils().add(new Profils(rst.getString("uidprof")));

				ok=true;
			} 
			
			stmt.close();
			return ok;
		} catch (Exception e) {
			log.error("SqlUsers::loadProfils : " + e);
			throw e;
		} finally {
			if (rst != null) rst.close();
			if (stmt != null) stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}

	}
	
	/**
	 * Ajoute l'utilisateur pass en paramtre dans la base
	 * @param user	Utilisateur  ajouter
	 * @throws Exception
	 */
	public static void createUsers(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement statement=null;
		try{
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("user.creation");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1,user.getUidUser());
			statement.setString(2,user.getNomComplet());
			statement.executeUpdate();
			log.info("SqlUsers::createUsers() : stockage des profils");
			if(user.getProfils()!=null && user.getProfils().size()>0)
				for(Enumeration e=user.getProfils().elements();e.hasMoreElements();) {
					Profils prof=(Profils)e.nextElement();
					if(!SqlUsers.userHasProfil(user.getUidUser(),prof.getUidProf())) {
						SqlUsers.addProfil(user,prof.getUidProf());
						/*sqlString = PropertiesManager.getProperty("user.addProfil");
						statement = conn.prepareStatement(sqlString);
						statement.setString(1,user.getUidUser());
						statement.setString(2,prof.getUidProf());
						statement.executeUpdate();*/
					}
				}
			user.setExiste(true);
		}
		catch(Exception e){
			log.error("SqlUsers::createUsers : " + e);
			throw e;
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	public static void addProfil(Users user,String uidProf) throws Exception {
		Connection conn = null;
		PreparedStatement statement=null;
		try{
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("user.addProfil");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1,user.getUidUser());
			statement.setString(2,uidProf);
			statement.executeUpdate();
		}
		catch(Exception e){
			log.error("SqlUsers::addProfil : " + e);
			throw e;
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	public static void removeProfil(Users user,String uidProf) throws Exception {
		Connection conn = null;
		PreparedStatement statement=null;
		try{
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("user.suppressionProfil");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1,user.getUidUser());
			statement.setString(2,uidProf);
			statement.executeUpdate();
		}
		catch(Exception e){
			log.error("SqlUsers::removeProfil : " + e);
			throw e;
		} finally {
			if(statement != null)	statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	public static boolean userHasProfil(String uiduser,String uidprof) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.hasProfil");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,uiduser);
			stmt.setString(2,uidprof);
			rst = stmt.executeQuery();

			if (rst.next())
				return true;
			return false;
		} catch (Exception e) {
			log.error("SqlUsers::userHasProfil : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Modifie l'utilisateur pass en paramtre dans la base
	 * @param user	Utilisateur  modifier
	 * @throws Exception
	 */
	public static void modifUsers(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement statement = null;
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			String sqlString = PropertiesManager.getProperty("user.modification");
			statement = conn.prepareStatement(sqlString);
			statement.setString(1, user.getNomComplet());			
			statement.setString(2, user.getUidUser());
			statement.executeUpdate();
			/*for(Enumeration e=user.getProfils().elements();e.hasMoreElements();) {
				String sqlString = PropertiesManager.getProperty("user.modification");
				statement = conn.prepareStatement(sqlString);
				statement.setString(1, (String)e.nextElement());
				statement.setString(2, user.getNomComplet());			
				statement.setString(3, user.getUidUser());
				statement.executeUpdate();
			}*/
		} catch (Exception e) {
			log.error("SqlUsers::modifUsers : " + e.getMessage());
			throw e;
		} finally {
			if (statement != null) statement.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Supprime l'utilisateur pass en paramtre dans la base
	 * @param user	Utilisateur  supprimer
	 * @throws Exception
	 */
	public static void deleteUsers(Users user) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		String sqlString;
	
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.suppression");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,user.getUidUser());
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlUsers::deleteUsers : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Supprime le profil pour l'utilisateur pass en paramtre dans la base
	 * @param user	Utilisateur  supprimer
	 * @throws Exception
	 */
	public static void deleteProfil(String user,String profil) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		String sqlString;
	
		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.suppressionProfil");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,user);
			stmt.setString(2,profil);
			stmt.executeUpdate();
			stmt.close();
		} catch (Exception e) {
			log.error("SqlUsers::deleteProfil : " + e.getMessage());
			throw e;
		} finally {
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}

	/**
	 * Renvoie la liste des utilisateurs possdant un profil donn
	 * @param uidProf	uid du profil
	 * @return Vector des uiduser des utilisateurs possdant le profil
	 */
	public static Vector getUsersUidusers(Profils prof) throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector vUsers = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.listeUsersParProfil");
			stmt = conn.prepareStatement(sqlString);
			stmt.setString(1,prof.getUidProf());
			rst = stmt.executeQuery();

			while (rst.next())
				vUsers.addElement(rst.getString("uiduser"));
			stmt.close();
			return vUsers;
		} catch (Exception e) {
			log.error("SqlUsers::getUsersUidusers : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}
	
	/**
	 * Renvoie la liste de tous les utilisateurs stocks dans la DB
	 * @return Vector des uiduser des utilisateurs stocks dans la DB
	 * @throws Exception
	 */
	public static Vector getAllUsersUid() throws Exception {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rst = null;
		String sqlString;
		Vector v = new Vector(0);

		try {
			conn = getConnection();
			new PropertiesManager("requetesAdmin.properties");
			sqlString = PropertiesManager.getProperty("user.listeUsers");
			stmt = conn.prepareStatement(sqlString);
			rst = stmt.executeQuery();

			while (rst.next())
				v.addElement(rst.getString("uiduser"));
			stmt.close();
			return v;
		} catch (Exception e) {
			log.error("SqlProfils - getAllProfilsUid : " + e.getMessage());
			throw e;
		} finally {
			if (rst != null)	rst.close();
			if (stmt != null)	stmt.close();
			CachedConnectionsManager.checkIn(conn);
		}
	}


}