/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.adminPubli.GestionProfils.Profils;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.WebServices.adminPubli.GestionNews.News.SqlNews;

/**
 * Description :<br/>
 * Encapsule les donnes concernant une entre dans USERS
 * qui stocke les informations sur les utilisateurs : </br>
 * USERS(uiduser,uidprof,password,nomcomplet,canchangepass) </br>
 * Les champs "password" et "canchangepass" ne sont plus 
 * utiliss et sont remplis par dfaut respectivement par "" et "N"
 * @version $Id : Users.java, V1.0, 13 avril 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : Users <br/>
 */
public class Users implements java.io.Serializable {
	static Logger log ;

	private String uidUser;
	private Vector profils;
	private String nomComplet;

	private boolean existe = false; // vrai si le lien est dans la bd

	public Users() {
		log = Logger.getLogger(this.getClass().getPackage().getName());
		nomComplet="";
		this.setProfils(new Vector(0));
	}

	/**
	 * Demande le chargement de l'utilisateur  partir de la base
	 * @param uidUser	uid de l'utilisateur
	 * @param sqlUser	Objet SqlUsers regroupant les accs  la table USERS
	 * @throws Exception
	 */
	public Users(String uidUser) throws Exception {
		this();
		log.info("** Users - constructeur : entree **");
		setUidUser(uidUser);
		try {
			log.info("** Users - constructeur : chargement du user ...");
			existe = SqlUsers.loadUsers(this);
			log.info("** Users - constructeur : user charg");
		} catch (Exception e) {
			log.error("Users - constructeur : " + e);
			throw e;
		}
	}

	public Users(
		String uidUser,
		String uidProf)
		throws Exception {
		
			this(uidUser);
			if(this.getProfils()==null)	this.setProfils(new Vector(0));
			this.getProfils().add(new Profils(uidProf));
	}

	/**
	 * Demande le chargement de l'utilisateur  partir de la base
	 * puis affecte les valeurs passes en paramtres
	 * @param uidUser		uid du user
	 * @param uidProf		valeur du champ uidprof (ajout)
	 * @param nomComplet	valeur du champ nomcomplet
	 * @param sqlUser		Objet SqlUsers regroupant les accs  la table USERS
	 * @throws Exception
	 */
	public Users(
		String uidUser,
		String uidProf,
		String nomComplet)
		throws Exception {
		
			this(uidUser);
			if(this.getProfils()==null)	this.setProfils(new Vector(0));
			this.getProfils().add(new Profils(uidProf));
			setNomComplet(nomComplet);
	}

	public void create() throws Exception{
		log.info("Users::create() : cration de l'utilisateur dans la base");
		SqlUsers.createUsers(this);
		log.info("Users::create() : utilisateur cr dans la base");
	}
	
	public void modif() throws Exception {
		log.info("SqlUsers - modif : uiduser = "+getUidUser());
		log.info("                   nomcomplet = "+getNomComplet());
		SqlUsers.modifUsers(this);
	}
	
	/**
	 * Supprime l'utilisateur de la DB
	 * @throws Exception
	 */
	public void delete() throws Exception {
		try {
			if (isExiste()) {
				for(Enumeration e=this.getProfils().elements();e.hasMoreElements();){
					SqlUsers.deleteProfil(this.uidUser,((Profils)e.nextElement()).getUidProf());
				}
				// supprimer l'utilisateur
				SqlUsers.deleteUsers(this);
			}
		} catch (Exception e) {
			log.error("Users - delete : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la liste des catgories accessibles pour l'utilisateur courant
	 * @return Vector contenant les uidcat des catgories accessibles
	 */
	public Vector getCategoriesAccessibles() throws Exception {
		try {
			return SqlCatsProfils.getCategoriesAttachees(this.profils);
		} catch (Exception e) {
			log.error("Users - getCategoriesAccessibles : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Renvoie la liste des messages appartenant  l'utilisateur
	 * @return Vector contenant les uidnews des messages dont l'utilisateur est "owner"
	 */
	public Vector getMessages() throws Exception {
		try {
			SqlNews sqlNews = new SqlNews();
			return sqlNews.getMessagedOwnedBy(getUidUser());
		} catch (Exception e) {
			log.error("Users - getMessages : " + e.getMessage());
			throw e;
		}
	}
	
	public Vector getProfilsUid() {
		Vector v=new Vector(0);
		for(Enumeration e=this.getProfils().elements();e.hasMoreElements();){
			String uidprof=((Profils)e.nextElement()).getUidProf();
			v.add(uidprof);
		}
		return v;
	}


	public static Vector getAllUsers() throws Exception {
		return SqlUsers.getAllUsersUid();
	}

	public boolean isExiste() {
		return existe;
	}

	public String getNomComplet() {
		return nomComplet;
	}

	public Vector getProfils() {
		return profils;
	}

	public String getUidUser() {
		return uidUser;
	}

	public void setExiste(boolean b) {
		existe = b;
	}

	public void setNomComplet(String string) {
		nomComplet = string;
	}

	public void setProfil(Vector vProfils) {
		profils = vProfils;
	}

	public void addProfil(String profil) throws Exception {
		SqlUsers.addProfil(this,profil);
		/*log.info("Users::addProfil() : ajout du profil "+profil+"  l'utilisateur "+this.getUidUser());
		if(profils==null) {
			log.info("Users::addProfil() : profils est null");
			this.profils=new Vector(0);
			this.profils.add(new Profils(profil)) ;
		} else if(!this.possede(profil)) 
			profils.add(new Profils(profil));
		log.info("Users::addProfil() : fin");*/
	}

	public void removeProfil(String profil) throws Exception {
		SqlUsers.removeProfil(this,profil);
	}

	/**
	 *	Teste si l'utilisateur possde le profil
	 * @param profil
	 * @return
	 */
	public boolean possede(String profil) {
		log.info("Users::possede() : entree");
		if(this.getProfils()!=null&&this.getProfils().size()>0)
			for(Enumeration e=this.getProfils().elements();e.hasMoreElements();)
				if(((Profils)e.nextElement()).getUidProf().equals(profil))	return true;
		log.info("Users::possede() : l'utilisateur ne possde pas le profil");
		return false;
	}

	public void setUidUser(String string) {
		uidUser = string;
	}

	/**
	 * @return
	 */
	public boolean isAdmCats() throws Exception {
		try {
			for(Enumeration e = this.getProfils().elements();e.hasMoreElements();)
				if( ((Profils) e.nextElement()).isAdmCats())	return true;
			return false;
		} catch (Exception e) {
			e.printStackTrace();
			log.error("Users::isAdmCats : "+e+" : "+e.getMessage());
			throw e;
		}
	}
	/**
	 * @return
	 */
	public boolean isAdmNews() throws Exception {
		for(Enumeration e = this.getProfils().elements();e.hasMoreElements();)
			if( ((Profils) e.nextElement()).isAdmNews())	return true;
		return false;
	}
	/**
	 * @return
	 */
	public boolean isAdmProfils() throws Exception {
		for(Enumeration e = this.getProfils().elements();e.hasMoreElements();)
			if( ((Profils) e.nextElement()).isAdmProfils())	return true;
		return false;
	}
	/**
	 * @param vector
	 */
	public void setProfils(Vector vector) {
		profils = vector;
	}

}