package fr.univvalenciennes.publi.WebServices.canaux2;

import java.util.ArrayList;
import java.sql.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
public class Construction{
    private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
    private String user;
    private SqlCanaux sqlcanaux;
    private Arbre arbre = new Arbre();
    private ArrayList canauxRss;
    
    public Construction(String user){
		log.debug("On commence la construction");
	this.user=user;	
	try{
	     sqlcanaux = new SqlCanaux();
	     log.debug("SqlCanaux ok");
	     this.canauxRss = sqlcanaux.getCanauxRss();
	     log.debug("Les canaux Rss sont : "+canauxRss);
	     genereArbre();
	}
	catch(SQLException sqle){
		log.error("La connexion a choue : "+sqle);
	}
	catch(ClassNotFoundException cnfe){
		log.error("La connexion a choue : "+cnfe);
	}
    }

    
    
    public ArrayList getRacines(){
	ArrayList racines = null;
	try{
	    racines = sqlcanaux.getCanauxUtilisateur(user);		       			
	}
	catch(SQLException sqle){
	}
	catch(ClassNotFoundException cnfe){
	}
	return racines;			
    }
    
    private ArrayList getFils(String racine){
		ArrayList fils = null;
		try{
	    fils = sqlcanaux.getFils(racine);
	}
	catch(SQLException sqle){
	}
	catch(ClassNotFoundException cnfe){
	}
	return fils;
    }
    
    public void genereArbre(){
    	ArrayList racines = getRacines();
    	log.debug("Les racines sont : "+racines);
    	for(int i=0; i<racines.size();i++){
    		String racine = (String)racines.get(i);
    		Branche br = genereBranche(racine);
    		log.debug("La branche generee est : "+br);
    		arbre.addBranche(br);
    	}
    }
    
    private boolean isRSS(String racine){
    	if(canauxRss.contains(racine)) return true;
    	return false;
    }
    public Branche genereBranche(String racine){
    	Branche br = new Branche(racine);
		//Branche br = new Branche();
		//br.setRacine(racine);
    	String nomRacine = getNomRacine(racine);
    	boolean isRss = isRSS(racine);
    	br.setNom(nomRacine);
    	br.setIsRss(isRss);
    	ArrayList listeFils = getFils(racine);
    	if(listeFils!=null){
    		for(int i=0;i<listeFils.size();i++){
    			String f = (String)listeFils.get(i);
    			Branche fils = genereBranche(f);
    			br.addFils(fils);
    		}
    	}
    	return br;   	
    }
    
    private String getNomRacine(String racine){
    	try{
			return sqlcanaux.getNom(racine);
    	}
    	catch(java.sql.SQLException sqle){
    	}
		catch(java.lang.ClassNotFoundException cnfe){
		}
    	return null;
    }
    
    public Arbre getArbre(){
		return arbre;
	}
    
    
      
   /* public static void main(String[] argv){
	String user = argv[0];
	//System.out.println("L'utilisateur est : "+user);
	Construction cons = new Construction(user);
	System.out.println(cons.getArbre());
    }
    */
    
}
