package fr.univvalenciennes.publi.WebServices.canaux2;

import java.sql.*;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import fr.univvalenciennes.publi.WebServices.communs.*;
import fr.univvalenciennes.publi.utils.properties.PropertiesManager;

public class SqlCanaux {
	private static Log log =  LogFactory.getLog("axis.canaux2");
  Connection connection;
  Statement statement;
  Database database;
  String nomFichier;

  /**
   *
   *
   *Prepare the database for a query
   *                                        
   */

  public SqlCanaux() throws SQLException, ClassNotFoundException {

    database = Database.getStandard();
    connection = database.getConnection();
    this.nomFichier = database.getNomFichier();
    new PropertiesManager(this.nomFichier);
    log.debug("Connexion a la base ok");
  }


  public ArrayList getCanauxUtilisateur (String utilisateur) throws SQLException , ClassNotFoundException { 
  	ArrayList uiddesccatlist = new ArrayList(); 
 	
	/*String sqlString = "Select c.uiddesccat from catsprofils c, users u where u.uiduser=? and u.uidprof=c.uidprof order by ordre"; 
	PreparedStatement statement = connection.prepareStatement(sqlString);
	statement.setString(1,utilisateur);*/
 	
 	String sqlString = PropertiesManager.getProperty("canaux.CanauxUtilisateur"); 
 		//"Select c.uiddesccat from catsprofils c, users u, user_has_profil up where u.uiduser=? and u.uiduser=up.uiduser and up.uidprof=c.uidprof order by ordre"; 
	PreparedStatement statement = connection.prepareStatement(sqlString);
	statement.setString(1,utilisateur);
	
	log.debug("SQLCanaux : statement = "+statement);
	ResultSet rs = statement.executeQuery();
	while(rs.next()) {
		uiddesccatlist.add(rs.getString("uiddesccat"));
	}
	statement.close();
	log.debug("SqlCanaux :  liste = "+uiddesccatlist+" Pour l'utilisateur : "+utilisateur);
	return uiddesccatlist;
  }
    
    
    public ArrayList getFils(String racine) throws SQLException , ClassNotFoundException{
	ArrayList result = new ArrayList(); 
	String sqlString = PropertiesManager.getProperty("canaux.Fils"); 
		//"select uiddesccat  from orgacategories  where uidcat= ? order by ordre"; 
	PreparedStatement statement = connection.prepareStatement(sqlString);
	statement.setString(1,racine);
	log.debug("SQLCanaux : statement = "+statement);
	ResultSet rs = statement.executeQuery();
	while(rs.next()) {
	    result.add(rs.getString("uiddesccat"));
	}
	statement.close();
	log.debug("SqlCanaux :  liste = "+result);
	return result;
    }
   
    /**
     * 
     * @param uidcat
     * @return caption
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public String getNom(String uidcat) throws SQLException , ClassNotFoundException{
	String sqlString = PropertiesManager.getProperty("canaux.Nom"); 
		//"Select caption from categories where uidcat=?"; 
	PreparedStatement statement = connection.prepareStatement(sqlString);
	statement.setString(1,uidcat);
	ResultSet rs = statement.executeQuery();
	rs.next();
	String tmp = rs.getString("caption");
	statement.close();
	return tmp;
    }
    
    /**
     * 
     * @param uidcat
     * @return summary
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public String getResume(String uidcat) throws SQLException, ClassNotFoundException{
    	String sqlString=PropertiesManager.getProperty("canaux.resume");
    	PreparedStatement statement = connection.prepareStatement(sqlString);
    	statement.setString(1,uidcat);
    	ResultSet rs = statement.executeQuery();
    	rs.next();
    	String tmp = rs.getString("summary");
    	statement.close();
    	return tmp;
    }
    
    /**
     * 
     * @param uidcat
     * @return gifurl
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public String getGifUrl(String uidcat) throws SQLException, ClassNotFoundException{
    	String sqlString=PropertiesManager.getProperty("canaux.gifurl");
    	PreparedStatement statement = connection.prepareStatement(sqlString);
    	statement.setString(1,uidcat);
    	ResultSet rs = statement.executeQuery();
    	rs.next();
    	String tmp = rs.getString("gifurl");
    	statement.close();
    	return tmp;
    }
    
    
     /**
   * Retourne la liste des canaux RSS
   * @return liste de codecanal
   * @throws SQLException
   * @throws ClassNotFoundException
   */
  
  public ArrayList getCanauxRss() throws SQLException , ClassNotFoundException{
	ArrayList list = new ArrayList();
	String sqlString = PropertiesManager.getProperty("canaux.CanauxRss");
		//"Select codecanal from canauxrss"; 
	PreparedStatement statement = connection.prepareStatement(sqlString);
	ResultSet rs = statement.executeQuery();
	while(rs.next()) {
			list.add(rs.getString("codecanal"));
	}
	statement.close();
	return list;
  }

}
