/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr,
 * 			 Nathalie.Vauquier@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package fr.univvalenciennes.publi.WebServices.communs;
/**
 * Description :<br/>
 * 
 * @version $Id : Database.java, V1.0, 31 mars 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : Database<br/>
 */
import java.sql.*;

import fr.univvalenciennes.publi.utils.properties.*;

public class Database {
	
 
	private String driver;
	private String userId;
	private String password;
	private String url;
	private String nomFichier;
	private Connection connection=null;


	public Database() {
	}

	public Database(String driver , String userId , String password , String url, String NomFichier) throws SQLException, ClassNotFoundException {
		this.driver = driver;
		this.userId = userId;
		this.password = password;
		this.url = url;
		this.nomFichier = NomFichier;
	}
	
	/**
	 * Get connection to the database
	 * @return	connection
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public Connection createConnection () throws SQLException, ClassNotFoundException {
		Class.forName(driver);
		return DriverManager.getConnection(url,userId,password);
	}

	
	/**
	 * get the parameter of connection
	 * @return
	 */
	public static Database getStandard() throws SQLException, ClassNotFoundException {
		new PropertiesManager("applinews.properties");
		String DRIVER = PropertiesManager.getProperty("jdbcDriver");
		String USERID = PropertiesManager.getProperty("jdbcUser");
		String PASSWORD = PropertiesManager.getProperty("jdbcPassword");
		String URL = PropertiesManager.getProperty("jdbcUrl");
		String NOMFICHIER = PropertiesManager.getProperty("sgbdTypeConf");
		return new Database(DRIVER , USERID , PASSWORD , URL,NOMFICHIER);

	}
	
	public void close() throws SQLException{
		if ((connection!=null)&&(!connection.isClosed()))	connection.close();
	}
	/**
	 * @return	connection
	 */
	public Connection getConnection() throws SQLException, ClassNotFoundException {
		if ((connection==null)||(connection.isClosed())){
			connection=createConnection(); 
		}
			
		return connection;

	}

	/**
	 * @param connection
	 */
	public void setConnection(Connection connection) {
		this.connection = connection;
	}


	/**
	 * @return Returns the nomFichier.
	 */
	public String getNomFichier() {
		return nomFichier;
	}
}
