package fr.univvalenciennes.publi.WebServices.news;

import java.sql.*;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import fr.univvalenciennes.publi.WebServices.communs.*;
import fr.univvalenciennes.publi.utils.properties.PropertiesManager;

public class SqlNews {
	private static Log log =  LogFactory.getLog("axis.news");
	Connection connection;
	Statement statement;
	Database database;
	String nomFichier;
	
	/**
	 *
	 *
	 *Prepare the database for a query
	 *                                        
	 */

	 public SqlNews() throws SQLException, ClassNotFoundException {

		 database = Database.getStandard();
		 connection = database.getConnection();
		 this.nomFichier = database.getNomFichier();
	     new PropertiesManager(this.nomFichier);	     
	 }

	 public SqlNews(String driver , String userid , String password , String url, String nomFichier) throws SQLException, ClassNotFoundException {
	 
		 database = new Database(driver , userid , password , url,nomFichier);
		 connection = database.getConnection();
	 }

	 public void DeleteNews(String uidnews) throws SQLException , ClassNotFoundException {



	 	String sqlString = PropertiesManager.getProperty("news.DeleteNewsdispatchnews");
	 		//"DELETE FROM newdispatchnews WHERE uidnews = ?" ;
	 	PreparedStatement statement = connection.prepareStatement(sqlString);
	 	statement.setString(1,uidnews);
	 	statement.executeUpdate();

 	 	sqlString = PropertiesManager.getProperty("news.DeleteNews");
 	 	//"DELETE FROM News WHERE uidnews = ?" ;
	 	statement = connection.prepareStatement(sqlString);
	 	statement.setString(1,uidnews);
	 	statement.executeUpdate();


		 statement.close();

	 }
	 public News getNews(String uidnews) throws SQLException , ClassNotFoundException {

		 //String answer1 , answer6 , answer7 , answer8 , answer10; // answer9 ,
	 	String caption, htmlname,summary,url,owner;
		 //Date answer2b , answer3b , answer4b, datedebb;
	 	Date datecreated, datelastmodified,dateendvalidity,datedebvalidity;
		 //int answer5;
	 	int defaultpriority;
     int year, month, day;
     String[] champ_date;

     	PreparedStatement statement;

		 String sqlString = PropertiesManager.getProperty("news.News");
		 //"SELECT caption FROM News WHERE uidnews = '"+ uidnews + "'" ;
		 statement= connection.prepareStatement(sqlString);
		 statement.setString(1,uidnews);
		 
		 ResultSet rs = statement.executeQuery();
		 rs.next();
		 //caption
		 caption = rs.getString("caption");
		 //datecreated
		 datecreated=rs.getDate("datecreated");
	     champ_date = datecreated.toString().split("-");
	     year = Integer.parseInt(champ_date[0]);
	     month = Integer.parseInt(champ_date[1])-1;
	     day = Integer.parseInt(champ_date[2]);
	     java.util.Calendar datecreatedCalendar = new java.util.GregorianCalendar();
	     datecreatedCalendar.set(year, month, day);
		 //datelastmodified
	     datelastmodified=rs.getDate("datelastmodified");
	     champ_date = datelastmodified.toString().split("-");
	     year = Integer.parseInt(champ_date[0]);
	     month = Integer.parseInt(champ_date[1])-1;
	     day = Integer.parseInt(champ_date[2]);
	     java.util.Calendar datelastmodifiedCalendar = new java.util.GregorianCalendar();
	     datelastmodifiedCalendar.set(year, month, day);
	     //dateendvalidity
	     java.util.Calendar dateendvalidityCalendar = new java.util.GregorianCalendar();
	     dateendvalidity=rs.getDate("dateendvalidity");
		 if(dateendvalidity!=null) {
		 	champ_date = dateendvalidity.toString().split("-");
		 	year = Integer.parseInt(champ_date[0]);
		 	month = Integer.parseInt(champ_date[1])-1;
		 	day = Integer.parseInt(champ_date[2]);
		 	dateendvalidityCalendar.set(year, month, day);
		 }
		 log.debug("SQLNEWS : date de fin : Mois recupere : "+(month+1));
		 //datedebvalidity
		 java.util.Calendar datedebvalidityCalendar = new java.util.GregorianCalendar();
		 datedebvalidity=rs.getDate("datedebvalidity");
		 if(datedebvalidity!=null) {
		 	champ_date = datedebvalidity.toString().split("-");
		 	year = Integer.parseInt(champ_date[0]);
			 month = Integer.parseInt(champ_date[1])-1;
			 day = Integer.parseInt(champ_date[2]);
			 datedebvalidityCalendar.set(year, month, day);
		 }
		log.debug("SQLNEWS : date de debut de validite = "+datedebvalidityCalendar);
		//defaultpriority
		defaultpriority=rs.getInt("defaultpriority");
		//htmlname
		htmlname=rs.getString("htmlname");
		//summary		
		summary=rs.getString("summary");
		//url
		url=rs.getString("url");
		//owner
		owner=rs.getString("owner");
		 log.info("owner= "+owner);
		statement.close();

		return new News(uidnews , caption, datecreatedCalendar, datelastmodifiedCalendar, dateendvalidityCalendar,datedebvalidityCalendar, defaultpriority, htmlname, summary, url, owner);

	 }

	 public void putNews(News n, String uidcat) throws SQLException , ClassNotFoundException {
	 
		
     String sqlString, maxUidNews;
     
  try{
  // Ici on d?termine l'uid de la news
     Calendar cal = GregorianCalendar.getInstance();
     cal.setTime( new java.util.Date() );
     // Obtenir un UIdNews.
     String Days    = ""+ cal.get( Calendar.DAY_OF_MONTH ); 
     if(Days.length()<2) Days="0"+Days;
     String Month   = ""+(cal.get( Calendar.MONTH));
     if(Month.length()<2) Month="0"+Month;
     String Year    = ""+cal.get( Calendar.YEAR ) ; if (
         Year.length()>2 ) Year = Year.substring(2);  
     String Hours   = ""+cal.get( Calendar.HOUR ) ;
     if(Hours.length()<2) Hours="0"+Hours;
     String Minutes = ""+cal.get( Calendar.MINUTE ) ;
     if(Minutes.length()<2) Minutes="0"+Minutes;
     String Seconds = ""+cal.get( Calendar.SECOND );
     if(Seconds.length()<2) Seconds="0"+Seconds;   
     String Key = new String("");
     long KeyCalculation = 0;
     for(int i=0;i<n.getOwner().length();i++)
       KeyCalculation += n.getOwner().charAt(i);
     Key += KeyCalculation;
     if(Key.length()==2) Key = "0"+Key;
     Key = Key.substring(Key.length()-3);
     String mUIdNews = Year+Month+Days+Hours+Minutes+Seconds+Key;

	

     GregorianCalendar greg = new GregorianCalendar();
     greg.setTime(new java.util.Date());
     n.setDateCreated(greg);
     n.setDateLastModified(greg);
     
     if(n.getDateBeginValidity()==null){
 		n.setDateBeginValidity(greg);
     }


     String replace = "''";
     String caption = n.getCaption().replaceAll("'",replace);
     String Summary = n.getSummary().replaceAll("'",replace);
	
	if(n.getDateEndValidity()==null){
		n.setDateEndValidity(new GregorianCalendar(2100,01,01));
	}


		 sqlString =PropertiesManager.getProperty("news.putNews");
		 String DateCreated = Date2String(n.getDateCreated());
		 String DateLastModified = Date2String(n.getDateLastModified());
		 String DateEndValidity = Date2String(n.getDateEndValidity());
		 String DateBeginValidity = Date2String(n.getDateBeginValidity());
		 	
	PreparedStatement statement = connection.prepareStatement(sqlString);
	statement.setString(1,mUIdNews);
	statement.setString(2,caption);
	statement.setString(3,DateCreated);
	statement.setString(4,DateLastModified);
	statement.setString(5,DateEndValidity);
	statement.setString(6,DateBeginValidity);
	statement.setInt(7,n.getDefaultPriority());
	statement.setString(8,n.getHtmlName());
	statement.setString(9,Summary);
	statement.setString(10,n.getUrl());
	statement.setString(11,n.getOwner());

	
	log.debug("Requete : "+sqlString);
		statement.executeUpdate();

		
		 sqlString =PropertiesManager.getProperty("news.putNews.canal");
		 statement = connection.prepareStatement(sqlString);
			statement.setString(1,uidcat);
			statement.setString(2,mUIdNews);
			statement.setInt(3,n.getDefaultPriority());

			statement.executeUpdate();

     statement.close();
  }
	catch(SQLException e){
		 log.error("erreur SQL : "+e);
	}
	 }

	 public void modifyNews(News n) throws SQLException , ClassNotFoundException {

     String uidcat = "";
     
	 
     PreparedStatement statement;
     
     //On r?cup?re le nom du canal dans lequel est la news
		 String sqlString = PropertiesManager.getProperty("news.modifyNews.NomCanal");
		 statement = connection.prepareStatement(sqlString);
		 statement.setString(1,n.getUidNews());
		 ResultSet rs = statement.executeQuery();
		 rs.next();
		 uidcat=rs.getString(1);

     //On r?cup?re la date de cr?ation
		 sqlString = PropertiesManager.getProperty("news.modifyNews.DateCreation");
		 statement = connection.prepareStatement(sqlString);
		 statement.setString(1,n.getUidNews());
		 rs = statement.executeQuery();
    rs.next();
     java.util.Date answer2b=rs.getDate(1);
     String[] champ_date = answer2b.toString().split("-");
     int year = Integer.parseInt(champ_date[0]);
     int month = Integer.parseInt(champ_date[1])-1;
    int day = Integer.parseInt(champ_date[2]);
     java.util.Calendar dateCreated = new java.util.GregorianCalendar();
     dateCreated.set(year, month, day);
     n.setDateCreated(dateCreated);
     
     GregorianCalendar greg = new GregorianCalendar();
     greg.setTime(new java.util.Date());
     n.setDateLastModified(greg);

     this.DeleteNews(n.getUidNews());
    
    String replace ="''";
 	String caption = n.getCaption().replaceAll("'",replace);
    String Summary = n.getSummary().replaceAll("'",replace);
   
	 if(n.getDateBeginValidity()==null){
			n.setDateBeginValidity(greg);
		 }
	
		if(n.getDateEndValidity()==null){
			n.setDateEndValidity(new GregorianCalendar(2100,01,01));
		}

     //on insre la news avec les modifications
		 sqlString =PropertiesManager.getProperty("news.putNews");
		 
		 String DateCreated = Date2String(n.getDateCreated());
		 String DateLastModified = Date2String(n.getDateLastModified());
		 String DateEndValidity = Date2String(n.getDateEndValidity());
		 String DateBeginValidity = Date2String(n.getDateBeginValidity());
		 	
		 log.debug("sqlNews: ModifyNews: getOwner = "+n.getOwner());
		 
		 statement = connection.prepareStatement(sqlString);
		 statement.setString(1,n.getUidNews());
		 statement.setString(2,caption);
		 statement.setString(3,DateCreated);
		 statement.setString(4,DateLastModified);
		 statement.setString(5,DateEndValidity);
		 statement.setString(6,DateBeginValidity);
		 statement.setInt(7,n.getDefaultPriority());
		 statement.setString(8,n.getHtmlName());
		 statement.setString(9,Summary);
		 statement.setString(10,n.getUrl());
		 statement.setString(11,n.getOwner());

	
		 log.debug("Requete : "+sqlString);
		statement.executeUpdate();

     //on remet la news dans le bon canal
		 sqlString =PropertiesManager.getProperty("news.modifyNews.canal");
		 statement = connection.prepareStatement(sqlString);
		 statement.setString(1,uidcat);
		 statement.setString(2,n.getUidNews());
		 statement.setInt(3,n.getDefaultPriority());
		 statement.executeUpdate();

		 
     statement.close();
	 
	 }

   /**
    * Permet de convertir un calendar en un format compr?hensible pour les query SQL
    **/

    public String Date2String(Calendar cal) {	  
		     String annee =  String.valueOf(cal.get(Calendar.YEAR));
		     String mois = String.valueOf((cal.get(Calendar.MONTH))+1);
		     log.debug("SQLNEWS : Mois = "+mois);
		     if(mois.length()==1) mois = "0"+mois;
		     String jour = String.valueOf(cal.get(Calendar.DATE));
			 if(jour.length()==1) jour = "0"+jour;
		    return annee+ "-" + mois + "-" +jour ; 	   
   }

} 
	
