package fr.univvalenciennes.publi.WebServices.newslist;

import java.sql.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import fr.univvalenciennes.publi.WebServices.communs.*;
import fr.univvalenciennes.publi.utils.properties.PropertiesManager;


public class SqlNewsList {
	private static Log log =  LogFactory.getLog("axis.newslist");
  Connection connection;
  Statement statement;
  Database database;
	String nomFichier;

  /**
   *
   *
   *Prepare the database for a query
   *                                        
   */

  public SqlNewsList() throws SQLException, ClassNotFoundException {

    database = Database.getStandard();
    connection = database.getConnection();
	 this.nomFichier = database.getNomFichier();
     new PropertiesManager(this.nomFichier);	     
  }

  public ArrayList getListNews(String uidCat) throws SQLException , ClassNotFoundException {

    String sqlString, uidNews, caption, uidCatCurrent, uidnews;
    int priority;
    NewsSummary news = new NewsSummary();
    ArrayList list = new ArrayList();
    java.sql.Date date = new java.sql.Date(0);
    java.util.Calendar calendar = new GregorianCalendar();
    String[] champ_date;
    int year, month, day;

      log.debug("UidDescCat :"+uidCat+":\n");


      PreparedStatement statement = null;

    //si aucun canal n'est prcis, on envoie la liste de tous les news
    if(uidCat.length()==0) {

      sqlString = PropertiesManager.getProperty("newslist.ListNews.zero");
      	//"SELECT A.uidnews,A.caption,A.datecreated,A.defaultpriority,B.uidcat FROM news A,newdispatchnews B WHERE A.uidnews=B.uidnews order by DATECREATED" ;
       statement = connection.prepareStatement(sqlString);
   } else {
      sqlString =  PropertiesManager.getProperty("newslist.ListNews.plusieurs");
      //"SELECT A.uidnews,A.caption,A.datecreated,A.defaultpriority,B.uidcat FROM news A,newdispatchnews B WHERE A.uidnews=B.uidnews AND B.uidcat=? order by datecreated" ;
       statement = connection.prepareStatement(sqlString);
     statement.setString(1,uidCat);
    }

    ResultSet rs = statement.executeQuery();
    while(rs.next()) {

      news = new NewsSummary();
      uidCatCurrent = rs.getString("uidcat");
      news.setUidCat(uidCatCurrent);

      caption = rs.getString("caption");
      news.setCaption(caption);

      uidnews = rs.getString("uidnews");
      news.setUidNews(uidnews);

      priority = rs.getInt("defaultpriority");
      news.setDefaultPriority(priority);

      date = rs.getDate("datecreated");
      champ_date = date.toString().split("-");
      year = Integer.parseInt(champ_date[0]);
      month = Integer.parseInt(champ_date[1]);
      day = Integer.parseInt(champ_date[2]);
      log.info("au moment de la requete sql, voici la date : " + day );
      log.info("au moment de la requete sql, voici le mois : " + month );
      log.info("au moment de la requete sql, voici le mois : " + year );
      calendar = new GregorianCalendar();
      calendar.set(year, month, day);
      log.info("le jour est enregistre dans le calendar ainsi : " + calendar.get(Calendar.DAY_OF_MONTH) );
      log.info("le mois est enregistre dans le calendar ainsi : " + calendar.get(Calendar.MONTH) );
      log.info("l'annee est enregistree dans le calendar ainsi : " + calendar.get(Calendar.YEAR) );
      news.setDateCreated(calendar);
      list.add(news);
    }

    statement.close();
	
    return list;

  }
}
