package fr.univvalenciennes.publi.utils.db;

import java.sql.*;

/**
 * @author Nathalie Vauquier
 *
 * Encapsule les donnes concernant une connection en cache
 */
public class CachedConnection {
	private boolean inUse;		// si la connection est ou non utilise
	private Connection conn;	// la connection
	private long lastUsed;		// dernire utilisation de la connection
	private String baseName;	// nom du pool auquel appartient la connection
	
	public CachedConnection() {
		conn = null;
		inUse = false;
		lastUsed = System.currentTimeMillis();
		baseName = "default";
	}
	
	public CachedConnection(Connection conn, boolean inUse) {
		this.conn = conn;
		this.inUse = inUse;
		lastUsed = System.currentTimeMillis();
		baseName = "default";
	}
	
	public CachedConnection(Connection conn, boolean inUse,String baseName) {
		this.conn = conn;
		this.inUse = inUse;
		lastUsed = System.currentTimeMillis();
		this.baseName = baseName;
	}

	
	/**
	 * @return
	 */
	public String getBaseName() {
		return baseName;
	}

	/**
	 * @return
	 */
	public Connection getConn() {
		return conn;
	}

	/**
	 * @return
	 */
	public boolean isInUse() {
		return inUse;
	}

	/**
	 * @return
	 */
	public long getLastUsed() {
		return lastUsed;
	}

	/**
	 * @param string
	 */
	public void setBaseName(String string) {
		baseName = string;
	}

	/**
	 * @param connection
	 */
	public void setConn(Connection connection) {
		conn = connection;
	}

	/**
	 * @param b
	 */
	public void setInUse(boolean b) {
		if(!inUse)
			lastUsed = System.currentTimeMillis();
		inUse = b;
	}

	/**
	 * @param l
	 */
	public void setLastUsed(long l) {
		lastUsed = l;
	}

}