package fr.univvalenciennes.publi.utils.db;

import java.sql.*;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * @author Nathalie Vauquier
 *
 * Cette classe s'occupe de crer les connexions
 */
public class CachedConnectionCreator {
	private static Log log =  LogFactory.getLog("CachedConnectionCreator");
	/**
	 * Obtient une connexion  partir de la base
	 * dont les paramtres sont dans un fichier pass en paramtre
	 * @param baseName
	 * @return
	 */
	public static final Connection getConnection(String baseName, boolean verbose){
		Connection conn = null;
		String driver = null;
		String url = null;
		String username = null;
		String password = null;
		try {
			new PropertiesManager(baseName + ".properties");
			driver = PropertiesManager.getProperty("jdbcDriver");
			log.info("Driver = "+driver);
			url = PropertiesManager.getProperty("jdbcUrl");
			username = PropertiesManager.getProperty("jdbcUser");
			password = PropertiesManager.getProperty("jdbcPassword");

			if (verbose) {
				log.info("Driver : " + driver);
				log.info("Url : " + url);
				log.info("Username : " + username);
			}
			Class.forName(driver);
		} catch (Exception e) {
			if(verbose) {
				log.error("Impossible de charger le driver");
			}
			return conn;
		}
		try {
			conn = DriverManager.getConnection(url, username, password);
		} catch (Exception e) {
			conn = null;
		} finally {
			return conn;
		}
	}
	
	public static final Connection getConnection(String directory,String baseName){
		return getConnection(baseName, false);
	}

}