package fr.univvalenciennes.publi.utils.db;

import java.util.Calendar;

/**
 * @author Nathalie Vauquier
 *
 * Classe fournissant les mthodes de formatage 
 * des dates pour insertion dans les BD selon le 
 * SGBD (Oracle ou mySql)
 */
public class DateDb{
	public DateDb(){
	}
	
	/**
	 * Transforme une date sous forme de 
	 * string sous le format spcifi en 
	 * une java.sql.Date
	 * @param strDate
	 * @param format
	 * @return
	 */
	public static java.sql.Date strToDate(String strDate, String format){
		if(format.equals("ddmmyyyy")){
			String d=strDate.substring(4)+strDate.substring(2,4)+strDate.substring(0,2);
			Calendar c = Calendar.getInstance();
			c.set( 	Integer.parseInt(strDate.substring(4)),
					Integer.parseInt(strDate.substring(2,4))-1,
					Integer.parseInt(strDate.substring(0,2)) );
			return new java.sql.Date(c.getTimeInMillis());
		}
		return null;
	}

	/**
	 * Renvoie la string permettant de remplir un champ de
	 * type DATE avec la date courante dans une requte SQL 
	 * @return
	 */
	public static String getDateCourante(String sgbd){
		if(sgbd.equals("mySql")){
			return "now()"; }
		if(sgbd.equals("oracle"))	return "sysdate";
		return "";
	}
	
}