package fr.univvalenciennes.publi.utils.db;

import java.sql.*;

import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Nathalie Vauquier
 *
 * Classe permettant de crer une connexion associe  une session
 */
public class SessionConnection implements HttpSessionBindingListener {
	private Connection conn;	// la connexion  la BD
	private Log log =  LogFactory.getLog(this.getClass().getPackage().getName());

	private String dbDriver, dbUrl, dbLogin, dbPassword;	// attributs de la connexion

	boolean debug=true;

	public SessionConnection(){
	}
	
	/**
	 * Cration de la connexion
	 * @throws SQLException
	 */
	private void createConn() throws SQLException {
		try {
			if(debug)	log.debug("SessionConnection : cration d'une connection");
			Class.forName(dbDriver);
		} catch (ClassNotFoundException e) {
			// TODO
		}
		
		try {
			conn =
				DriverManager.getConnection(dbUrl, dbLogin, dbPassword);
			if(debug)	log.debug("SessionConnection : connection cre : " + conn);
		} catch (Exception e) {
			// TODO
		}

	}
	
	public void init() throws SQLException {
		if (this.conn == null) {
			this.createConn();
		}
	}

	public void close(){
		try {
			this.conn.close();
		} catch (SQLException e) {
			// TODO
		}
	}
	public void valueBound(HttpSessionBindingEvent event) {
	}

	public void valueUnbound(HttpSessionBindingEvent event) {
		// cette mthode est appele lors de la fermeture de la session
		try {
			if((conn!=null)&&(!conn.isClosed())) {
				conn.close();
			}
		} catch (SQLException e) {
			// TODO
		}
	}

	/**
	 * Driver JDBC de la BD
	 * @param string
	 */
	public void setDbDriver(String string) {
		dbDriver = string;
	}

	/**
	 * Login de la BD
	 * @param string
	 */
	public void setDbLogin(String string) {
		dbLogin = string;
	}

	/**
	 * Password de la BD
	 * @param string
	 */
	public void setDbPassword(String string) {
		dbPassword = string;
	}

	/**
	 * URL de la BD
	 * @param string
	 */
	public void setDbUrl(String string) {
		dbUrl = string;
	}

	public Connection getConnection() {
		return conn;
	}

	public void setConnection(Connection connection) {
		conn = connection;
	}
}
