
package fr.univvalenciennes.publi.utils.properties;

import java.util.Properties;
import java.io.*;
/**
 * Description :<br/>
 * Cette classe permet de rcuprer les  proprits contenues dans le fichier
 * pass au constructeur.<br/>
 * Ce fichier doit se trouver dans le rpertoire properties/nomFichierProps
 * @version $Id : PropertiesManager.java, V1.0, 20 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : PropertiesManager<br/>
 * @author Doriane Dusart<br/>
 * 
 */
public class PropertiesManager {

  private static String PROPERTIES_FILE_NAME = "";
  private static Properties props ;
  
	/**
	 * Constructeur qui permet de donner le nom du fichier de configuration  utiliser
	 * Ce fichier doit se trouver dans le rpertoire  properties.
	 */

 	public PropertiesManager(String filename){
 		this.PROPERTIES_FILE_NAME = "/properties/"+filename;
 		this.props = new Properties();
 		loadProps();
 	}


  /**
   * Cette mthode permet de charger le fichier de configuration
   */
	protected static void loadProps () {
	    try {
	     props.load(PropertiesManager.class.getResourceAsStream(PROPERTIES_FILE_NAME));
	    } 
	    catch (IOException ioe) {
	      System.err.println( "Impossible de lire le fichier : "+ PROPERTIES_FILE_NAME+" : " +ioe);
	    }
	}


  /**
   * Cette mthode permet de rcuprer la proprite associe
   * au nom pass en argument  
   */
	public static String getProperty(String name) {
	    String val = props.getProperty(name);
	    if (val == null)
	      throw new RuntimeException("Proprit " + name + " non trouve! dans le fichier "+PROPERTIES_FILE_NAME);
	    return val;
	}

}