/* Sert pour utiliser les classes g?n?r?es pas axis ? partir du WSDL */
package fr.univvalenciennes.publi.wsclient.Clients;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.Newslist.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientNewsList {
	private Log log =  LogFactory.getLog(this.getClass().getPackage().getName());

  public ClientNewsList() {
  }

  public List getListNews(String order) {
  	new PropertiesManager("applinews.properties");

    List list = Collections.synchronizedList(new ArrayList());

    NewsListServiceServiceLocator serviceLocator = new NewsListServiceServiceLocator();

    String result = "";

    try {
      NewsListService  service = serviceLocator.getNewsList(new URL(PropertiesManager.getProperty("serviceUrl")+"/NewsList"));
      log.debug("** ClientNewsList - service ok : "+PropertiesManager.getProperty("serviceUrl"));
      result = service.orderNewsList(order);
      log.debug("** ClientNewsList - result ok : "+result);
    } catch(javax.xml.rpc.ServiceException e) {
      log.error("** ClientNewsList - Error1 : " + e);
    } catch(java.rmi.RemoteException e) {
    	 log.error("** ClientNewsList - Error2 : " + e);
    }
    catch(java.net.MalformedURLException e) {
    	 log.error("** ClientNewsList - Error3 : " + e);
    }
    String[] splitResult = result.split("%%");
    for(int i = 0; i< (splitResult.length/5);i++) {
      NewsSummary news = new NewsSummary();
      news.setUidNews(splitResult[i*5]);
      Calendar cal = new GregorianCalendar();
      String[] splitDate = splitResult[i*5+1].split("/");

      cal.set(Integer.parseInt(splitDate[0]), Integer.parseInt(splitDate[1]),Integer.parseInt(splitDate[2]));
      news.setDateCreated(cal);
      news.setCaption(splitResult[i*5+2]);
      news.setDefaultPriority(Integer.parseInt(splitResult[i*5+3]));
      news.setUidCat(splitResult[i*5+4]);
      list.add(news);
    }
    return list;
  }
}
