<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:template name="genEtudiant">
      <xsl:param name="dossier" />

      <xsl:param name="NNE" />

      <xsl:param name="nom" />

      <xsl:param name="prenom" />

      <xsl:param name="email" />

      <xsl:param name="servantMailTo" />

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Dossier</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="$dossier" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">NNE</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="$NNE" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Nom</TD>

            <TD WIDTH="77%">
               <table border="0" cellspacing="0" cellpadding="0">
                  <tr>
                     <td class="uportal-channel-strong">
                        <xsl:value-of select="$nom" />
                     </td>

                     <td width="5">
                     </td>

                     <td class="uportal-channel-strong">
                        <xsl:value-of select="$prenom" />
                     </td>
                  </tr>
               </table>
            </TD>
         </TR>

         <xsl:if test="$email!=''">
            <TR>
               <TD WIDTH="23%" class="uportal-text">Email</TD>

               <TD WIDTH="77%" class="uportal-channel-strong">
                  <xsl:choose>
                     <xsl:when test="$servantMailTo='1'">
                        <a href="{$baseActionURL}?action=sendMail">
                           <xsl:value-of select="$email" />
                        </a>
                     </xsl:when>

                     <xsl:otherwise>
                        <a href="mailto:{$email}">
                           <xsl:value-of select="$email" />
                        </a>
                     </xsl:otherwise>
                  </xsl:choose>
               </TD>
            </TR>
         </xsl:if>
      </TABLE>
   </xsl:template>
</xsl:stylesheet>

