/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    static final String oracle_string = "oracle";
    static final String user_string = "user";
    static final String password_string = "password";
    static final String database_string = "database";
    static final String server_string = "server";
    static final String access_string = "access";
    public static final String protocol_string = "protocol";
    public static final String dll_string = "dll";
    public static final String logon_as_internal_str = "internal_logon";
    static final String prefetch_string = "prefetch";
    static final String row_prefetch_string = "rowPrefetch";
    static final String default_row_prefetch_string = "defaultRowPrefetch";
    static final String batch_string = "batch";
    static final String execute_batch_string = "executeBatch";
    static final String default_execute_batch_string = "defaultExecuteBatch";
    static final String remarks_string = "remarks";
    static final String report_remarks_string = "remarksReporting";
    private static final String synonyms_string = "synonyms";
    private static final String include_synonyms_string = "includeSynonyms";
    private static final String restrict_getTables_string = "restrictGetTables";
    private static final int ACCEPTS_URL_GEN_ERROR = 1;
    private static final int ACCEPTS_URL_ORACLE_ERROR = 2;
    private static final int ACCEPTS_URL_SUCCESS = 3;
    private static final String DRIVER_ULTRA = "ultra";
    private static Properties m_driverAccess = new Properties();
    protected static Connection m_defaultConn;
    private static OracleDriver m_defaultDriver;

    static {
        ((Hashtable)m_driverAccess).put("thin", "oracle.jdbc.ttc7.TTC7Protocol");
        ((Hashtable)m_driverAccess).put("oci8", "oracle.jdbc.oci8.OCIDBAccess");
        ((Hashtable)m_driverAccess).put("kprb", "oracle.jdbc.kprb.KprbDBAccess");
        m_defaultConn = null;
        m_defaultDriver = null;
        try {
            if (m_defaultDriver == null) {
                m_defaultDriver = new OracleDriver();
                DriverManager.registerDriver(m_defaultDriver);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {}
    }

    public boolean acceptsURL(String string) {
        int n = this.oracleAcceptsURL(string);
        return n == 3;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        String string4;
        String string5;
        int n;
        if (OracleLog.TRACE) {
            OracleLog.print(1, 8, 16, "OracleDriver.connect(url=" + string + ", info)");
        }
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string6 = "jdbc:oracle:kprb";
            int n2 = string.length();
            string = n2 > 23 ? string6.concat(string.substring(23, string.length())) : string6.concat(":");
            string6 = null;
        }
        if ((n = this.oracleAcceptsURL(string)) == 1) {
            return null;
        }
        if (n == 2) {
            DBError.throwSqlException(67);
            return null;
        }
        Hashtable hashtable = this.parseUrl(string);
        String string7 = properties.getProperty(user_string);
        String string8 = properties.getProperty(password_string);
        String string9 = properties.getProperty(database_string);
        if (string9 == null) {
            string9 = properties.getProperty(server_string);
        }
        if (string7 == null) {
            string7 = (String)hashtable.get(user_string);
        }
        if (string8 == null) {
            string8 = (String)hashtable.get(password_string);
        }
        if (string9 == null) {
            string9 = (String)hashtable.get(database_string);
        }
        String string10 = (String)hashtable.get(protocol_string);
        ((Hashtable)properties).put(protocol_string, string10);
        if (string10 == null) {
            DBError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        String string11 = properties.getProperty(dll_string);
        if (string11 == null) {
            ((Hashtable)properties).put(dll_string, "ocijdbc8");
        }
        if ((string5 = properties.getProperty(prefetch_string)) == null) {
            string5 = properties.getProperty(row_prefetch_string);
        }
        if (string5 == null) {
            string5 = properties.getProperty(default_row_prefetch_string);
        }
        if (string5 != null && Integer.parseInt(string5) <= 0) {
            string5 = null;
        }
        if ((string4 = properties.getProperty(batch_string)) == null) {
            string4 = properties.getProperty(execute_batch_string);
        }
        if (string4 == null) {
            string4 = properties.getProperty(default_execute_batch_string);
        }
        if (string4 != null && Integer.parseInt(string4) <= 0) {
            string4 = null;
        }
        if ((string3 = properties.getProperty(remarks_string)) == null) {
            string3 = properties.getProperty(report_remarks_string);
        }
        if ((string2 = properties.getProperty(synonyms_string)) == null) {
            string2 = properties.getProperty(include_synonyms_string);
        }
        String string12 = properties.getProperty(restrict_getTables_string);
        if (OracleLog.TRACE) {
            OracleLog.print(1, 8, 32, "user=" + string7 + ", password=" + string8 + ", database=" + string9 + ", protocol=" + string10 + ", dll_str=" + string11 + ", prefetch=" + string5 + ", batch=" + string4 + ", remarks=" + string3 + ", synonyms=" + string2);
        }
        Connection connection = this.getConnectionInstance(string10, string, string7, string8, string9, properties);
        if (string5 != null) {
            ((OracleConnection)connection).setDefaultRowPrefetch(Integer.parseInt(string5));
        }
        if (string4 != null) {
            ((OracleConnection)connection).setDefaultExecuteBatch(Integer.parseInt(string4));
        }
        if (string3 != null) {
            ((OracleConnection)connection).setRemarksReporting(string3.equalsIgnoreCase("true"));
        }
        if (string2 != null) {
            ((OracleConnection)connection).setIncludeSynonyms(string2.equalsIgnoreCase("true"));
        }
        if (string12 != null) {
            ((OracleConnection)connection).setRestrictGetTables(string12.equalsIgnoreCase("true"));
        }
        hashtable = null;
        return connection;
    }

    public Connection defaultConnection() throws SQLException {
        if (m_defaultConn == null || m_defaultConn.isClosed()) {
            m_defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return m_defaultConn;
    }

    public static String getCompileTime() {
        String string = "Tue_Mar_20_12:24:54_PST_2001-stint098-jpgint";
        return string;
    }

    private Connection getConnectionInstance(String string, String string2, String string3, String string4, String string5, Properties properties) throws SQLException {
        Connection connection = null;
        if (string.compareTo(DRIVER_ULTRA) == 0) {
            try {
                Class<?>[] classArray = null;
                Object[] objectArray = new Object[]{string, string2, string3, string4, string5, properties};
                Class<?> clazz = Class.forName("oracle.jdbc.jolt.jdbc.client.Driver");
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    if (methodArray[n].getName().equals("getConnection")) {
                        classArray = methodArray[n].getParameterTypes();
                        break;
                    }
                    ++n;
                }
                Method method = clazz.getMethod("getConnection", classArray);
                connection = (Connection)method.invoke(clazz.newInstance(), objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DBError.throwSqlException(1);
            }
        } else {
            String string6 = (String)((Hashtable)m_driverAccess).get(string);
            if (string6 == null) {
                DBError.throwSqlException(67, "Invalid protocol " + string);
            }
            DBAccess dBAccess = null;
            try {
                dBAccess = (DBAccess)Class.forName(string6).newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            connection = new OracleConnection(dBAccess, string2, string3, string4, string5, properties);
        }
        return connection;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private int oracleAcceptsURL(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return 1;
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            return 1;
        }
        if (!string.regionMatches(true, n + 1, oracle_string, 0, n2 - (n + 1))) {
            return 1;
        }
        int n3 = string.indexOf(58, n2 + 1);
        if (n3 == -1) {
            return 2;
        }
        String string2 = string.substring(n2 + 1, n3);
        if (string2.equals("oci8") || string2.equals("thin") || string2.equals("kprb") || string2.equals(DRIVER_ULTRA)) {
            return 3;
        }
        return 2;
    }

    private Hashtable parseUrl(String string) throws SQLException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        int n2 = string.indexOf(58, string.indexOf(58) + 1) + 1;
        if (n2 == (n = string.length())) {
            return hashtable;
        }
        int n3 = string.indexOf(58, n2);
        if (n3 == -1) {
            return hashtable;
        }
        hashtable.put(protocol_string, string.substring(n2, n3));
        int n4 = n3 + 1;
        int n5 = string.indexOf(47, n4);
        int n6 = string.indexOf(64, n4);
        if (n6 == -1) {
            n6 = n;
        }
        if (n5 == -1) {
            n5 = n6;
        }
        if (n4 < n5) {
            hashtable.put(user_string, string.substring(n4, n5));
        }
        if (n5 < n6) {
            hashtable.put(password_string, string.substring(n5 + 1, n6));
        }
        if (n6 < n) {
            hashtable.put(database_string, string.substring(n6 + 1));
        }
        return hashtable;
    }
}

