<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>E T A T - C I V I L</b>

            <br />

            <br />
         </P>
      </div>
      <xsl:apply-templates select="xml/generalites" />

      <xsl:apply-templates select="xml/naissance" />

      <xsl:apply-templates select="xml/inscrUniv" />

      <xsl:apply-templates select="xml/bacs" />

   </xsl:template>

   <xsl:template match="generalites">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="CENTER" class="uportal-channel-strong">G E N E R A L I T E S</P>
            </TD>
         </TR>
      </TABLE>

      <xsl:call-template name="genEtudiant">
         <xsl:with-param name="dossier" select="dossier" />

         <xsl:with-param name="NNE" select="NNE" />

         <xsl:with-param name="nom" select="nom" />

         <xsl:with-param name="prenom" select="prenom" />

         <xsl:with-param name="email" select="email" />
      </xsl:call-template>
   </xsl:template>

   <xsl:template match="naissance">

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Nationalité</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="nationalite" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Né(e) le</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="datNaiss" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">A</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="lieu" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Département ou Pays</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="depPays" />
            </TD>
         </TR>
      </TABLE>
   </xsl:template>

   <xsl:template match="inscrUniv">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30">
               <P ALIGN="CENTER" class="uportal-channel-strong">I N S C R I P T I O N&#160;&#160;&#160;U N I V E R S I T E</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Année</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="annee" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Etablissement</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="etablissement" />
            </TD>
         </TR>
      </TABLE>   
   </xsl:template>

   <xsl:template match="bacs">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="CENTER" class="uportal-channel-strong">B A C</P>
            </TD>
         </TR>
      </TABLE>

      <xsl:apply-templates select="bac" />
   </xsl:template>

   <xsl:template match="bac">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Bac</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="type" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Obtenu en</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="datObtention" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Mention</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="mention" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Type établissement</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="typEtabliss" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Etablissement</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="etablissement" />
            </TD>
         </TR>

         <TR>
            <TD WWIDTH="23%" class="uportal-text">Département</TD>
            <TD class="uportal-channel-strong">
               <xsl:value-of select="departement" />
            </TD>
         </TR>
         
      </TABLE>
   </xsl:template>
</xsl:stylesheet>

