<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

<!-- action des liens -->
   <xsl:variable name="action_etat_civil">etat_civil</xsl:variable>

   <xsl:variable name="action_adresses">adresses</xsl:variable>

   <xsl:variable name="action_inscriptions">inscriptions</xsl:variable>

   <xsl:variable name="action_calendrier">calendrier</xsl:variable>

   <xsl:variable name="action_notes">notes</xsl:variable>

   <xsl:variable name="action_autreDossier">servantFinished&amp;autre=servantAnnuaire</xsl:variable>
   
   <xsl:variable name="action_retour">servantFinished&amp;sommaire=default</xsl:variable>

<!-- libell des liens -->
   <xsl:variable name="libelle_etat_civil">Etat-civil</xsl:variable>

   <xsl:variable name="libelle_adresses">Adresses</xsl:variable>

   <xsl:variable name="libelle_inscriptions">Inscriptions</xsl:variable>

   <xsl:variable name="libelle_calendrier">Calendrier des examens</xsl:variable>

   <xsl:variable name="libelle_notes">Notes et rsultats</xsl:variable>
   
   <xsl:variable name="libelle_autreDossier">Autre dossier</xsl:variable>

   <xsl:variable name="libelle_retour">Retour au sommaire</xsl:variable>

<!-- images des liens -->
   <xsl:variable name="image_etat_civil">etatCivil.gif</xsl:variable>

   <xsl:variable name="image_adresses">home.gif</xsl:variable>

   <xsl:variable name="image_inscriptions">inscription.gif</xsl:variable>

   <xsl:variable name="image_calendrier">calendrier.gif</xsl:variable>

   <xsl:variable name="image_notes">note.gif</xsl:variable>

   <xsl:variable name="image_retour">parentfolder.gif</xsl:variable>

<!-- Modle horizontal -->
   <xsl:template name="liensHorizontaux">
      <xsl:param name="annuaire">none</xsl:param>

      <br />

      <table align="center">
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <img alt="{$libelle_etat_civil}" border="0" src="{$mediaPath}/{$image_etat_civil}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <xsl:value-of select="$libelle_etat_civil" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_adresses}">
                  <img alt="{$libelle_adresses}" border="0" src="{$mediaPath}/{$image_adresses}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_adresses}">
                  <xsl:value-of select="$libelle_adresses" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_inscriptions}">
                  <img alt="{$libelle_inscriptions}" border="0" src="{$mediaPath}/{$image_inscriptions}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_inscriptions}">
                  <xsl:value-of select="$libelle_inscriptions" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_calendrier}">
                  <img alt=" {$libelle_calendrier}" border="0" src="{$mediaPath}/{$image_calendrier}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_calendrier}">
                  <xsl:value-of select="$libelle_calendrier" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_notes}">
                  <img alt="{$libelle_notes}" border="0" src="{$mediaPath}/{$image_notes}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_notes}">
                  <xsl:value-of select="$libelle_notes" />
               </a>
            </td>

            <xsl:if test="$annuaire!='none'">
               <td width="2%" align="center">|</td>

               <td valign="absmiddle">
                  <a href="{$baseActionURL}?{$action_autreDossier}">
                     <img src="{$mediaPath}/zoom.gif" border="0" alt="{$libelle_autreDossier}" />
                  </a>
               </td>

               <td class="uportal-channel-subtitle" nowrap="true">
                  <a href="{$baseActionURL}?{$action_autreDossier}"><xsl:value-of select="$libelle_autreDossier" /></a>
               </td>

               <td width="2%" align="center">|</td>

               <td valign="absmiddle">
                  <a href="{$baseActionURL}?{$action_retour}">
                     <img alt="{$libelle_retour}" border="0" src="{$mediaPath}/{$image_retour}" />
                  </a>
               </td>

               <td class="uportal-channel-subtitle" nowrap="true">
                  <a href="{$baseActionURL}?{$action_retour}">
                     <xsl:value-of select="$libelle_retour" />
                  </a>
               </td>
            </xsl:if>
         </tr>
      </table>
   </xsl:template>

<!-- Modle vertical -->
   <xsl:template name="liensVerticaux">
      <xsl:param name="annuaire">none</xsl:param>

      <table>
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <img alt="{$libelle_etat_civil}" border="0" src="{$mediaPath}/{$image_etat_civil}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <xsl:value-of select="$libelle_etat_civil" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_adresses}">
                  <img alt="{$libelle_adresses}" border="0" src="{$mediaPath}/{$image_adresses}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_adresses}">
                  <xsl:value-of select="$libelle_adresses" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_inscriptions}">
                  <img alt="{$libelle_inscriptions}" border="0" src="{$mediaPath}/{$image_inscriptions}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_inscriptions}">
                  <xsl:value-of select="$libelle_inscriptions" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_calendrier}">
                  <img alt="{$libelle_calendrier}" border="0" src="{$mediaPath}/{$image_calendrier}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_calendrier}">
                  <xsl:value-of select="$libelle_calendrier" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_notes}">
                  <img alt="{$libelle_notes}" border="0" src="{$mediaPath}/{$image_notes}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_notes}">
                  <xsl:value-of select="$libelle_notes" />
               </a>
            </td>
         </tr>

         <xsl:if test="$annuaire!='none'">
            <tr>
               <td></td>
            </tr>

			<tr>
				<td valign="absmiddle">
                  <a href="{$baseActionURL}?{$action_autreDossier}">
                     <img src="{$mediaPath}/zoom.gif" border="0" alt="{$libelle_autreDossier}" />
                  </a>
               </td>

               <td class="uportal-channel-subtitle" nowrap="true">
                  <a href="{$baseActionURL}?{$action_autreDossier}"><xsl:value-of select="$libelle_autreDossier" /></a>
               </td>
			</tr>
			
            <tr>
               <td valign="absmiddle">
                  <a href="{$baseActionURL}?{$action_retour}">
                     <img alt="{$libelle_retour}" border="0" src="{$mediaPath}/{$image_retour}" />
                  </a>
               </td>

               <td class="uportal-channel-subtitle" nowrap="true">
                  <a href="{$baseActionURL}?{$action_retour}">
                     <xsl:value-of select="$libelle_retour" />
                  </a>
               </td>
            </tr>
         </xsl:if>
      </table>
   </xsl:template>
</xsl:stylesheet>

