/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    oracle.jdbc.internal.OracleConnection connection;
    oracle.jdbc.internal.OracleStatement statement;
    int m_beginColumnIndex;

    public OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection oracleConnection, oracle.jdbc.internal.OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = 0;
    }

    OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection oracleConnection, oracle.jdbc.internal.OracleStatement oracleStatement, int n) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = n;
    }

    public OracleResultSetMetaData(OracleResultSet oracleResultSet) throws SQLException {
        this.statement = (oracle.jdbc.internal.OracleStatement)oracleResultSet.getStatement();
        this.connection = (oracle.jdbc.internal.OracleConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = oracleResultSet.getFirstUserColumnIndex();
    }

    public int getColumnCount() throws SQLException {
        return this.statement.getDBDescription().length - this.m_beginColumnIndex;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    private int getValidColumnIndex(int n) throws SQLException {
        int n2 = n + this.m_beginColumnIndex - 1;
        if (n2 < 0 || n2 >= this.statement.getDBDescription().length) {
            DBError.check_error(3, "getValidColumnIndex");
        }
        return n2;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 == 1 || n2 == 12 || n2 == -1;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 != -4 && n2 != -1 && n2 != 2004 && n2 != 2005 && n2 != -13 && n2 != 2002 && n2 != 2008 && n2 != 2007 && n2 != 2003 && n2 != 2006 && n2 != -10;
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.getColumnType(n) == 2;
    }

    public int isNullable(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].nullable ? 1 : 0;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].max_length;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].name;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 112: 
            case 113: {
                return Integer.parseInt(OracleDatabaseMetaData.getLobPrecision());
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.statement.getDBDescription()[n2].max_length;
            }
        }
        return this.statement.getDBDescription()[n2].precision;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].scale;
    }

    public String getTableName(int n) throws SQLException {
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (((OracleStatement)this.statement).connection.m_j2ee13Compliant && this.statement.getDBDescription()[n2].precision != 0 && this.statement.getDBDescription()[n2].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType oracleNamedType = (OracleNamedType)this.statement.getDBDescription()[n2].otype;
                TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleNamedType.getFullName(), (OracleConnection)this.connection);
                if (typeDescriptor != null) {
                    return typeDescriptor.getTypeCode();
                }
                DBError.throwSqlException(60);
                return -1;
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR2";
            }
            case -1: {
                return "LONG";
            }
            case -3: {
                return "RAW";
            }
            case -4: {
                return "LONG RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case -8: {
                return "ROWID";
            }
            case -10: {
                return "REFCURSOR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                int n3 = this.getValidColumnIndex(n);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n3].otype;
                return oracleTypeADT.getFullName();
            }
            case 2006: {
                int n4 = this.getValidColumnIndex(n);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n4].otype;
                return oracleTypeADT.getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 180: {
                return "oracle.sql.TIMESTAMP";
            }
            case 181: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case 231: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 182: {
                return "oracle.sql.INTERVALYM";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "oracle.jdbc.driver.OracleResultSet";
            }
            case 109: {
                switch (this.getColumnType(n)) {
                    case 2003: {
                        return "oracle.sql.ARRAY";
                    }
                    case 2007: {
                        return "oracle.sql.OPAQUE";
                    }
                    case 2008: {
                        Class clazz;
                        OracleNamedType oracleNamedType = (OracleNamedType)this.statement.getDBDescription()[n2].otype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (clazz = (Class)map.get(oracleNamedType.getFullName())) != null) {
                            return clazz.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, oracleNamedType.getSchemaName(), oracleNamedType.getSimpleName());
                    }
                    case 2002: {
                        Class clazz;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (clazz = (Class)map.get(((OracleNamedType)this.statement.getDBDescription()[n2].otype).getFullName())) != null) {
                            return clazz.getName();
                        }
                        return "oracle.sql.STRUCT";
                    }
                }
                DBError.throwSqlException(1);
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public boolean isNCHAR(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].FormOfUse == 2;
    }
}

