/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import oracle.gss.util.NLSLocale;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci.OCIAppFailoverCbk;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.LobPlsqlUtil;

public abstract class DBAccess {
    public static final short ORACLE8_PROD_VERSION = 8030;
    public static final byte IS_SELECT = 0;
    public static final byte IS_PLSQL_BLOCK = 1;
    public static final byte IS_DML = 2;
    public static final byte IS_OTHER = 3;
    public static final byte BIND_IN = 1;
    public static final byte BIND_OUT = 16;
    SQLWarning accessWarning = null;

    public abstract byte[] DBStatementToRefCursorBytes(DBStatement var1) throws SQLException, IOException;

    public abstract DBStatement RefCursorBytesToDBStatement(byte[] var1) throws SQLException, IOException;

    public void archive(int n, int n2, String string) throws SQLException {
        DBError.check_error(66, "archive");
    }

    public abstract void cancel() throws SQLException, IOException;

    public abstract void close(DBStatement var1) throws SQLException, IOException;

    public abstract void closeQuery(DBStatement var1) throws SQLException, IOException;

    public abstract void commit() throws SQLException, IOException;

    public DBDataSet createDBDataSet(OracleConnection oracleConnection, OracleStatement oracleStatement, int n, int n2) {
        return new DBDataSetImpl(oracleConnection, oracleStatement, n, n2);
    }

    public abstract DBItem createDBItem(DBType var1);

    public abstract DBType createDBType(int var1, boolean var2) throws SQLException;

    public DBType createDBType(int n, boolean bl, boolean bl2) throws SQLException {
        return this.createDBType(n, true);
    }

    public abstract DBColumn[] describe(DBStatement var1) throws SQLException, IOException;

    public abstract int executeFetch(DBStatement var1, byte var2, DBDataSet var3, int var4, DBDataSet var5, int var6) throws SQLException, IOException;

    public int executeFetchNeedDefines(DBStatement dBStatement, byte by, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        return this.executeFetch(dBStatement, by, dBDataSet, n, dBDataSet2, n2);
    }

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3) throws SQLException, IOException;

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3, int var4) throws SQLException, IOException;

    public void fileClose(BFILE bFILE) throws SQLException {
        LobPlsqlUtil.plsql_fileClose(bFILE);
    }

    public boolean fileExists(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileExists(bFILE);
    }

    public String fileGetDirAlias(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileGetDirAlias(bFILE);
    }

    public String fileGetName(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileGetName(bFILE);
    }

    public boolean fileIsOpen(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileIsOpen(bFILE);
    }

    public void fileOpen(BFILE bFILE) throws SQLException {
        LobPlsqlUtil.plsql_fileOpen(bFILE);
    }

    public int getC2SNlsRatio() {
        return 1;
    }

    public Properties getDBAccessProperties() throws SQLException {
        DBError.check_error(66, "getDBAccessProperties");
        return null;
    }

    public abstract int getDefaultPrefetch();

    public abstract int getDefaultStreamChunkSize();

    public long getLobChunkSize(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(bLOB);
    }

    public long getLobChunkSize(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(cLOB);
    }

    public int getNlsRatio() {
        return 1;
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public abstract byte[] getVersion() throws SQLException, IOException;

    public abstract short getVersionNumber() throws SQLException;

    public SQLWarning getWarnings() {
        return this.accessWarning;
    }

    public long hasPattern(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bFILE, byArray, l);
    }

    public long hasPattern(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bLOB, byArray, l);
    }

    public long hasPattern(CLOB cLOB, char[] cArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l);
    }

    public void initNls(OracleConnection oracleConnection) throws SQLException {
    }

    public long isSubLob(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bFILE, bFILE2, l);
    }

    public long isSubLob(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bLOB, bLOB2, l);
    }

    public long isSubLob(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(cLOB, cLOB2, l);
    }

    public long lobLength(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_length(bFILE);
    }

    public long lobLength(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(bLOB);
    }

    public long lobLength(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(cLOB);
    }

    public long lobRead(BFILE bFILE, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bFILE, l, l2, byArray);
    }

    public long lobRead(BLOB bLOB, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bLOB, l, l2, byArray);
    }

    public long lobRead(CLOB cLOB, long l, long l2, char[] cArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(cLOB, l, l2, cArray);
    }

    public long lobWrite(BLOB bLOB, long l, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_write(bLOB, l, byArray);
    }

    public long lobWrite(CLOB cLOB, long l, char[] cArray) throws SQLException {
        return LobPlsqlUtil.plsql_write(cLOB, l, cArray);
    }

    public abstract void logoff() throws SQLException, IOException;

    public abstract DBConversion logon(String var1, String var2, String var3, Properties var4) throws SQLException, IOException;

    public abstract DBStatement open() throws SQLException, IOException;

    public abstract DBColumn[] parseExecuteDescribe(DBStatement var1, byte[] var2, DBDataSet var3) throws SQLException, IOException;

    public abstract int parseExecuteFetch(DBStatement var1, byte var2, byte[] var3, DBDataSet var4, int var5, DBDataSet var6, int var7) throws SQLException, IOException;

    public abstract int read(DBStatement var1, byte[] var2, int var3) throws SQLException, IOException;

    public void registerTAFCallback(Connection connection, OCIAppFailoverCbk oCIAppFailoverCbk, Object object) {
    }

    public abstract void rollback() throws SQLException, IOException;

    public abstract void setAutoCommit(boolean var1) throws SQLException, IOException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setNlsParamsClient(OracleConnection oracleConnection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 2, 16, "DBAccess.setNlsParamsClient()");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            try {
                String string2;
                statement = oracleConnection.createStatement();
                NLSLocale nLSLocale = NLSLocale.getInstance();
                String string3 = nLSLocale.getNLSLanguage(Locale.getDefault());
                if (string3 != null) {
                    statement.execute("ALTER SESSION SET NLS_LANGUAGE = '" + string3 + "'");
                }
                if ((string2 = nLSLocale.getNLSTerritory(Locale.getDefault())) != null) {
                    statement.execute("ALTER SESSION SET NLS_TERRITORY = '" + string2 + "'");
                }
                ((OracleStatement)statement).setRowPrefetch(1);
                resultSet = statement.executeQuery("SELECT VALUE FROM NLS_INSTANCE_PARAMETERS WHERE PARAMETER ='NLS_DATE_FORMAT'");
                if (resultSet.next() && (string = resultSet.getString(1)) != null) {
                    statement.execute("ALTER SESSION SET NLS_DATE_FORMAT = '" + string + "'");
                }
                if (OracleLog.TRACE) {
                    OracleLog.print(oracleConnection, 2, 1, "DBAccess.setNlsParamsClient(): NLSLanguage=" + string3 + ", NLSTerritory=" + string2 + ", DateFormat=" + string);
                }
            }
            catch (SQLException sQLException) {
            }
            Object var6_8 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (statement != null) {
                statement.close();
            }
            statement = null;
            throw throwable;
        }
        statement.close();
    }

    public void setWaitandAutoRollback(DBStatement dBStatement, int n, int n2) throws SQLException {
        DBError.check_error(66, "setWaitandAutoRollback");
    }

    public void setWarnings(SQLWarning sQLWarning) {
        this.accessWarning = sQLWarning;
    }

    public void shutdown(int n) throws SQLException {
        DBError.check_error(66, "shutdown");
    }

    public void startup(String string, int n) throws SQLException {
        DBError.check_error(66, "startup");
    }
}

