/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class NLParamParser {
    private String filename;
    private Hashtable ht;
    private Vector linebuffer;
    private int Commentcnt;
    private int nvStringcnt;
    private int Groupcnt;
    private boolean hasComments;
    private boolean hasGroups;
    private String[] errstr;
    private int errstrcnt;
    public static final byte IGNORE_NL_EXCEPTION = 1;
    public static final byte IGNORE_FILE_EXCEPTION = 2;
    public static final byte NLPASUCC = 1;
    public static final byte NLPAOVWR = 2;
    public static final byte NLPAFAIL = -1;
    private static boolean DEBUG = false;

    public NLParamParser(String string) throws IOException, NLException {
        String string2;
        this.Commentcnt = 0;
        this.nvStringcnt = 0;
        this.Groupcnt = 0;
        this.hasComments = false;
        this.hasGroups = false;
        this.filename = string;
        this.ht = new Hashtable(128);
        this.linebuffer = new Vector(100, 50);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                this.linebuffer.addElement(string2);
            }
            fileReader.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileReader != null) {
                fileReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            if (fileReader != null) {
                fileReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw iOException;
        }
        string2 = "";
        String string3 = System.getProperty("line.separator");
        String string4 = "";
        String string5 = "";
        int n = 0;
        while (n < this.linebuffer.size()) {
            String string6 = (String)this.linebuffer.elementAt(n);
            if (string6.length() != 0) {
                if (string6.charAt(0) == '#') {
                    if (string6.indexOf(".ORA Configuration ") != -1 || string6.indexOf(" Network Configuration File: ") != -1 || string6.indexOf("Generated by") != -1) {
                        if (DEBUG) {
                            System.out.println(String.valueOf(string6) + ": this comment ignored");
                        }
                    } else if (string4.length() != 0) {
                        string5 = String.valueOf(string5) + string6 + string3;
                    } else {
                        string4 = "COMMENT#" + this.Commentcnt;
                        string5 = String.valueOf(string6) + string3;
                        if (!this.hasComments) {
                            this.hasComments = true;
                        }
                    }
                } else if (string6.charAt(0) == ' ' || string6.charAt(0) == '\t') {
                    if (string5.length() == 0) {
                        if (string2.length() == 0) {
                            string6 = this.EatNLPWS(string6);
                        }
                        if ((string6 = this.checkNLPforComments(string6)).length() != 0) {
                            string2 = String.valueOf(string2) + string6 + string3;
                        }
                    } else if (string2.length() == 0 && string5.length() != 0) {
                        string6 = this.EatNLPWS(string6);
                        if ((string6 = this.checkNLPforComments(string6)).length() != 0) {
                            throw new NLException(1);
                        }
                    } else if (string2.length() != 0 && string5.length() != 0) {
                        string4 = "";
                        string5 = "";
                        string6 = this.checkNLPforComments(string6);
                        string2 = String.valueOf(string2) + string6 + string3;
                    }
                } else if (string2.length() == 0 && string5.length() == 0) {
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() == 0 && string5.length() != 0) {
                    string5 = this.modifyCommentString(string5);
                    this.addNLPListElement(String.valueOf(string4) + "=" + string5);
                    string4 = "";
                    string5 = "";
                    ++this.Commentcnt;
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() != 0 && string5.length() == 0) {
                    this.addNLPListElement(string2);
                    string2 = "";
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() != 0 && string5.length() != 0) {
                    this.addNLPListElement(string2);
                    string2 = "";
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                    string5 = this.modifyCommentString(string5);
                    this.addNLPListElement(String.valueOf(string4) + "=" + string5);
                    string4 = "";
                    string5 = "";
                    ++this.Commentcnt;
                }
            }
            ++n;
        }
        if (string2.length() != 0) {
            this.addNLPListElement(string2);
            string2 = "";
        }
        if (string5.length() != 0) {
            string5 = this.modifyCommentString(string5);
            this.addNLPListElement(String.valueOf(string4) + "=" + string5);
            string4 = "";
            string5 = "";
            ++this.Commentcnt;
        }
    }

    public NLParamParser(String string, byte by) throws NLException, IOException {
        String string2;
        block48: {
            this.Commentcnt = 0;
            this.nvStringcnt = 0;
            this.Groupcnt = 0;
            this.hasComments = false;
            this.hasGroups = false;
            this.filename = string;
            this.ht = new Hashtable(128);
            this.linebuffer = new Vector(100, 50);
            this.errstr = new String[50];
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.linebuffer.addElement(string2);
                }
                fileReader.close();
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if ((by & 2) == 0) {
                    throw fileNotFoundException;
                }
            }
            catch (IOException iOException) {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufferedReader == null) break block48;
                bufferedReader.close();
            }
        }
        string2 = "";
        String string3 = System.getProperty("line.separator");
        String string4 = "";
        String string5 = "";
        int n = 0;
        while (n < this.linebuffer.size()) {
            String string6 = (String)this.linebuffer.elementAt(n);
            if (string6.length() != 0) {
                if (string6.charAt(0) == '#') {
                    if (string6.indexOf(".ORA Configuration File:") != -1 || string6.indexOf(" Network Configuration File: ") != -1 || string6.indexOf("Generated by") != -1) {
                        if (DEBUG) {
                            System.out.println(String.valueOf(string6) + ": this comment ignored");
                        }
                    } else if (string4.length() != 0) {
                        string5 = String.valueOf(string5) + string6 + string3;
                    } else {
                        string4 = "COMMENT#" + this.Commentcnt;
                        string5 = String.valueOf(string6) + string3;
                    }
                } else if (string6.charAt(0) == ' ' || string6.charAt(0) == '\t') {
                    if (string5.length() == 0) {
                        if (string2.length() == 0) {
                            string6 = this.EatNLPWS(string6);
                        }
                        if ((string6 = this.checkNLPforComments(string6)).length() != 0) {
                            string2 = String.valueOf(string2) + string6 + string3;
                        }
                    } else if (string2.length() == 0 && string5.length() != 0) {
                        string6 = this.EatNLPWS(string6);
                        if ((string6 = this.checkNLPforComments(string6)).length() != 0 && (by & 1) == 0) {
                            throw new NLException(1);
                        }
                    } else if (string2.length() != 0 && string5.length() != 0) {
                        string4 = "";
                        string5 = "";
                        string6 = this.checkNLPforComments(string6);
                        string2 = String.valueOf(string2) + string6 + string3;
                    }
                } else if (string2.length() == 0 && string5.length() == 0) {
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() == 0 && string5.length() != 0) {
                    block49: {
                        string5 = this.modifyCommentString(string5);
                        try {
                            this.addNLPListElement(String.valueOf(string4) + "=" + string5);
                        }
                        catch (NLException nLException) {
                            this.errstr[this.errstrcnt++] = string2;
                            if ((by & 1) != 0) break block49;
                            throw nLException;
                        }
                    }
                    string4 = "";
                    string5 = "";
                    ++this.Commentcnt;
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() != 0 && string5.length() == 0) {
                    block50: {
                        try {
                            this.addNLPListElement(string2);
                        }
                        catch (NLException nLException) {
                            this.errstr[this.errstrcnt++] = string2;
                            if ((by & 1) != 0) break block50;
                            throw nLException;
                        }
                    }
                    string2 = "";
                    string6 = this.checkNLPforComments(string6);
                    string2 = String.valueOf(string2) + string6 + string3;
                } else if (string2.length() != 0 && string5.length() != 0) {
                    block52: {
                        block51: {
                            try {
                                this.addNLPListElement(string2);
                            }
                            catch (NLException nLException) {
                                this.errstr[this.errstrcnt++] = string2;
                                if ((by & 1) != 0) break block51;
                                throw nLException;
                            }
                        }
                        string2 = "";
                        string6 = this.checkNLPforComments(string6);
                        string2 = String.valueOf(string2) + string6 + string3;
                        string5 = this.modifyCommentString(string5);
                        try {
                            this.addNLPListElement(String.valueOf(string4) + "=" + string5);
                        }
                        catch (NLException nLException) {
                            this.errstr[this.errstrcnt++] = string2;
                            if ((by & 1) != 0) break block52;
                            throw nLException;
                        }
                    }
                    string4 = "";
                    string5 = "";
                    ++this.Commentcnt;
                }
            }
            ++n;
        }
        if (string2.length() != 0) {
            block53: {
                try {
                    this.addNLPListElement(string2);
                }
                catch (NLException nLException) {
                    this.errstr[this.errstrcnt++] = string2;
                    if ((by & 1) != 0) break block53;
                    throw nLException;
                }
            }
            string2 = "";
        }
        if (string5.length() != 0) {
            block54: {
                string5 = this.modifyCommentString(string5);
                try {
                    this.addNLPListElement(String.valueOf(string4) + "=" + string5);
                }
                catch (NLException nLException) {
                    this.errstr[this.errstrcnt++] = string2;
                    if ((by & 1) != 0) break block54;
                    throw nLException;
                }
            }
            string4 = "";
            string5 = "";
            ++this.Commentcnt;
        }
    }

    private String EatNLPWS(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        boolean bl = false;
        while (!bl) {
            char c;
            if ((c = string.charAt(n++)) != ' ' || c != '\t') {
                bl = true;
                int n2 = n - 1;
                while (string.charAt(n2) == '\n') {
                    stringBuffer.append(string.charAt(n2));
                    ++n2;
                }
                continue;
            }
            if (c != '\n') continue;
            return "";
        }
        return stringBuffer.toString();
    }

    public void addNLPGroupProfile(String[] stringArray) {
        String string = new String("GROUP#" + this.Groupcnt++);
        String[] stringArray2 = stringArray;
        if (!this.hasGroups) {
            this.hasGroups = true;
        }
        this.addNLPListElement(string, stringArray2);
    }

    public void addNLPListElement(String string) throws NLException {
        Object object;
        char[] cArray = new char[string.length() + 2];
        String string2 = "";
        if (DEBUG) {
            System.out.println("Entering Method addNLPListElement\n");
            System.out.println("String to add is: " + string);
        }
        string.getChars(0, string.length(), cArray, 1);
        if (cArray[1] == '(') {
            string2 = string;
        } else {
            cArray[0] = 40;
            object = System.getProperty("os.name");
            if (((String)object).equals("Windows NT") || ((String)object).equals("Windows 95")) {
                if (cArray[cArray.length - 2] == '/' || cArray[cArray.length - 2] == '\\') {
                    cArray[cArray.length - 2] = 41;
                } else {
                    cArray[cArray.length - 1] = 41;
                }
            } else if (cArray[cArray.length - 2] == '\\') {
                cArray[cArray.length - 2] = 41;
            } else {
                cArray[cArray.length - 1] = 41;
            }
            string2 = new String(cArray);
            if (DEBUG) {
                System.out.println("The modified NV String is: " + string2);
            }
        }
        object = new NVFactory();
        NVPair nVPair = ((NVFactory)object).createNVPair(string2);
        if (nVPair == null && DEBUG) {
            throw new NLException(100);
        }
        if (nVPair.getRHSType() == NVPair.RHS_NONE) {
            throw new NLException(101);
        }
        String string3 = nVPair.getName();
        String string4 = string3.toUpperCase();
        nVPair.setName(string4);
        if (DEBUG) {
            System.out.println("The final NV String is: " + nVPair.toString());
        }
        byte by = this.addNLPListElement(string4, nVPair);
        switch (by) {
            case 2: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + string3 + " was overwritten\n");
                break;
            }
            case -1: {
                if (!DEBUG) break;
                System.out.println("The value for the Name: " + string3 + " could not be inserted\n");
            }
        }
    }

    public byte addNLPListElement(String string, Object object) {
        try {
            Object object2 = this.ht.put(string, object);
            return object2 != null ? (byte)2 : 1;
        }
        catch (NullPointerException nullPointerException) {
            if (DEBUG) {
                System.out.println(((Throwable)nullPointerException).getMessage());
            }
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkNLPforComments(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '#') {
                if (n == 0) return "";
                if (string.charAt(n - 1) != '\\') return stringBuffer.toString();
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean fileHasComments() {
        return this.hasComments;
    }

    public String getFilename() {
        return this.filename;
    }

    public String[] getNLPAllElements() {
        int n = this.getNLPListSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            NVPair nVPair = (NVPair)enumeration.nextElement();
            if (nVPair.getName().indexOf("COMMENT") != -1) continue;
            String string = nVPair.toString();
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    public String[] getNLPAllNames() {
        int n = this.getNLPListSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("COMMENT") != -1) continue;
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    private String[] getNLPGroupProfile(String string) {
        String string2 = string.toUpperCase();
        return (String[])this.ht.get(string2);
    }

    public NVPair getNLPListElement(String string) {
        String string2 = string.toUpperCase();
        return (NVPair)this.ht.get(string2);
    }

    public int getNLPListSize() {
        this.nvStringcnt = 0;
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("COMMENT") != -1) continue;
            ++this.nvStringcnt;
        }
        return this.nvStringcnt;
    }

    public boolean inErrorList(String string) {
        boolean bl = false;
        if (DEBUG) {
            System.out.println("Entering inErrorList():");
        }
        int n = 0;
        while (!bl || n < this.errstrcnt) {
            if (this.errstrcnt == 0) break;
            if (this.errstr[n].indexOf(string) != -1) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private String modifyCommentString(String string) {
        String string2 = "";
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '(': {
                    string2 = String.valueOf(string2) + "\\(";
                    break;
                }
                case '=': {
                    string2 = String.valueOf(string2) + "\\=";
                    break;
                }
                case ')': {
                    string2 = String.valueOf(string2) + "\\)";
                    break;
                }
                case ',': {
                    string2 = String.valueOf(string2) + "\\,";
                    break;
                }
                case '\\': {
                    string2 = String.valueOf(string2) + "\\\\";
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + string.charAt(n);
                }
            }
            ++n;
        }
        return string2;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void removeNLPAllElements() {
        this.ht.clear();
    }

    public void removeNLPGroupProfile(String string) {
        String string2 = string.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + string2 + " GroupName from Table");
        }
        Object v = this.ht.remove(string2);
    }

    public NVPair removeNLPListElement(String string) {
        Object v;
        String string2 = string.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + string2 + " from Table");
        }
        return (v = this.ht.remove(string2)) != null ? (NVPair)v : null;
    }

    private void saveNLPGroups(PrintWriter printWriter) {
        int n = 0;
        while (n < this.Groupcnt) {
            String string = new String("GROUP#" + n);
            String[] stringArray = this.getNLPGroupProfile(string);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = null;
                String string3 = null;
                NVPair nVPair = null;
                if (DEBUG) {
                    System.out.println("Current Value in Group Profile: " + stringArray[n2]);
                }
                if (stringArray[n2] != null) {
                    nVPair = this.getNLPListElement(stringArray[n2]);
                    if (nVPair != null) {
                        string2 = nVPair.toString(0, true);
                        if (DEBUG) {
                            System.out.println("Parameter Value = " + string2);
                        }
                        char[] cArray = new char[string2.length() - 2];
                        string2.getChars(1, string2.length() - 1, cArray, 0);
                        string3 = new String(cArray);
                        printWriter.println(string3);
                        printWriter.println("");
                        NVPair nVPair2 = this.removeNLPListElement(stringArray[n2]);
                        if (nVPair2 == null && DEBUG) {
                            System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
                        }
                        cArray = null;
                        string3 = null;
                    } else if (DEBUG) {
                        System.out.println("No such Parameter in the Table");
                    }
                }
                ++n2;
            }
            this.removeNLPGroupProfile(string);
            ++n;
        }
    }

    public void saveNLParams() throws IOException {
        FileWriter fileWriter = null;
        PrintWriter printWriter = null;
        String string = "";
        try {
            fileWriter = new FileWriter(this.filename);
            printWriter = new PrintWriter(fileWriter);
            StringTokenizer stringTokenizer = new StringTokenizer(this.filename, File.separator);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            printWriter.println("# " + string.toUpperCase() + " Network Configuration File: " + this.filename);
            printWriter.println("# Generated by Oracle configuration tools.");
            printWriter.println("");
            if (this.hasGroups) {
                this.saveNLPGroups(printWriter);
            }
            Enumeration enumeration = this.ht.elements();
            while (enumeration.hasMoreElements()) {
                NVPair nVPair = (NVPair)enumeration.nextElement();
                String string2 = nVPair.toString(0, true);
                if (DEBUG) {
                    System.out.println("The initial stringified NVPair is:\n" + string2);
                }
                char[] cArray = new char[string2.length() - 2];
                string2.getChars(1, string2.length() - 1, cArray, 0);
                String string3 = new String(cArray);
                if (DEBUG) {
                    System.out.println("The modified NV String is:\n" + string3);
                }
                printWriter.println(string3);
                printWriter.println("");
                cArray = null;
            }
            printWriter.close();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
            throw iOException;
        }
    }

    public void saveNLParams(String string) throws FileNotFoundException, IOException {
        this.filename = string;
        this.saveNLParams();
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            NVPair nVPair = (NVPair)enumeration.nextElement();
            String string2 = nVPair.toString();
            string = String.valueOf(string) + string2 + "\n";
        }
        return string;
    }
}

