/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(sQLName, oracleTypeADT, connection);
    }

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        StructDescriptor structDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((structDescriptor = (StructDescriptor)((OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (OracleConnection)connection)).getName())) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            ((OracleConnection)connection).putDescriptor(string2, structDescriptor);
        }
        return structDescriptor;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "  ";
            ++n2;
        }
        String string2 = String.valueOf(string) + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            TypeDescriptor typeDescriptor;
            int n5 = resultSetMetaData.getColumnType(n4 + 1);
            if (n5 == 2002) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n4 + 1), this.m_conn);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
            } else if (n5 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n4 + 1), this.m_conn);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(resultSetMetaData.getColumnTypeName(n4 + 1));
                stringBuffer.append("\n");
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null && this.m_conn.getUserName().equals(string2)) {
            clazz = (Class)map.get(string3);
        }
        if (!SQLName.s_parseAllFormat) {
            return clazz;
        }
        if (clazz == null && this.m_conn.getUserName().equals(string2)) {
            clazz = (Class)map.get("\"" + string3 + "\"");
        }
        if (clazz == null) {
            clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
        }
        if (clazz == null) {
            clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
        }
        if (clazz == null) {
            clazz = (Class)map.get(String.valueOf(string2) + "." + "\"" + string3 + "\"");
        }
        return clazz;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.m_pickler).getAttrTypes();
    }

    public int getLength() throws SQLException {
        return this.getFieldTypes().length;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new StructMetaData(this);
    }

    public OracleTypeADT getOracleTypeADT() {
        return (OracleTypeADT)this.m_pickler;
    }

    private void initPickler() throws SQLException {
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            ((OracleTypeADT)this.m_pickler).init(this.m_conn);
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DBError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("StructDescriptor::readObject");
        }
    }

    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.m_objArray == null) {
            if (sTRUCT.m_datumArray != null) {
                objectArray = new Object[sTRUCT.m_datumArray.length];
                int n = 0;
                while (n < sTRUCT.m_datumArray.length) {
                    if (sTRUCT.m_datumArray[n] != null) {
                        objectArray[n] = sTRUCT.m_datumArray[n] instanceof STRUCT ? ((STRUCT)sTRUCT.m_datumArray[n]).toJdbc(map) : sTRUCT.m_datumArray[n].toJdbc();
                    }
                    ++n;
                }
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)this.m_pickler);
                }
                this.m_pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.m_imgOffset, sTRUCT, 2, map);
                objectArray = sTRUCT.m_objArray;
                sTRUCT.m_objArray = null;
            } else {
                DBError.throwSqlException(1);
            }
        } else {
            objectArray = (Object[])sTRUCT.m_objArray.clone();
        }
        return objectArray;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.m_conn);
        return this.toOracleArray(sTRUCT, false);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.m_datumArray != null) {
                byArray = this.m_pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.setShareBytes(null);
                }
            } else if (sTRUCT.m_objArray != null) {
                sTRUCT.m_datumArray = this.toOracleArray(sTRUCT.m_objArray);
                byArray = this.m_pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.m_datumArray = null;
                    sTRUCT.setShareBytes(null);
                }
            } else {
                DBError.throwSqlException(1);
            }
        } else if (sTRUCT.m_imgLength != 0L && (sTRUCT.m_imgOffset != 0L || sTRUCT.m_imgLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)sTRUCT.m_imgLength];
            System.arraycopy(byArray, (int)sTRUCT.m_imgOffset, byArray2, 0, (int)sTRUCT.m_imgLength);
            sTRUCT.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, null, this.m_conn);
        sTRUCT.setDatumArray(datumArray);
        return this.m_pickler.linearize(sTRUCT);
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.m_conn);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.m_conn);
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.m_datumArray;
        if (datumArray == null) {
            if (sTRUCT.m_objArray != null) {
                datumArray = this.toOracleArray(sTRUCT.m_objArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)this.m_pickler);
                }
                this.m_pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.m_imgOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.m_datumArray;
                if (!bl) {
                    sTRUCT.m_datumArray = null;
                }
            } else {
                DBError.throwSqlException(1);
            }
        }
        if (bl) {
            sTRUCT.m_datumArray = datumArray;
            return (Datum[])datumArray.clone();
        }
        return datumArray;
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        OracleType[] oracleTypeArray = this.getFieldTypes();
        int n = oracleTypeArray.length;
        if (objectArray.length != n) {
            DBError.check_error(49, null);
        }
        Datum[] datumArray = new Datum[n];
        int n2 = 0;
        while (n2 < n) {
            datumArray[n2] = oracleTypeArray[n2].toDatum(objectArray[n2], this.m_conn);
            ++n2;
        }
        return datumArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("StructDescriptor::writeObject");
        }
    }
}

