package org.esupportail.portal.channels.gestion.CMonDossierWeb;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.connectors.ApogeeConnector;
import org.esupportail.portal.utils.connectors.ConnectorException;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.utils.channels.plugins.FatalError;


/**
 * 
 * <p>CMonDossierWeb</p>
 * <p>Description : Mon dossier Web : consultation des rsultats des tudiants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.2
 *
 */
public class CMonDossierWeb extends MainChannel {
	
	// id de l'utilisateur
	private String userId;
	// cod_ind de l'utilisateur
	protected String cod_ind;
	// flux xml correspondant  l'en-tte des diffrentes pages
	private String xmlEtudiant;
	// login de la personne traite
	protected String loginEtu;
	
	public CMonDossierWeb() throws PortalException {
		setConfigActions(Config.getInstance());	
	}
	
	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 * @throws PortalException
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		super.setStaticData(sd);
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		cod_ind = getCodInd();
		loginEtu = getLoginEtu();
	}
  
	/**
	 * @return
	 */
	public String getUserId() {
		return userId;
	}
	
	/**
	 * Rcupration du cod_ind 
	 * 
	 */
	public String getCodInd() {
		if (cod_ind == null) {
			// on rcupre le cod_ind via le connecteur Apogee
			try {
				cod_ind = ApogeeConnector.getCOD_IND(getStaticData().getPerson());
				// pour test 
				// cod_ind = "29701020"; // V. Jeannot pour VAC
			} 
			catch (ConnectorException e1) {
				// enregistrement plugin fatalError
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				return null;
			}
		}
		return cod_ind;
	}
	
	
	/**
	 * Mthode qui retourne les infos principales d'un tudiant sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlEtudiant() throws FrameWorkException {
		Query qry = null;
		boolean error = false;
		StringBuffer res = null;
		
		if (xmlEtudiant == null) {
			res = new StringBuffer("<etudiant>");
			//	Connexion  la base et excution d'une requte
			try {
				// on rcupre le cod_ind via le connecteur Apogee
				cod_ind = getCodInd(); 
					
				if (cod_ind != null) { // la personne connecte  un cod_ind
					qry = Config.getInstance().getConnexionDefault();
					qry.setSql("select i.cod_etu,i.cod_nne_ind,i.cod_cle_nne_ind,i.lib_nom_pat_ind,i.lib_pr1_ind," +
									 "i.daa_ent_etb, i.cod_etb " +
									 " from apogee.individu i " +
									 " where i.cod_ind = ? ");
					qry.getStmt().setString(1, cod_ind);				
					qry.select();			   
					while (qry.getRs().next()){
						res.append("<dossier>").append(qry.getRs().getString("cod_etu")).append("</dossier>").
							append("<NNE>").
							append(qry.getRs().getString("cod_nne_ind")).append(qry.getRs().getString("cod_cle_nne_ind")).
							append("</NNE>").
							append("<nom>").append(qry.getRs().getString("lib_nom_pat_ind")).append("</nom>").
							append("<prenom>").append(qry.getRs().getString("lib_pr1_ind")).append("</prenom>").
							append("<email>");
						if (Config.getInstance().getExtMail() != null && !Config.getInstance().getExtMail().equals(""))
							res.append(loginEtu+Config.getInstance().getExtMail());
						res.append("</email>");
					}
				}
			} 
			catch (SQLException e) {
				log(Priority.ERROR,"CMonDossierWeb::getXmlEtudiant() : Erreur SQL " + e);
			}
			catch (Exception e) {
				log(Priority.ERROR,"CMonDossierWeb::getXmlEtudiant() : Erreur " + e);
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
			res.append("</etudiant>");
		}
		return res;

	}
	
	/**
	 * @return Returns the loginEtu.
	 */
	public String getLoginEtu() {
		if (loginEtu == null)
			loginEtu = userId;
		return loginEtu;
	}
	
}
