package org.esupportail.portal.channels.gestion.CMonDossierWeb;

import java.io.IOException;
import org.esupportail.portal.utils.channels.ConfigChannel;

/**
 * 
 * <p>ConfigChannel</p>
 * <p>Classe permettant d'accder  la configuration de la channel CMonDossierWeb</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.1
 *
 */
public class Config extends ConfigChannel
{ 
	//dclaration des variables de la classe
	private static Config singleton = null;
	// info pour la partie adresse
	private String COD_ANU_INS;
	// extension des adresses mail tudiantes
	private String extMail;
	//message d'interdiction
	private String msgInterdit;

	/**
	* 
	* @return ConfigChannel Instance
	* @throws IOException
	* @throws JspException
	*/
	public static Config getInstance() {
	if(singleton == null) {
		 singleton = new Config();
		 }
	return singleton;
	}

	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {
		dig.addCallMethod("config","addRoot",3);
		dig.addCallParam("config/COD_ANU_INS",0);
		dig.addCallParam("config/extMail",1);
		dig.addCallParam("config/msgInterdit",2);
	}

	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.ConfigChannel#getConfigFile()
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CMonDossierWeb/CMonDossierWeb.xml";
	}
	
	/**
	* 
	* @param COD_ANU_INS Parameter of file CMonDossierWeb.xml
	* @param extMail Parameter of file CMonDossierWeb.xml
	* @param msgInterdit Parameter of file CMonDossierWeb.xml
	* 
	*/
	public void addRoot(String COD_ANU_INS, String extMail, String msgInterdit){
		this.COD_ANU_INS = COD_ANU_INS;
		this.extMail = extMail;
		this.msgInterdit = msgInterdit;
	}

	/**
	 * @return
	 */
	public String getCOD_ANU_INS() {
		return COD_ANU_INS;
	}

	/**
	 * @param string
	 */
	public void setCOD_ANU_INS(String string) {
		COD_ANU_INS = string;
	}

	/**
	 * @return Returns the extMail.
	 */
	public String getExtMail() {
		return extMail;
	}
	/**
	 * @param extMail The extMail to set.
	 */
	public void setExtMail(String extMail) {
		this.extMail = extMail;
	}
	
	/**
	 * @return Returns the msgInterdit.
	 */
	public String getMsgInterdit() {
		return msgInterdit;
	}
	/**
	 * @param msgInterdit The msgInterdit to set.
	 */
	public void setMsgInterdit(String msgInterdit) {
		this.msgInterdit = msgInterdit;
	}
}

