<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:import href="CodesRes.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="vueEtudiant">none</xsl:param>

   <xsl:param name="code">none</xsl:param>

   <xsl:param name="codeAnnu">none</xsl:param>
   
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>N O T E S</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:if test="$modeServant!='none'">
         <div>
            <P class="uportal-text">
               <br />

               <form name="formVue" action="{$baseActionURL}" method="post">
               <input type="hidden" name="isProf" value="" />

               <input type="hidden" name="code" value="{$code}" />

               <input type="hidden" name="codeAnnu" value="{$codeAnnu}" />

               <input type="checkbox" name="checkVue" onClick="javascript:if (document.formVue.checkVue.checked) document.formVue.isProf.value='N'; else document.formVue.isProf.value='O'; document.formVue.submit();">
                  <xsl:if test="$vueEtudiant != 'none'">
                     <xsl:attribute name="checked">
                        <xsl:value-of select="$vueEtudiant" />
                     </xsl:attribute>
                  </xsl:if>
               </input>

               Voir comme un étudiant</form>
            </P>
         </div>
      </xsl:if>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="100%" HEIGHT="40" class="uportal-background-light">
               <P ALIGN="CENTER" class="uportal-channel-strong">E T U D I A N T</P>
            </TD>
         </TR>
      </TABLE>

      <xsl:call-template name="genEtudiant">
         <xsl:with-param name="dossier" select="xml/etudiant/dossier" />

         <xsl:with-param name="NNE" select="xml/etudiant/NNE" />

         <xsl:with-param name="nom" select="xml/etudiant/nom" />

         <xsl:with-param name="prenom" select="xml/etudiant/prenom" />

         <xsl:with-param name="email" select="xml/etudiant/email" />
      </xsl:call-template>

	  <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="100%" HEIGHT="40" class="uportal-background-light">
               <P ALIGN="CENTER" class="uportal-channel-strong">E L E M E N T S&#160;&#160;&#160;&amp;&#160;&#160;&#160;E P R E U V E S</P>
            </TD>
         </TR>
      </TABLE>

      <xsl:apply-templates select="xml/etape" />

	  <xsl:if test="count(xml/etape)=0">
	  	<p class="uportal-text">Pas de résultat disponible</p>
	  </xsl:if>	

      <xsl:call-template name="codesRes" />
   </xsl:template>

   <xsl:template match="etape">

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="10%" class="uportal-channel-strong">Année 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="11%" class="uportal-channel-strong">Code 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="51%" class="uportal-channel-strong">Libellé 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="9%" class="uportal-channel-strong">Juin 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="10%" class="uportal-channel-strong">Résultat 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="5%" class="uportal-channel-strong">Sept. 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="2%" class="uportal-channel-strong">Résultat 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>
         </TR>

         <xsl:for-each select=". | //element | //epreuve">
            <xsl:call-template name="note" />
         </xsl:for-each>
      </TABLE>
   </xsl:template>

   <xsl:template name="note">
      <xsl:choose>
         <xsl:when test="(local-name(.) = 'epreuve') and (count(../epreuve)=1) and (../@noteJuin = @noteJuin) and (../@noteSep = @noteSep)">
         </xsl:when>

         <xsl:otherwise>
            <tr onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
               <td width="10%" class="uportal-channel-strong">
                  <xsl:if test="local-name(.) = 'etape'">
                     <xsl:value-of select="@annee" />
                  </xsl:if>
               </td>

               <td width="11%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <xsl:value-of select="@code" />
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <xsl:value-of select="@code" />
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <xsl:value-of select="@code" />
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>

               <td width="51%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <div style="text-indent:{@level}em">
                              <xsl:value-of select="@libelle" />
                           </div>
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <div style="text-indent:{@level}em">
                                 <xsl:value-of select="@libelle" />
                              </div>
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <div style="text-indent:{@level}em">
                              <xsl:value-of select="@libelle" />
                           </div>
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>

               <td width="9%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <xsl:value-of select="@noteJuin" />
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <xsl:value-of select="@noteJuin" />
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <xsl:value-of select="@noteJuin" />
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>

               <td width="10%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <xsl:value-of select="@resJuin" />
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <xsl:value-of select="@resJuin" />
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <xsl:value-of select="@resJuin" />
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>

               <td width="5%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <xsl:value-of select="@noteSep" />
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <xsl:value-of select="@noteSep" />
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <xsl:value-of select="@noteSep" />
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>

               <td width="2%">
                  <xsl:choose>
                     <xsl:when test="(@level=1) or (local-name(.) = 'etape')">
                        <font class="uportal-channel-strong">
                           <xsl:value-of select="@resSept" />
                        </font>
                     </xsl:when>

                     <xsl:when test="local-name(.) = 'epreuve'">
                        <font class="uportal-text">
                           <i>
                              <xsl:value-of select="@resSept" />
                           </i>
                        </font>
                     </xsl:when>

                     <xsl:otherwise>
                        <font class="uportal-text">
                           <xsl:value-of select="@resSept" />
                        </font>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </tr>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>

