<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Adresses</td>

            <td width="100%"></td>
         </tr>
      </table>

      <xsl:apply-templates select="xml/adrAnnuelle" />

      <br />

      <xsl:apply-templates select="xml/adrFixe" />
   </xsl:template>

   <xsl:template match="adrAnnuelle">
      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">ADRESSE ANNUELLE</TD>
         </TR>
      </TABLE>

      <xsl:call-template name="adresse" />
   </xsl:template>

   <xsl:template match="adrFixe">
      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">ADRESSE FIXE</TD>
         </TR>
      </TABLE>

      <xsl:call-template name="adresse" />
   </xsl:template>

   <xsl:template name="adresse">
      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" HEIGHT="21" class="uportal-text">Adresse</TD>

            <TD WIDTH="77%" HEIGHT="21" class="uportal-channel-strong">
               <xsl:value-of select="adresse1" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%">
            </TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="adresse2" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Ville</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="ville" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Pays</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="pays" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Téléphone</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="tel" />
            </TD>
         </TR>
      </TABLE>
   </xsl:template>
</xsl:stylesheet>

