<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Calendrier des examens</td>

            <td width="100%">
            </td>
         </tr>
      </table>

      <br />

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="11%" class="uportal-channel-strong">Date 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="9%" class="uportal-channel-strong">Heure 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="9%" class="uportal-channel-strong">Durée 
            <HR ALIGN="left" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="21%" class="uportal-channel-strong">Bâtiment 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="7%" class="uportal-channel-strong">Salle 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="43%" class="uportal-channel-strong">Examen 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>
         </TR>
      </TABLE>

      <xsl:choose>
         <xsl:when test="count(xml/examens/examen) = 0">
            <P ALIGN="CENTER" class="uportal-text">Pas de calendrier disponible</P>
         </xsl:when>

         <xsl:otherwise>
            <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
               <xsl:apply-templates select="xml/examens/examen" />
            </TABLE>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match="examen">
      <TR onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
         <TD WIDTH="11%" class="uportal-text">
            <xsl:value-of select="date" />
         </TD>

         <TD WIDTH="9%" class="uportal-text">
            <xsl:value-of select="heure" />
         </TD>

         <TD WIDTH="9%" class="uportal-text">
            <xsl:value-of select="duree" />
         </TD>

         <TD WIDTH="21%" class="uportal-text">
            <xsl:value-of select="batiment" />
         </TD>

         <TD WIDTH="7%" class="uportal-text">
            <xsl:value-of select="salle" />
         </TD>

         <TD WIDTH="43%" class="uportal-text">
            <xsl:value-of select="epreuve" />
         </TD>
      </TR>
   </xsl:template>
</xsl:stylesheet>

