<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="mediaPath" />
   
   <xsl:param name="servantMailTo" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Etat-civil</td>

            <td width="100%">
            </td>
         </tr>
      </table>

      <xsl:apply-templates select="xml/generalites" />

      <xsl:apply-templates select="xml/naissance" />

      <xsl:apply-templates select="xml/inscrUniv" />

      <xsl:apply-templates select="xml/bacs" />
   </xsl:template>

   <xsl:template match="generalites">
      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD HEIGHT="25" class="uportal-channel-strong">GENERALITES</TD>
         </TR>
      </TABLE>

      <xsl:call-template name="genEtudiant">
         <xsl:with-param name="dossier" select="dossier" />

         <xsl:with-param name="NNE" select="NNE" />

         <xsl:with-param name="nom" select="nom" />

         <xsl:with-param name="prenom" select="prenom" />

         <xsl:with-param name="email" select="email" />
         
         <xsl:with-param name="servantMailTo" select="$servantMailTo" />
         
      </xsl:call-template>
   </xsl:template>

   <xsl:template match="naissance">
      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Nationalité</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="nationalite" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Né(e) le</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="datNaiss" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">A</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="lieu" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Département ou Pays</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="depPays" />
            </TD>
         </TR>
      </TABLE>
   </xsl:template>

   <xsl:template match="inscrUniv">
      <br />

      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD HEIGHT="25" class="uportal-channel-strong">INSCRIPTION UNIVERSITE</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Année</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="annee" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Etablissement</TD>

            <TD WIDTH="77%" class="uportal-channel-strong">
               <xsl:value-of select="etablissement" />
            </TD>
         </TR>
      </TABLE>
   </xsl:template>

   <xsl:template match="bacs">
      <br />

      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD HEIGHT="25" class="uportal-channel-strong">BAC</TD>
         </TR>
      </TABLE>

      <xsl:apply-templates select="bac" />
   </xsl:template>

   <xsl:template match="bac">
      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="23%" class="uportal-text">Bac</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="type" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Obtenu en</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="datObtention" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Mention</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="mention" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Type établissement</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="typEtabliss" />
            </TD>
         </TR>

         <TR>
            <TD WIDTH="23%" class="uportal-text">Etablissement</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="etablissement" />
            </TD>
         </TR>

         <TR>
            <TD WWIDTH="23%" class="uportal-text">Département</TD>

            <TD class="uportal-channel-strong">
               <xsl:value-of select="departement" />
            </TD>
         </TR>
      </TABLE>
   </xsl:template>
</xsl:stylesheet>

