<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
   		 <td nowrap="true" class="uportal-channel-table-header">Inscriptions</td>
   		 <td width="100%">&#160;</td>
   		 </tr>
      </table>		
      

      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">UNIVERSITE NANCY 2</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="14%" class="uportal-channel-strong">Année 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="10%" class="uportal-channel-strong">Code 
            <HR ALIGN="CENTER" SIZE="1" />
            </TD>

            <TD WIDTH="9%" class="uportal-channel-strong">Vers. 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="67%" class="uportal-channel-strong">Etape 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <xsl:apply-templates select="xml/inscriptions/inscription[@id='IAE']" />
      </TABLE>
	  <br/>	
      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">AUTRES CURSUS</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="14%" class="uportal-channel-strong">Année 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="10%" class="uportal-channel-strong">Type 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="16%" class="uportal-channel-strong">Spécialité 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="46%" class="uportal-channel-strong">Etablissement 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>

            <TD WIDTH="14%" class="uportal-channel-strong">Résultat 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NOSHADE" />
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <xsl:apply-templates select="xml/inscriptions/inscription[@id='DAC']" />
      </TABLE>
	  <br/>	
      <xsl:call-template name="premiere" />
   </xsl:template>

   <xsl:template match="inscription">
      <TR onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
         <TD WIDTH="14%" class="uportal-text">
            <xsl:value-of select="annee" />
         </TD>

         <xsl:if test="@id='IAE'">
            <TD WIDTH="10%" class="uportal-text">
               <xsl:value-of select="code" />
            </TD>

            <TD WIDTH="9%" class="uportal-text">
               <xsl:value-of select="vers" />
            </TD>

            <TD WIDTH="67%" class="uportal-text">
               <xsl:value-of select="etape" />
            </TD>
         </xsl:if>

         <xsl:if test="@id='DAC'">
            <TD WIDTH="10%" class="uportal-text">
               <xsl:value-of select="type" />
            </TD>

            <TD WIDTH="16%" class="uportal-text">
               <xsl:value-of select="specialite" />
            </TD>

            <TD WIDTH="46%" class="uportal-text">
               <xsl:value-of select="etablissement" />
            </TD>

            <TD WIDTH="14%" class="uportal-text">
               <xsl:value-of select="resultat" />
            </TD>
         </xsl:if>
      </TR>
   </xsl:template>

   <xsl:template name="premiere">
      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">PREMIERE INSCRIPTION  UNIVERSITE</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <tr>
            <td width="23%" class="uportal-text">Année</td>

            <td width="77%" class="uportal-channel-strong">
               <xsl:value-of select="xml/inscriptions/@anneeDebut" />
            </td>
         </tr>

         <tr>
            <td width="23%" class="uportal-text">Etablissement</td>

            <td width="77%" class="uportal-channel-strong">
               <xsl:value-of select="xml/inscriptions/@etablissementDebut" />
            </td>
         </tr>
      </TABLE>
   </xsl:template>
</xsl:stylesheet>

