<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genEtudiant.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:import href="CodesRes.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="vueEtudiant">none</xsl:param>

   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Résultats</td>

            <td width="100%">
            </td>
         </tr>
      </table>

      <xsl:if test="$modeServant!='none'">
         <div>
            <P class="uportal-text">
               <form name="formVue" action="{$baseActionURL}" method="post">
                  <input type="hidden" name="isProf" value="" />

                  <table>
                     <tr>
                        <td>
                           <input type="checkbox" name="checkVue" onClick="javascript:if (document.formVue.checkVue.checked) document.formVue.isProf.value='N'; else document.formVue.isProf.value='O'; document.formVue.submit();">
                              <xsl:if test="$vueEtudiant != 'none'">
                                 <xsl:attribute name="checked">
                                    <xsl:value-of select="$vueEtudiant" />
                                 </xsl:attribute>
                              </xsl:if>
                           </input>
                        </td>

                        <td class="uportal-text">Voir comme un étudiant</td>
                     </tr>

                     <tr>
                        <td>
                        </td>

                        <td class="uportal-channel-text">Cette option vous permet de vérifier ce que l'étudiant verra lorsqu'il consultera ses résultats</td>
                     </tr>
                  </table>
               </form>
            </P>
         </div>
      </xsl:if>

      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">DIPLOMES</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <tr>
            <td width="13%" class="uportal-channel-strong">Année 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>

            <td width="15%" class="uportal-channel-strong">Code / Vers. 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>

            <td width="30%" class="uportal-channel-strong">Diplôme 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>

            <td width="13%" colspan="2" class="uportal-channel-strong">Session 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>

            <td width="8%" class="uportal-channel-strong">Note 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>

            <td width="8%" class="uportal-channel-strong">Résultat 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>
         </tr>

         <xsl:for-each select="xml/diplome">
            <tr onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
               <td colspan="7">
                  <table border="0" width="100%" CELLPADDING="0" CELLSPACING="0">
                     <tr>
                        <td class="uportal-text" WIDTH="15%">
                           <xsl:value-of select="@annee" />
                        </td>

                        <td class="uportal-text" WIDTH="17%">
                           <xsl:value-of select="@code" />
                        </td>

                        <td class="uportal-text" WIDTH="35%">
                           <xsl:value-of select="@libelle" />
                        </td>

                        <td colspan="3">
                        </td>
                     </tr>

                     <xsl:for-each select="session">
                        <xsl:call-template name="session" />
                     </xsl:for-each>
                  </table>
               </td>
            </tr>
         </xsl:for-each>
      </TABLE>

      <br />

      <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-semidark">
            <TD WIDTH="100%" HEIGHT="25" class="uportal-channel-strong">ETAPES</TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="13%" class="uportal-channel-strong">Année 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="15%" class="uportal-channel-strong">Code / Vers. 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="30%" class="uportal-channel-strong">Etape 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="13%" colspan="2" class="uportal-channel-strong">Session 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <TD WIDTH="8%" class="uportal-channel-strong">Note 
            <HR ALIGN="CENTER" SIZE="1" NOSHADE="NSOSHADE" />
            </TD>

            <td WIDTH="8%" class="uportal-channel-strong">Résultat 
            <hr align="CENTER" size="1" NOSHADE="NSOSHADE" />
            </td>
         </TR>

         <xsl:for-each select="xml/etape">
            <tr onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
               <td colspan="7">
                  <table border="0" width="100%" CELLPADDING="0" CELLSPACING="0">
                     <tr>
                        <td class="uportal-text" WIDTH="15%">
                           <xsl:value-of select="@annee" />
                        </td>

                        <td class="uportal-text" WIDTH="17%">
                           <xsl:choose>
                              <xsl:when test="local-name(.) = 'etape'">
                                 <table>
                                    <tr>
                                       <td valign="absmiddle">
                                          <a href="{$baseActionURL}?action=detailNotes&amp;code={@code}&amp;codeAnnu={@codeAnnu}">
                                             <img alt="Détail des notes" border="0" src="{$mediaPath}/folderopen.gif"/>
                                          </a>
                                       </td>

                                       <td class="uportal-text">
                                          <a href="{$baseActionURL}?action=detailNotes&amp;code={@code}&amp;codeAnnu={@codeAnnu}">
                                             <xsl:value-of select="@code" />
                                          </a>
                                       </td>
                                    </tr>
                                 </table>
                              </xsl:when>

                              <xsl:otherwise>
                                 <xsl:value-of select="@code" />
                              </xsl:otherwise>
                           </xsl:choose>
                        </td>

                        <td class="uportal-text" WIDTH="35%">
                           <xsl:choose>
                              <xsl:when test="local-name(.) = 'etape'">
                                 <a href="{$baseActionURL}?action=detailNotes&amp;code={@code}&amp;codeAnnu={@codeAnnu}">
                                    <xsl:value-of select="@libelle" />
                                 </a>
                              </xsl:when>

                              <xsl:otherwise>
                                 <xsl:value-of select="@libelle" />
                              </xsl:otherwise>
                           </xsl:choose>
                        </td>

                        <td colspan="3">
                        </td>
                     </tr>

                     <xsl:for-each select="session">
                        <xsl:call-template name="session" />
                     </xsl:for-each>
                  </table>
               </td>
            </tr>
         </xsl:for-each>
      </TABLE>

      <br />

      <xsl:call-template name="codesRes" />
   </xsl:template>

   <xsl:template name="session">
      <xsl:if test="(@note != 'null' and @note != ' ') or (@resultat != ' ' and @resultat != 'null')">
         <tr>
            <td class="uportal-text" colspan="3">
            </td>

            <td class="uportal-text" WIDTH="15%">
               <xsl:value-of select="@type" />
            </td>

            <td class="uportal-text" WIDTH="10%">
               <xsl:if test="@note != 'null'">
                  <xsl:value-of select="@note" />
               </xsl:if>
            </td>

            <td class="uportal-text">
               <xsl:if test="@resultat != 'null'">
                  <xsl:value-of select="@resultat" />
               </xsl:if>
            </td>
         </tr>
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>

