package org.esupportail.portal.channels.gestion.CMonDossierWeb;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import org.jasig.portal.utils.XMLEscaper;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;

/**
 * Notes<br>
 * <br>
 * Gestion de l'affichage des notes d'un tudiant <br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.2
 * 
 */
public class Notes extends SubChannel {
	
	//Classe principale de la channel
	private CMonDossierWeb owner;
	// log
	private static final Log log = LogFactory.getLog(Notes.class);
	// indique si la personne connecte est un enseignant
	private String isProf;
	private StringBuffer xml;
	// hashMap des flux xml pour chaque tape (cl = code/Version::anne::vue) 
	private HashMap xmlRES_ELP_EPR;
	// hasMap des flux xml pour chaque diplme (cl = vue)
	private HashMap xmlDiplome;
	// hasMap des flux xml pour chaque tape (cl = vue)
	private HashMap xmlEtape;
	// dernire cl gnre pour les preuves
	private String lastKeyEpreuve;

	/**
	 * Contructeur de la classe
	 * @param main
	 */
	public Notes(MainChannel main) {
		super(main);
		owner = (CMonDossierWeb)main;
	}

	public Boolean setXML() throws FrameWorkException {
		// dans le cas du mode standalone, on consulte en tant qu'tudiant
		if (owner.getStaticData().getParameter("MonDossierWebServantMode") == null)
			isProf = "N";
		// dans le cas du mode servant (si pas "vue Etudiant" coch) 
		else { 
			// on met  jour la vue en fonction du paramtre reu
			if (this.runtimeData.getParameter("isProf") != null)
				isProf = this.runtimeData.getParameter("isProf");
			if (isProf != null && isProf.equals("N")) 
				this.getXSLParameter().put("vueEtudiant","checked");
			else {
				this.getXSLParameter().put("vueEtudiant","none");
				isProf= "O";
			}	
		}
		xml = new StringBuffer(START_XML);
		//xml.append(owner.getXmlEtudiant());
		// cas dtails des preuves
		/*if (this.getRuntimeData().getParameter("code") != null 
				&& this.getRuntimeData().getParameter("codeAnnu") != null) 
		{
			// on passe les paramtres pour que lorsqu'on recharge la page avec "vue tudiante", on repasse dans ce test
			this.getXSLParameter().put("code",this.getRuntimeData().getParameter("code"));
			this.getXSLParameter().put("codeAnnu",this.getRuntimeData().getParameter("codeAnnu"));
			xml.append(getXmlEpreuve());
		}*/
		// cas affichage gnral
		if (owner.getCurrentAction().getName().equals("notes"))
			xml.append(getXmlGeneral());
		else {
			// cas dtails des preuves
			xml.append(getXmlEpreuve());
		}	
		xml.append(END_XML);
		setXML(xml.toString());
		
		return Boolean.TRUE;
	}
	
	/**
	 * Mthode qui retourne les rsultats aux preuves en grant le cache 
	 * @throws FrameWorkException
	 * 
	 */
	private StringBuffer getXmlEpreuve() throws FrameWorkException {
		StringBuffer res = new StringBuffer();
	
		// cration de la hashMap des flux xml pour chaque tape
		if (xmlRES_ELP_EPR == null)
			xmlRES_ELP_EPR = new HashMap();
		// calcul de la cl locale 
		String key = this.getRuntimeData().getParameter("code")+"::"+this.getRuntimeData().getParameter("codeAnnu")+"::"+isProf;
		
		// cration du flux xml
		if (xmlRES_ELP_EPR.get(key) == null) {
			// on tente de rcuprer la dernire version stocke (cas rechargement page)
			if (this.lastKeyEpreuve != null) {
				res.append(xmlRES_ELP_EPR.get(this.lastKeyEpreuve));
				return res;
			}	
			// sinon, calcul du flux
			res.append(getXmlRES_ELP_EPR());
			// pas de rsultat
			if (getXmlRES_ELP_EPR() == null) {
				return null;
			}
			xmlRES_ELP_EPR.put(key,getXmlRES_ELP_EPR());
			// affectation comme dernire cl calcule
			this.lastKeyEpreuve = key;
		}	
		else { // rcupration du xml dj calcul
			log.error("rcupration du xml dj calcul pour les preuves ");
			res.append(xmlRES_ELP_EPR.get(key));
		}
		
		return res;
		
	}
	
	/**
	 * Mthode qui retourne les rsultats aux diplomes et tapes en grant le cache 
	 * 
	 */
	private StringBuffer getXmlGeneral() throws FrameWorkException {
		StringBuffer res = new StringBuffer();
		String key = isProf;
		
		// diplmes 
		if (xmlDiplome == null)
			xmlDiplome = new HashMap();
		if (xmlDiplome.get(key) == null) {
			res.append(getXmlDiplome());
			xmlDiplome.put(key,getXmlDiplome());
		}	
		else {
			//log("rcupration du xml dj calcul pour les diplomes ");
			res.append(xmlDiplome.get(key));
		}
		
		// tapes
		if (xmlEtape == null) 
			xmlEtape = new HashMap();
		if (xmlEtape.get(key) == null) {
			res.append(getXmlEtape());
			xmlEtape.put(key,getXmlEtape());
		}	
		else {
			//log("rcupration du xml dj calcul pour les etapes ");
			res.append(xmlEtape.get(key));
		}
		
		// rinitialisation de la cl pour les preuves
		this.lastKeyEpreuve = null;
		
		return res;
	}
	
	/**
	 * Mthode qui retourne les rsultats aux diplomes sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlDiplome() throws FrameWorkException {
	
		StringBuffer res = new StringBuffer();
		Query qry = null;
		boolean error= false;
	
		if (owner.getCodInd() != null) { // la personne connecte  un cod_ind
			try {
				qry = Config.getInstance().getConnexionDefault();
				// on rcupre les diplmes auquels la personnes est inscrite
				qry.setSql("select distinct r.cod_anu || '/' || to_char(to_number(r.cod_anu)+1) \"ANU\", r.cod_dip || '/' || to_char(r.cod_vrs_vdi) \"VDI\",vdi.lic_vdi,r.cod_anu,r.cod_dip " +
							"from apogee.resultat_vdi r,apogee.version_diplome vdi " +
							"where r.cod_ind = ? " +
							"and (r.not_vdi is not null or r.not_sub_vdi is not null or r.cod_tre is not null) " +
							"and vdi.cod_dip = r.cod_dip " +
							"and vdi.cod_vrs_vdi = r.cod_vrs_vdi " + 
							"order by r.cod_anu desc,r.cod_dip");
				qry.getStmt().setString(1, owner.getCodInd());				
				//LogService.log(LogService.INFO ,"Notes::getXmlDiplome() : cod ind " + cod_ind);
				qry.select();			
				Query qry1 = null;   
				while (qry.getRs().next()){
					res.append("<diplome annee=\"").append(XMLEscaper.escape(qry.getRs().getString("ANU"))).append("\" libelle=\"");
					res.append(XMLEscaper.escape(qry.getRs().getString("LIC_VDI"))).append("\" code=\"").
						append(XMLEscaper.escape(qry.getRs().getString("VDI"))).append("\">");
					try {
						qry1 = Config.getInstance().getConnexionDefault();
						qry1.setSql("select r.cod_ses,decode(decode(?,'O','E',g.eta_avc_vdi),'A',' ',nvl(to_char(r.not_vdi) || " + 
									"decode(NOT_PNT_JUR_VDI,null,null,' (+' || to_char(NOT_PNT_JUR_VDI)|| ')'), " +
									"r.not_sub_vdi)) \"NOTE\", g.cod_adm, decode(decode(?,'O','E',g.eta_avc_vdi),'A',' ',r.cod_tre) \"RES\" " + 
									"from apogee.grp_resultat_vdi g, apogee.resultat_vdi r " +
									"where g.cod_dip = ? and g.cod_anu = ? " +
									"and r.cod_ind = ? " +
									"and   (r.not_vdi is not null or r.not_sub_vdi is not null or r.cod_tre is not null) " +
									"and   g.cod_dip = r.cod_dip " +
									"and   g.cod_vrs_vdi = r.cod_vrs_vdi " + 
									"and   g.cod_ses = r.cod_ses " +
									"and   g.cod_adm = r.cod_adm " +
									"and   g.cod_anu = r.cod_anu");
						qry1.getStmt().setString(1, isProf);			
						qry1.getStmt().setString(2, isProf);										
						qry1.getStmt().setString(3, qry.getRs().getString("COD_DIP"));
						qry1.getStmt().setString(4, qry.getRs().getString("COD_ANU"));
						qry1.getStmt().setString(5, owner.getCodInd());
						qry1.select();
						while (qry1.getRs().next()) {
							if (qry1.getRs().getString("COD_SES").equals("0") || qry1.getRs().getString("COD_SES").equals("1"))
								res.append("<session type=\"Juin\" ");
							else
								res.append("<session type=\"Septembre\" ");	
							res.append("note=\"").append(XMLEscaper.escape(qry1.getRs().getString("NOTE")));	
							res.append("\" resultat=\"").append(XMLEscaper.escape(qry1.getRs().getString("RES")));
							//cas admission / admissibilit pas gr pour l'instant
							if (qry1.getRs().getString("COD_ADM").equals("0"))
								res.append("\" etape=\"Admissibilit\"/>");
							else
								res.append("\" etape=\"\"/>");	
							/*else	
								res += "\" etape=\"Admission\"/>";*/
						}	
					}
					finally {
						qry1.close();
					}
					res.append("</diplome>");
				}
			}
			catch (SQLException e) {
				log.error("Notes::getXmlDiplome() : Erreur SQL " + e);
				error = true;
			}
			catch (Exception e) {
				log.error("Notes::getXmlDiplome() : Erreur " + e);
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		} 

		return res;
	
	}
	
	/**
	 * Mthode qui retourne les rsultats aux tapes sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlEtape() throws FrameWorkException {

		StringBuffer res = new StringBuffer();
		Query qry = null;
		boolean error = false;

		if (owner.getCodInd() != null) { // la personne connecte  un cod_ind
			try {
				qry = Config.getInstance().getConnexionDefault();
				// on rcupre les tapes auquels la personnes est inscrite
				qry.setSql("select distinct ANU, VET,lib_etp,cod_anu,e.cod_etp " +
							" from (select cod_anu || '/' || to_char(to_number(cod_anu)+1) ANU, cod_etp || '/' || " +
							"to_char(cod_vrs_vet) VET,cod_anu,cod_etp " +
							" from ins_adm_etp " +
							" where cod_ind = ? " +
							" and   eta_iae = 'E' " +
							" union " +
							" select cod_anu || '/' || to_char(to_number(cod_anu)+1) ANU, cod_etp || '/' || " +
							"to_char(cod_vrs_vet) VET, cod_anu,cod_etp " +
							" from ins_pedagogi_etp " +
							" where cod_ind = ? ) ins, etape e " +
							" where e.cod_etp = ins.cod_etp " + 
							" order by cod_anu desc, cod_etp ");
				qry.getStmt().setString(1, owner.getCodInd());				
				qry.getStmt().setString(2, owner.getCodInd());				
				qry.select();			
				Query qry1 = null;   
				while (qry.getRs().next()){
					res.append("<etape annee=\"").append(XMLEscaper.escape(qry.getRs().getString("ANU"))).append("\" libelle=\"");
					res.append(XMLEscaper.escape(qry.getRs().getString("LIB_ETP"))).append("\" code=\"").
						append(XMLEscaper.escape(qry.getRs().getString("VET"))).append("\" codeAnnu=\"").
						append(qry.getRs().getString("cod_anu")).append("\">");
					try {
						qry1 = Config.getInstance().getConnexionDefault();
						qry1.setSql("select r.cod_ses,decode(decode(?,'O','E',g.eta_avc_vet),'A',' ',nvl(to_char(r.not_vet) || "+ 
									"decode(NOT_PNT_JUR_VET,null,null,' (+' || to_char(NOT_PNT_JUR_VET)|| ')'), "+ 
									"r.not_sub_vet)) \"NOTE\", "+
									"decode(decode(?,'O','E',g.eta_avc_vet),'A',' ',r.cod_tre) \"RES\",g.cod_adm "+
									"from apogee.resultat_vet r,apogee.grp_resultat_vet g "+ 
									"where r.cod_ind = ? "+
									"and g.cod_etp = ? and g.cod_anu = ? "+
									"and   g.cod_etp = r.cod_etp "+ 
									"and   g.cod_vrs_vet = r.cod_vrs_vet "+ 
									"and   g.cod_ses = r.cod_ses "+
									"and   g.cod_adm = r.cod_adm "+
									"and   g.cod_anu = r.cod_anu");
						qry1.getStmt().setString(1, isProf);			
						qry1.getStmt().setString(2, isProf);
						qry1.getStmt().setString(3, owner.getCodInd());										
						qry1.getStmt().setString(4, qry.getRs().getString("COD_ETP"));
						qry1.getStmt().setString(5, qry.getRs().getString("COD_ANU"));
						
						qry1.select();
						while (qry1.getRs().next()) {
							if (qry1.getRs().getString("COD_SES").equals("0") || qry1.getRs().getString("COD_SES").equals("1"))
								res.append("<session type=\"Session 1\" ");
							else
								res.append("<session type=\"Session 2\" ");	
							res.append("note=\"").append(XMLEscaper.escape(qry1.getRs().getString("NOTE")));
							res.append("\" resultat=\"").append(XMLEscaper.escape(qry1.getRs().getString("RES")));
							// cas admission / admissibilit pas gr pour l'instant
							if (qry1.getRs().getString("COD_ADM").equals("0"))
								res.append("\" etape=\"Admissibilit\"/>");
							else	
								res.append("\" etape=\"\"/>");
						}	
					}
					finally {
						qry1.close();
					}
					res.append("</etape>");
				}
			}
			catch (SQLException e) {
				log.error("Notes::getXmlEtape() : Erreur SQL " + e);
				error = true;
			}
			catch (Exception e) {
				log.error("Notes::getXmlEtape() : Erreur " + e);
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		} 
		
		return res;
	}
	
	
	public StringBuffer getXmlRES_ELP_EPR() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer();
		Query qry = null;
		InscrpNote iNote = null;
		String lib = "";
		boolean error = false;
		
		if (owner.getCodInd() != null) { // la personne connecte  un cod_ind
			try {
				qry = Config.getInstance().getConnexionDefault();
				// on rcupre l'tape pour laquelle il y a des inscriptions pdagogiques (IP) 
				qry.setSql("select i.cod_anu,i.cod_etp,i.cod_vrs_vet,e.lic_etp " + 
							"from apogee.ins_pedagogi_etp i,apogee.etape e where i.cod_ind = ? " +
							"and e.cod_etp = ? " +
							"and i.cod_vrs_vet = ? " +
							"and i.cod_anu = ? " +
							"and e.cod_etp = i.cod_etp  " +
							"order by i.cod_anu desc,i.cod_etp,i.cod_vrs_vet");
				qry.getStmt().setString(1, owner.getCodInd());
				// rcupration du cod_etp slectionn
				String form_cod_etp = this.getRuntimeData().getParameter("code");
				int pos = form_cod_etp.indexOf("/");
				String cod_etp = form_cod_etp.substring(0,pos);
				qry.getStmt().setString(2, cod_etp);
				String cod_vrs_vet = form_cod_etp.substring(pos+1,form_cod_etp.length());
				qry.getStmt().setString(3, cod_vrs_vet);
				qry.getStmt().setString(4, this.getRuntimeData().getParameter("codeAnnu"));
				qry.select();
				while (qry.getRs().next()){
					iNote = new InscrpNote(qry.getRs().getString("COD_ANU"),
								qry.getRs().getString("COD_ETP"),qry.getRs().getString("COD_VRS_VET"),
								qry.getRs().getString("LIC_ETP"),0,"VET");
					Get_Note_Res(iNote,"1",null);
					Get_Note_Res(iNote,"2",null);	
					if (iNote.getNote1().equals(""))
							Get_Note_Res(iNote,"0",null);								
				}
				// pas de rsultat
				if (iNote == null) {
					return null;
				}
				// gnration du xml pour l'tape
			 	res.append("<etape annee=\"").append(iNote.getAnnee()).append("\" libelle=\"").append(iNote.getLib()).append("\" ");
			 	res.append("code=\"").append(iNote.getCode()).append("\" noteJuin=\"").append(iNote.getNote1()).append("\" ");
			 	res.append("resJuin=\"").append(iNote.getRes1()).append("\" noteSep=\"").append(iNote.getNote2()).append("\" resSept=\"").append(iNote.getRes2()).
					append("\">");
			 	
				// Dtail des IP pour une VET donne
				qry.setSql("select level,cod_elp,cod_anu,tem_prc_ice,COD_LCC_ICE " +
   	   					   "FROM APOGEE.IND_CONTRAT_ELP CONNECT BY prior COD_ELP = COD_ELP_SUP " +
   	   					   " AND COD_ANU= ? " + 
					   	   " AND COD_IND= ? " + 
					   	   " AND COD_ETP= ? " +
					   	   " AND COD_VRS_VET= ? " +
					   	   " START WITH COD_ELP_SUP IS NULL " +
					   	   " AND COD_ANU= ? " +
					   	   " AND COD_IND= ?" + 
					   	   " AND COD_ETP= ? " + 
						   " order siblings by COD_ELP");
				qry.getStmt().setString(1,iNote.getAnnee());
				qry.getStmt().setString(2, owner.getCodInd());
				qry.getStmt().setString(3, iNote.getCode());
				qry.getStmt().setString(4, iNote.getVersion());
				qry.getStmt().setString(5,iNote.getAnnee());
				qry.getStmt().setString(6, owner.getCodInd());
				qry.getStmt().setString(7, iNote.getCode());
				qry.select();
				Query qry1 = null;
				try {
					qry1 = Config.getInstance().getConnexionDefault();
					while (qry.getRs().next()){
						InscrpNote iNote1 = new InscrpNote();
						qry1.setSql("select decode(cod_nel,'FICM','FICM',lib_elp) \"LIB\"" +
									" from apogee.element_pedagogi" +
									" where cod_elp = ? ");
						qry1.getStmt().setString(1,qry.getRs().getString("COD_ELP"));
						qry1.select();
						while (qry1.getRs().next()){
							lib = qry1.getRs().getString("LIB");	
						}
									
						if (qry.getRs().getString("TEM_PRC_ICE").equals("N")) {
							iNote1.setAnnee(qry.getRs().getString("COD_ANU"));
						}
						else {	
							// Tmoin PRC coch
							// si lien de correspondance
							if (qry.getRs().getString("COD_LCC_ICE") != null) {
								iNote1.setRes1("ADM");
								iNote1.setNote1("COR");
							} 
							else {	
								// Recherche note antrieure
								qry1.setSql("select max(cod_anu) \"COD_ANU\"" +
											" from apogee.resultat_elp" +
								 			" where cod_ind = ? " +
								 			" and   cod_elp = ? " +
								 			" and   cod_anu < ? " +
								 			" and   (not_elp is not null or not_sub_elp is not null " +
								 			" or cod_tre is not null)");
								qry1.getStmt().setString(1, owner.getCodInd()); 			
								qry1.getStmt().setString(2, qry.getRs().getString("COD_ELP"));
								qry1.getStmt().setString(3, qry.getRs().getString("COD_ANU"));
								qry1.select();
								Query qry2 = Config.getInstance().getConnexionDefault();
								while (qry1.getRs().next()){
									if (qry1.getRs().getString("COD_ANU") != null)
										iNote1.setAnnee(qry1.getRs().getString("COD_ANU"));
									else {
										try {
											qry2.setSql("select cod_anu from apogee.ind_dispense_elp " +
														" where cod_ind = ? " +
														" and cod_elp = ? " +
														" and cod_anu <= ? ");
											qry2.getStmt().setString(1, owner.getCodInd()); 			
											qry2.getStmt().setString(2, qry.getRs().getString("COD_ELP"));
											qry2.getStmt().setString(3, qry.getRs().getString("COD_ANU"));
											qry2.select();
											while (qry2.getRs().next()){
												if (qry2.getRs().getString("COD_ANU") != null) {
													iNote1.setAnnee(qry2.getRs().getString("COD_ANU"));
													iNote1.setNote1("VAC");
												}
											}	
										}
										finally {
											qry2.close();	
										}					
									}
								}
							}
						}
						iNote1.setCode(qry.getRs().getString("COD_ELP"));
						iNote1.setLevel(qry.getRs().getInt("LEVEL"));
						iNote1.setType("ELP");
						iNote1.setLib(lib);
						Get_Note_Res(iNote1,"1",iNote);
						Get_Note_Res(iNote1,"2",iNote);
						//LogService.log(LogService.INFO ,"iNote1.getNote1() " + iNote1.getNote1());
						if (iNote1.getNote1().equals("")) {
							Get_Note_Res(iNote1,"0",iNote);
						}
						
						// on affiche pas les lments FICM
						if (!lib.equals("FICM"))
							res.append("<element libelle=\"").append(XMLEscaper.escape(lib)).append("\" code=\"").
								append(qry.getRs().getString("COD_ELP")).append("\" noteJuin=\"").append(iNote1.getNote1()).
								append("\" resJuin=\"").append(iNote1.getRes1()).append("\" noteSep=\"").append(iNote1.getNote2()).
								append("\" resSept=\"").append(iNote1.getRes2()).append("\" level=\"").append(qry.getRs().getString("LEVEL")).
								append("\">");
						// Dtail des preuves pour un lment
						qry1.setSql("select r.cod_epr, cod_anu,e.lib_epr,r.cod_ses, " +
									"decode(decode(?,'O','N',e.tem_ctl_val_cad_epr),'N'," +
									"nvl(to_char(r.not_epr),r.not_sub_epr),' ') \"NOTE\" "+
									" from apogee.resultat_epr r,apogee.epr_sanctionne_elp ese,apogee.epreuve e " +
									" where ese.cod_elp = ? " +
									" and   ese.cod_ses = r.cod_ses " +
									" and   ese.tem_sus_epr_ses = 'N' " +
									" and   r.cod_ind = ? " +
									" and   r.cod_epr = ese.cod_epr " +
									" and   r.cod_anu = ? " +
									" and   (r.not_epr is not null or r.not_sub_epr is not null)" +
									" and   TEM_IND_CRN_EPR = 'CS' and e.cod_epr = r.cod_epr" +
 									" order by r.cod_epr,r.cod_ses");
						qry1.getStmt().setString(1, isProf); 			
						qry1.getStmt().setString(2, qry.getRs().getString("COD_ELP"));
						qry1.getStmt().setString(3, owner.getCodInd());
						qry1.getStmt().setString(4, qry.getRs().getString("COD_ANU"));
						qry1.select();		 	
						
						String old_COD_EPR = "";
						while (qry1.getRs().next()){
							InscrpNote iNote2 = new InscrpNote();
							// cas o la ligne rcupre correspond  une nouvelle preuve
							// car 2 lignes retournes si rsultat de juin et rsultat de septembre
							if (!old_COD_EPR.equals(qry1.getRs().getString("COD_EPR"))) {
								// on ferme la balise epreuve s'il y a lieu en mettant l'attribut noteSep pour les tests en XSL
								if (!old_COD_EPR.equals("") && !res.toString().endsWith("/>")) {
									res.append(" noteSep=\"\"/>");
								}	
								old_COD_EPR = qry1.getRs().getString("COD_EPR");
								iNote2.setCode(qry1.getRs().getString("COD_EPR"));
								iNote2.setLevel(qry.getRs().getInt("LEVEL")+1);
								iNote2.setType("EPR");
								iNote2.setAnnee(qry1.getRs().getString("COD_ANU"));
								Query qry2 = Config.getInstance().getConnexionDefault();
								try {
									qry2.setSql("select lib_epr from apogee.epreuve where cod_epr = ? ") ;
									qry2.getStmt().setString(1,qry1.getRs().getString("COD_EPR"));
									qry2.select();
									while (qry2.getRs().next()){
										iNote2.setLib(qry2.getRs().getString("LIB_EPR"));
									}				
								}
								finally {
									qry2.close();	
								}
								res.append("<epreuve libelle=\"").append(XMLEscaper.escape(iNote2.getLib())).
									append("\" code=\"").append(iNote2.getCode()).append("\" ");
							}
							
							if (qry1.getRs().getInt("COD_SES") < 2) {
								iNote2.setNote1(qry1.getRs().getString("NOTE"));
								res.append(" noteJuin=\"").append(iNote2.getNote1()).append("\" level=\"").append(iNote2.getLevel()).append("\"");
							} else {
								iNote2.setNote2(qry1.getRs().getString("NOTE"));
								res.append(" noteSep=\"").append(iNote2.getNote2()).append("\"/>");
							}
						}
						// on ferme s'il y a lieu la dernire preuve rcupre
						if (!old_COD_EPR.equals("") && !res.toString().endsWith("/>"))
							res.append(" noteSep=\"\" />");
						// on affiche pas les lments FICM
						if (!lib.equals("FICM"))
							res.append("</element>");
					}		
				}	
				finally {
					qry1.close();
				}
				res.append("</etape>");
			}
			catch (SQLException e) {
				log.error("Notes::getXmlRES_ELP_EPR() : Erreur SQL " + e);
				error = true;
			}
			catch (Exception e) {
				log.error("Notes::getXmlRES_ELP_EPR() : Erreur " + e);
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		} 

		return res;

	}
	
	/*
	 * Rcupration d'une note/rsultat pour un objet, une anne et une session donns
	 * 
	 */
	private void Get_Note_Res(InscrpNote iNote,String session, InscrpNote iNotePere) throws FrameWorkException {
		char type = ' ';
		Query qry = null;
		boolean error = false;
		
		if (!iNote.getNote1().equals("") && session.equals("1")) 
			return;
		 	
		if (iNote.getType().equals("VET"))
			type = 'V';
		else if (iNote.getType().equals("ELP"))
			type = 'E';	
		switch (type) {
			case 'V' :
				try {
					qry = Config.getInstance().getConnexionDefault();
					qry.setSql("select decode(decode(?,'O','E',g.eta_avc_vet),'A',' ',nvl(to_char(r.not_vet) ||" +
				 				"decode(NOT_PNT_JUR_Vet,null,null,' (+' || to_char(NOT_PNT_JUR_VET) || ')')," +
							 	"r.not_sub_vet)) \"NOTE\"," +
							 	"decode(decode(?,'O','E',g.eta_avc_vet),'A',' ',r.cod_tre) \"RES\""+
				 				" from apogee.resultat_vet r,apogee.grp_resultat_vet g " +
								" where r.cod_ind = ? " +
							 	" and   r.cod_anu = ? " +
							 	" and   r.cod_etp = ? " +
							 	" and   r.cod_vrs_vet = ? " +
							 	" and   r.cod_ses =  ? " +
							 	" and   (r.not_vet is not null or r.not_sub_vet is not null or r.cod_tre is not null) " +
							 	" and   g.cod_etp = r.cod_etp and   g.cod_vrs_vet = r.cod_vrs_vet" +
							 	" and   g.cod_ses = r.cod_ses and   g.cod_adm = r.cod_adm" +
							 	" and   g.cod_anu = r.cod_anu");
					qry.getStmt().setString(1, isProf);
					qry.getStmt().setString(2, isProf);
					qry.getStmt().setString(3, owner.getCodInd());
					qry.getStmt().setString(4, iNote.getAnnee());
					qry.getStmt().setString(5, iNote.getCode());
					qry.getStmt().setString(6, iNote.getVersion());
					qry.getStmt().setString(7, session);
					qry.select();
					if (qry.getRs() != null) {
						while (qry.getRs().next()){	
							if (!session.equals("2")) {
								iNote.setNote1(qry.getRs().getString("NOTE"));
								iNote.setRes1(qry.getRs().getString("RES"));
							}
							else {
								iNote.setNote2(qry.getRs().getString("NOTE"));
								iNote.setRes2(qry.getRs().getString("RES"));
							}
						}
					}
				}
				catch (SQLException e) {
					log.error("Notes::Get_Note_Res() : Erreur SQL " + e);
					error = true;
				}
				catch (Exception e) {
					log.error("Notes::Get_Note_Res() : Erreur " + e);
					error = true;
				}
				finally {
					qry.close();
					if (error)
						throw new FrameWorkException();
				}	
				break;
       	
			case 'E' :
				int vac = 0;
				try {
					qry = Config.getInstance().getConnexionDefault();
					if (iNote.getAnnee() != null && !iNote.getAnnee().equals("")) {
						qry.setSql("select decode(decode(?,'O','E',g.eta_avc_elp),'A',' ',nvl(to_char(r.not_elp) ||" +
						 			"decode(NOT_PNT_JUR_ELP,null,null,' (+' || to_char(NOT_PNT_JUR_ELP) || ')')," +
									"nvl(r.not_sub_elp,' '))) \"NOTE\",r.cod_anu," +
									"decode(decode(?,'O','E',g.eta_avc_elp),'A',' ',nvl(r.cod_tre,' ')) \"RES\"" +
									" from apogee.resultat_elp r,apogee.grp_resultat_elp g "+
									" where r.cod_ind = ? " + 
						 			" and   r.cod_anu = ? " +
									" and   r.tem_ind_crn_elp = 'CS' " +
									" and   r.tem_not_rpt_elp = 'N' " +
									" and   r.cod_elp = ? " +
									" and   r.cod_ses = ? " + 
									" and   (r.not_elp is not null or r.not_sub_elp is not null or r.cod_tre is not null) " +
									" and   g.cod_elp = r.cod_elp and   g.cod_ses = r.cod_ses " +
									" and   g.cod_adm = r.cod_adm and   g.cod_anu = r.cod_anu");
						qry.getStmt().setString(1, isProf);
						qry.getStmt().setString(2, isProf);
						qry.getStmt().setString(3, owner.getCodInd());
						qry.getStmt().setString(4, iNote.getAnnee());
						qry.getStmt().setString(5, iNote.getCode());
						qry.getStmt().setString(6, session);					
					}		
					else { // Recherche VAC
						if (iNotePere == null) {
							qry.setSql("select 'VAC' \"NOTE\",' ' \"RES\",cod_anu" +
									   " from apogee.ind_dispense_elp" +
									   " where cod_ind = ? " +
								   	   " and   cod_elp = ? ");
							qry.getStmt().setString(1, owner.getCodInd());
							qry.getStmt().setString(2, iNote.getCode());
						}		   	   
						else {
							qry.setSql("select 'VAC' \"NOTE\",' ' \"RES\",cod_anu" +
									   " from apogee.ind_dispense_elp" +
									   " where cod_ind = ? " +
									   " and   cod_elp = ? " +	   	   
								   	   " and   cod_etp = ? " +
								       " and   cod_vrs_vet = ? ");
							qry.getStmt().setString(1, owner.getCodInd());
							qry.getStmt().setString(2, iNote.getCode());
							qry.getStmt().setString(3, iNotePere.getCode());	        
							qry.getStmt().setString(4, iNotePere.getVersion());
						}
						vac = 1;
					}
					qry.select();
					while (qry.getRs().next()){
						if (vac == 1)
							iNote.setAnnee(qry.getRs().getString("COD_ANU"));
						if (!session.equals("2")) {
							iNote.setNote1(qry.getRs().getString("NOTE"));
							iNote.setRes1(qry.getRs().getString("RES"));
						} 
						else {
							iNote.setNote2(qry.getRs().getString("NOTE"));
							iNote.setRes2(qry.getRs().getString("RES"));
						}		
					}	
				}
				catch (SQLException e) {
					log.error("Notes::Get_Note_Res() : Erreur SQL " + e);
					error = true;
				}
				catch (Exception e) {
					log.error("Notes::Get_Note_Res() : Erreur " + e);
					error = true;
				}
				finally {
					qry.close();
					if (error)
						throw new FrameWorkException();	
				}
				break;					
		}
	}
	
}

class InscrpNote {
	private String annee;
	private String code;
	private String version;
	private String lib;
	private int level;
	private	String type;
	private String note1;
	private String res1;
	private String note2;
	private String res2;
	
	public InscrpNote() {
	}	
	
	public InscrpNote(String annee, String code, String version, String lib, int level, String type) {
		this.annee = annee;
		this.code = code;
		this.version = version;
		this.lib = lib;
		this.level = level;
		this.type = type;
	}	
	
	/**
	 * @return
	 */
	public String getAnnee() {
		return annee;
	}

	/**
	 * @return
	 */
	public String getCode() {
		return code;
	}

	/**
	 * @return
	 */
	public int getLevel() {
		return level;
	}

	/**
	 * @return
	 */
	public String getLib() {
		return lib;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @return
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param string
	 */
	public void setAnnee(String string) {
		annee = string;
	}

	/**
	 * @param string
	 */
	public void setCode(String string) {
		code = string;
	}

	/**
	 * @param string
	 */
	public void setLevel(int level) {
		this.level = level;
	}

	/**
	 * @param string
	 */
	public void setLib(String string) {
		lib = string;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * @param string
	 */
	public void setVersion(String string) {
		version = string;
	}

	/**
	 * @return
	 */
	public String getNote1() {
		if (note1 == null)
			return "";
		return note1;
	}

	/**
	 * @return
	 */
	public String getNote2() {
		if (note2 == null)
			return "";
		return note2;
	}

	/**
	 * @return
	 */
	public String getRes1() {
		if (res1 == null)
			return "";
		return res1;
	}

	/**
	 * @return
	 */
	public String getRes2() {
		if (res2 == null)
			return "";
		return res2;
	}

	/**
	 * @param string
	 */
	public void setNote1(String string) {
		note1 = string;
	}

	/**
	 * @param string
	 */
	public void setNote2(String string) {
		note2 = string;
	}

	/**
	 * @param string
	 */
	public void setRes1(String string) {
		res1 = string;
	}

	/**
	 * @param string
	 */
	public void setRes2(String string) {
		res2 = string;
	}
	
}	

