<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:template name="genEtudiant">
      <xsl:param name="dossier" />

      <xsl:param name="NNE" />

      <xsl:param name="nom" />

      <xsl:param name="prenom" />

      <xsl:param name="email" />

      <xsl:param name="servantMailTo" />

      <table border="0" cellpadding="2" cellspacing="0" width="100%">
         <tr>
            <td width="23%" class="uportal-text">Dossier</td>

            <td width="77%" class="uportal-channel-strong">
               <xsl:value-of select="$dossier" />
            </td>
         </tr>

         <tr>
            <td width="23%" class="uportal-text">NNE</td>

            <td width="77%" class="uportal-channel-strong">
               <xsl:value-of select="$NNE" />
            </td>
         </tr>

         <tr>
            <td width="23%" class="uportal-text">Nom</td>

            <td width="77%">
               <table border="0" cellspacing="0" cellpadding="0">
                  <tr>
                     <td class="uportal-channel-strong">
                        <xsl:value-of select="$nom" />
                     </td>

                     <td width="5">
                     </td>

                     <td class="uportal-channel-strong">
                        <xsl:value-of select="$prenom" />
                     </td>
                  </tr>
               </table>
            </td>
         </tr>

         <xsl:if test="$email!=''">
            <tr>
               <td width="23%" class="uportal-text">Email</td>

               <td width="77%" class="uportal-channel-strong">
                  <xsl:choose>
                     <xsl:when test="$servantMailTo='1'">
                        <a href="{$baseActionURL}?action=sendMail">
                           <xsl:value-of select="$email" />
                        </a>
                     </xsl:when>

                     <xsl:otherwise>
                        <a href="mailto:{$email}">
                           <xsl:value-of select="$email" />
                        </a>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </tr>
         </xsl:if>
      </table>
   </xsl:template>
</xsl:stylesheet>

