package org.esupportail.portal.channels.gestion.CMonDossierWeb;

import java.io.IOException;
import org.esupportail.portal.utils.channels.ConfigChannel;

/**
 * 
 * <p>ConfigChannel</p>
 * <p>Classe permettant d'accder  la configuration de la channel CMonDossierWeb</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.1
 *
 */
public class Config extends ConfigChannel
{ 
	//dclaration des variables de la classe
	private static Config singleton = null;
	// info pour la partie adresse
	private String COD_ANU_INS;
	// classe implmentant la rcupration de l'adresse mail d'un tudiant
	private String classMail;
	// extension des adresses mail tudiantes
	private String extMail;
	// adresse du contact
	private String adrContact;
	//message d'interdiction
	private String msgInterdit;

	/**
	* 
	* @return ConfigChannel Instance
	* @throws IOException
	* @throws JspException
	*/
	public static Config getInstance() {
	if(singleton == null) {
		 singleton = new Config();
		 }
	return singleton;
	}

	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {
		dig.addCallMethod("config","addRoot",2);
		dig.addCallParam("config/COD_ANU_INS",0);
		dig.addCallParam("config/msgInterdit",1);
		// Mail 
		dig.addCallMethod("config/studentMail","addMail",2);
		dig.addCallParam("config/studentMail/classMail",0);
		dig.addCallParam("config/studentMail/extMail",1);
		// Contact
		dig.addCallMethod("config/lienContact","addLienContact",1);
	    dig.addCallParam("config/lienContact",0,"value");
	}

	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.ConfigChannel#getConfigFile()
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CMonDossierWeb/CMonDossierWeb.xml";
	}
	
	/**
	* 
	* @param COD_ANU_INS Parameter of file CMonDossierWeb.xml
	* @param msgInterdit Parameter of file CMonDossierWeb.xml
	* 
	*/
	public void addRoot(String COD_ANU_INS, String msgInterdit){
		this.COD_ANU_INS = COD_ANU_INS;
		this.msgInterdit = msgInterdit;
	}

	/**
	 * 
	 * @param classMail Parameter of file CMonDossierWeb.xml
	 * @param extMail Parameter of file CMonDossierWeb.xml
	 */
	public void addMail(String classMail, String extMail) {
		this.classMail = classMail;
		this.extMail = extMail;
	}
	
	public void addLienContact(String value){
			this.adrContact = value;
	}

	
	/**
	 * @return
	 */
	public String getCOD_ANU_INS() {
		return COD_ANU_INS;
	}

	/**
	 * @param string
	 */
	public void setCOD_ANU_INS(String string) {
		COD_ANU_INS = string;
	}

	/**
	 * @return Returns the extMail.
	 */
	public String getExtMail() {
		return extMail;
	}
	/**
	 * @param extMail The extMail to set.
	 */
	public void setExtMail(String extMail) {
		this.extMail = extMail;
	}
	
	/**
	 * @return Returns the msgInterdit.
	 */
	public String getMsgInterdit() {
		return msgInterdit;
	}
	/**
	 * @param msgInterdit The msgInterdit to set.
	 */
	public void setMsgInterdit(String msgInterdit) {
		this.msgInterdit = msgInterdit;
	}
	
	/**
	 * @return Returns the classMail.
	 */
	public String getClassMail() {
		return classMail;
	}
	
	/**
	 * @param classMail The classMail to set.
	 */
	public void setClassMail(String classMail) {
		this.classMail = classMail;
	}
	/**
	 * @return Returns the adrContact.
	 */
	public String getAdrContact() {
		return adrContact;
	}
}

