package org.esupportail.portal.channels.gestion.CMonDossierWeb;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.connectors.ApogeeConnector;
import org.esupportail.portal.utils.connectors.ConnectorException;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.XMLEscaper;
import org.xml.sax.ContentHandler;
import org.esupportail.portal.utils.channels.plugins.FatalError;

/**
 * 
 * <p>CMonDossierWeb</p>
 * <p>Description : Mon dossier Web : consultation des rsultats des tudiants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.2
 *
 */
public class CMonDossierWeb extends MainChannel {
	
	// log
	private static final Log log = LogFactory.getLog(CMonDossierWeb.class);
	// id de l'utilisateur
	private String userId;
	// cod_ind de l'utilisateur
	protected String cod_ind;
	// flux xml correspondant  l'en-tte des diffrentes pages
	private String xmlEtudiant;
	// login de la personne traite
	protected String loginEtu;
	// objet permettant de construire les adresses mail des tudiants
	protected IMail mailObj;
	
	// servant mailTo
	private final static String toField ="to";//Mail.TO : pour viter la dpendence on n'utilise pas la constante
	private final static String ccField ="cc";//Mail.CC : pour viter la dpendence on n'utilise pas la constante
	private final static String bccField ="bcc";//Mail.BCC : pour viter la dpendence on n'utilise pas la constante
	
	public CMonDossierWeb() throws PortalException {
		setConfigActions(Config.getInstance());	
	}
	
	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 * @throws PortalException
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		super.setStaticData(sd);
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		cod_ind = getCodInd();
		loginEtu = getLoginEtu();
		// instanciation de la classe grant les mails tudiants
		try {
			Class MailClass = Class.forName(SubChannel.getPackageName(this.getClass()) + "." + Config.getInstance().getClassMail());
			mailObj = (IMail) MailClass.newInstance();
		}
		catch (Exception e) {
			log.error("CMonDossierWeb::setStaticData() : Erreur " + e);
		}
	}
	
	public void setRuntimeData(ChannelRuntimeData rd) throws PortalException  {
		// gestion du back navigateur pour le servant CMailToServantFinished
		if (rd.getParameter("action") != null && !rd.getParameter("action").equals("sendMail")
			&& currentAction != null && currentAction.getName().equals("sendMail")) {
			rd.setParameter("CMailToServantFinished","1");
			currentAction.setServantfinish(rd.getParameter("action"));
		}
		if (rd.getParameter("action") != null && rd.getParameter("action").equals("sendMail")) {	
			// Destinataire du canal MailTo
			String[] att = new String[3];
			// la scolarit dans le cas du lien "Nous contacter"
			if (runtimeData.getParameter("dest") != null && runtimeData.getParameter("dest").equals("scolarite")) 
				att[0] = Config.getInstance().getAdrContact();
	        else // le titulaire du dossier consult dans le cas du lien sur le mail
				att[0] = mailObj.getMail(loginEtu);
	        att[1] = "false";
	        att[2] = "true";
	        runtimeData.setParameterValues(toField,att);
		}
		super.setRuntimeData(rd);
	}
  
	/**
	 * @return
	 */
	public String getUserId() {
		return userId;
	}
	
	/**
	 * Rcupration du cod_ind 
	 * 
	 */
	public String getCodInd() {
		if (cod_ind == null) {
			// on rcupre le cod_ind via le connecteur Apogee
			try {
				cod_ind = ApogeeConnector.getCOD_IND(getStaticData().getPerson());
				// pour test 
				// cod_ind = "29701020"; // V. Jeannot pour VAC
			} 
			catch (ConnectorException e1) {
				// enregistrement plugin fatalError
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				return null;
			}
		}
		return cod_ind;
	}
	
	
	/**
	 * Mthode qui retourne les infos principales d'un tudiant sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlEtudiant() throws FrameWorkException {
		Query qry = null;
		boolean error = false;
		StringBuffer res = null;
		if (xmlEtudiant == null) {
			res = new StringBuffer("<etudiant>");
			//	Connexion  la base et excution d'une requte
			try {
				// on rcupre le cod_ind via le connecteur Apogee
				cod_ind = getCodInd(); 
				if (cod_ind != null) { // la personne connecte  un cod_ind
					qry = Config.getInstance().getConnexionDefault();
					qry.setSql("select i.cod_etu,i.cod_nne_ind,i.cod_cle_nne_ind,i.lib_nom_pat_ind,i.lib_pr1_ind," +
									 "i.daa_ent_etb, i.cod_etb " +
									 " from apogee.individu i " +
									 " where i.cod_ind = ? ");
					qry.getStmt().setString(1, cod_ind);				
					qry.select();			   
					while (qry.getRs().next()){
						res.append("<dossier>").append(XMLEscaper.escape(qry.getRs().getString("cod_etu"))).append("</dossier>").
							append("<NNE>").
							append(qry.getRs().getString("cod_nne_ind")).append(qry.getRs().getString("cod_cle_nne_ind")).
							append("</NNE>").
							append("<nom>").append(XMLEscaper.escape(qry.getRs().getString("lib_nom_pat_ind"))).append("</nom>").
							append("<prenom>").append(XMLEscaper.escape(qry.getRs().getString("lib_pr1_ind"))).append("</prenom>").
							append("<email>");
						if (getMailObj() != null)
							res.append(XMLEscaper.escape(mailObj.getMail(loginEtu)));
						res.append("</email>");
					}
				}
			} 
			catch (SQLException e) {
				log.error("CMonDossierWeb::getXmlEtudiant() : Erreur SQL " + e);
				error = true;
			}
			catch (Exception e) {
				log.error("CMonDossierWeb::getXmlEtudiant() : Erreur " + e);
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
			res.append("</etudiant>");
		}
		return res;
	}
	
	/** 
	 *  Initialise les static et les runtime data pour le servant
	 *  @param <b>IServant</b> servant servant  instancier
	 */
	public void initServant(IServant servant) throws PortalException {
		// Servant Envoi de mails
		// Destinataire
		String[] att = new String[3];
		// la scolarit dans le cas du lien "Nous contacter"
		if (runtimeData.getParameter("dest") != null && runtimeData.getParameter("dest").equals("scolarite")) 
			att[0] = Config.getInstance().getAdrContact();
        else // le titulaire du dossier consult dans le cas du lien sur le mail
			att[0] = mailObj.getMail(loginEtu);
        att[1] = "false";
        att[2] = "true";
        runtimeData.setParameterValues(toField,att);
        // Les champs copies sont dsactivs
        att = new String[3];
        att[0] = "";
        att[1] = "false";
        att[2] = "false";
        runtimeData.setParameterValues(ccField,att);
        att = new String[3];
        att[0] = "";
        att[1] = "false";
        att[2] = "false";
        runtimeData.setParameterValues(bccField,att);
        // on fixe dynamiquement l'action de retour en fonction de l'action appelante
        this.currentAction.setServantfinish(this.previousAction.getName()); 
		super.initServant(servant);
	}
		
	public void renderXML(ContentHandler out) throws PortalException {
		// on passe  toutes les subchannel non servant le fait qu'on utilise ou pas le lien "Nous contacter"
		if (!currentAction.isServant() && Config.getInstance().getAdrContact() != null) 
			currentSubChannel.getXSLParameter().put("contact",Config.getInstance().getAdrContact());
		if (this.getAction("sendMail") != null)
			currentSubChannel.getXSLParameter().put("servantMailTo","1");
		super.renderXML(out);
	}	
	
	/**
	 * @return Returns the loginEtu.
	 */
	public String getLoginEtu() {
		if (loginEtu == null)
			loginEtu = userId;
		return loginEtu;
	}
	
	/**
	 * @return Returns the mailObj.
	 */
	public IMail getMailObj() {
		return mailObj;
	}
	/**
	 * @param mailObj The mailObj to set.
	 */
	public void setMailObj(IMail mailObj) {
		this.mailObj = mailObj;
	}
}
