package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.channels.plugins.RestrictedAction;

/**
 * 
 * <p>CMonDossierWebEns</p>
 * <p>Description : Mon dossier Web : consultation des rsultats des tudiants par les enseignants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class CMonDossierWebEns extends MainChannel {
	
	// id de l'utilisateur
	private String userId;	
	// code de l'tudiant trait
	private String cod_ind;
	// login de la personne traite
	private String loginEtu;
	// anne utilise pour les requtes
	private String annee;
	// niveau slectionn pour les listes (Composante/Diplome/Etape/Element)
	private String niveau;

	public CMonDossierWebEns() throws PortalException {
		setConfigActions(Config.getInstance());	
	}
	
	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		staticData = sd;
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		// test d'accs au canal
		try {
			if (!RestrictedAction.filterAccess(this,"default",Config.getInstance().getGroupmapping(),false)){
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				log("acces refuse");
			}
		} catch (PortalException e) {
			log("CMonDossierWebEns::setStaticData: Erreur Contrle d'accs " + e);
		} catch (FrameWorkException e) {
			log("CMonDossierWebEns::setStaticData: Erreur Contrle d'accs " + e);
		}
	}
		
	/**
	 * @return
	 */
	public String getUserId() {
		return userId;
	}
	
	/** 
	 *  Initialise les static et les runtime data pour le servant
	 *  @param <b>IServant</b> servant servant  instancier
	 */
	public void initServant(IServant servant) throws PortalException {
		// servant Annuaire
		if (getActionParam("servantAnnuaire","name") != null)
			staticData.setParameter("serverView", getActionParam("servantAnnuaire","name").getValue()); 
		if (getActionParam("servantAnnuaire","type") != null)
			staticData.setParameter("returnServant",getActionParam("servantAnnuaire","type").getValue());
		if (getActionParam("servantAnnuaire","displayFiche") != null)
			staticData.setParameter("affFiche",getActionParam("servantAnnuaire","displayFiche").getValue());
		// servant MonDossierWeb
		if (this.currentAction.getName().equals("servantMonDossierWeb") || this.currentAction.getName().equals("servantMonDossierWebListe")) {
			staticData.setParameter("cod_ind",cod_ind);
			staticData.setParameter("loginEtu",loginEtu);
		}
		// servant RechercheApogee
		if (this.currentAction.getName().equals("servantRechercheApogee")) {
			if (annee != null) {
				staticData.setParameter("annee",annee);
			}	
			if (niveau != null) {
				staticData.setParameter("niveau",niveau);
			}
		}
		super.initServant(servant);
	}
	
	/**
	 * @return Returns the cod_ind.
	 */
	public String getCod_ind() {
		return cod_ind;
	}
	
	/**
	 * @param cod_ind The cod_ind to set.
	 */
	public void setCod_ind(String cod_ind) {
		this.cod_ind = cod_ind;
	}
	
	/**
	 * @return Returns the loginEtu.
	 */
	public String getLoginEtu() {
		return loginEtu;
	}
	/**
	 * @param loginEtu The loginEtu to set.
	 */
	public void setLoginEtu(String loginEtu) {
		this.loginEtu = loginEtu;
	}
	
	/**
	 * @return Returns the annee.
	 */
	public String getAnnee() {
		return annee;
	}
	/**
	 * @param annee The annee to set.
	 */
	public void setAnnee(String annee) {
		this.annee = annee;
	}
	/**
	 * @return Returns the niveau.
	 */
	public String getNiveau() {
		return niveau;
	}
	/**
	 * @param niveau The niveau to set.
	 */
	public void setNiveau(String niveau) {
		this.niveau = niveau;
	}
}
