package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.connectors.ApogeeConnector;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.connectors.ConnectorException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * <p>RenderStatic</p>
 * <p>Sub-channel pour les pages statiques de la channel CMonDossierWeb</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 *
 */
public class RenderStatic extends SubChannel {

	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Objet Personne slectionn dans le servant Annuaire
	private Personne pers;
		
	/**
	 * Constructeur
	 * @param main
	 */
	public RenderStatic(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}

	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
		
		// si 'autre dossier' slectionn
		if (runtimeData.getParameter("autre") != null) {
			owner.redirect(runtimeData,runtimeData.getParameter("autre"));
			return Boolean.FALSE;
		}
		
		return res;
	}
		
	/**
	 * init appel au retour du servant Annuaire
	 * 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechCOD_IND(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
	
		// rcupration du login d'une personne 
		String pers_id = null;
		if (owner.getServantResults() != null) {
			pers = (Personne)(owner.getServantResults()[0]);
			pers_id = pers.getIdentifiant();
		}
		
		if (pers_id != null) {
			owner.setCod_ind(getCodInd(pers_id));
			owner.setLoginEtu(pers_id);
			// on redirige vers le servant MonDossierWeb
			owner.redirect(rd,"servantMonDossierWeb");
		}	
		else 
			owner.redirect(rd,"default");

		return Boolean.FALSE;
	}	
	
	/**
	 * Rcupration du cod_ind 
	 * 
	 */
	public String getCodInd(String pers_id) {
		String cod_ind = null;
		
		// on rcupre le cod_ind via le connecteur Apogee
		try {
			//cod_ind = ApogeeConnector.getCOD_IND(pers_id);
			cod_ind = ApogeeConnector.getCOD_INDFromLogin(pers_id);
		} 
		catch (ConnectorException e1) {
			// enregistrement plugin fatalError
			FatalError.fatalError(owner, "Le code Individu n'est pas renseign");
			return null;
		}
		
		return cod_ind;
	}
	
}
