package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.ConfigChannel;

/**
 * 
 * <p>ConfigChannel</p>
 * <p>Classe permettant d'accder  la configuration de la channel CMonDossierWebEns</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 *
 */
public class Config extends ConfigChannel
{ 
	//dclaration des variables de la classe
	private static Config singleton = null;
	// log
	private static final Log log = LogFactory.getLog(Config.class);
	// extension des adresses mail tudiantes
	private String extMail;
	// message d'interdiction
	private String msgInterdit;
	// utilisation des logins Apogee pour le contrle d'accs au canal
	private boolean loginApogee;
		
	/**
	* 
	* @return ConfigChannel Instance
	* @throws IOException
	* @throws JspException
	*/
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CMonDossierWebEns/CMonDossierWebEns.xml";
	}
	
	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {
		dig.addCallMethod("config","addRoot",2);	
		dig.addCallParam("config/extMail",0);
		dig.addCallParam("config/msgInterdit",1);
		dig.addCallMethod("config/loginApogee","addLoginApogee",1);
	    dig.addCallParam("config/loginApogee",0,"value");
	}
	
	/**
	* 
	* @param extMail Parameter of file CMonDossierWebEns.xml
	* @param msgInterdit Parameter of file CMonDossierWebEns.xml
	* 
	*/
	public void addRoot(String extMail, String msgInterdit){
		this.extMail = extMail;
		this.msgInterdit = msgInterdit;
	}
	
	/**
	* 
	* @param extMail Parameter of file CMonDossierWebEns.xml
	* @param msgInterdit Parameter of file CMonDossierWebEns.xml
	* 
	*/
	public void addLoginApogee(String value){
		if (value.equals("false"))
			this.loginApogee = false;
		else
			this.loginApogee = true;
	}
	
	/**
	 * @return Returns the extMail.
	 */
	public String getExtMail() {
		return extMail;
	}
	
	/**
	 * @param extMail The extMail to set.
	 */
	public void setExtMail(String extMail) {
		this.extMail = extMail;
	}
	
	/**
	 * @return Returns the msgInterdit.
	 */
	public String getMsgInterdit() {
		return msgInterdit;
	}
	
	/**
	 * @param msgInterdit The msgInterdit to set.
	 */
	public void setMsgInterdit(String msgInterdit) {
		this.msgInterdit = msgInterdit;
	}
	
	/**
	 * @return Returns the loginApogee.
	 */
	public boolean getLoginApogee() {
			return loginApogee;
	}
	
	/**
	 * @param loginApogee The loginApogee to set.
	 */
	public void setLoginApogee(boolean loginApogee) {
		this.loginApogee = loginApogee;
	}
}

